/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.jet.internal.com.intellij.util.ui.UIUtil;

public class CommonBundle {
    private static Reference<ResourceBundle> ourBundle;
    public static boolean assertKeyIsFound;

    private CommonBundle() {
    }

    @NotNull
    public static String message(@NotNull @PropertyKey(resourceBundle="messages.CommonBundle") String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/CommonBundle.message must not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/CommonBundle.message must not be null");
        }
        String string = CommonBundle.message(CommonBundle.getCommonBundle(), key, params);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/CommonBundle.message must not return null");
        }
        return string;
    }

    private static ResourceBundle getCommonBundle() {
        ResourceBundle bundle = null;
        if (ourBundle != null) {
            bundle = ourBundle.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("messages.CommonBundle");
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, String key, @Nullable String defaultValue, Object ... params) {
        String value;
        block5: {
            if (bundle == null) {
                return defaultValue;
            }
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (defaultValue != null) {
                    value = defaultValue;
                }
                value = "!" + key + "!";
                if (!assertKeyIsFound || $assertionsDisabled) break block5;
                throw new AssertionError((Object)(key + " is not found in " + "messages.CommonBundle"));
            }
        }
        value = UIUtil.replaceMnemonicAmpersand(value);
        if (params.length > 0 && value.indexOf(123) >= 0) {
            return MessageFormat.format(value, params);
        }
        return value;
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/CommonBundle.message must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/CommonBundle.message must not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/CommonBundle.message must not be null");
        }
        String string = CommonBundle.messageOrDefault(bundle, key, null, params);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/CommonBundle.message must not return null");
        }
        return string;
    }

    @NotNull
    public static String getCancelButtonText() {
        String string = CommonBundle.message("button.cancel", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/CommonBundle.getCancelButtonText must not return null");
        }
        return string;
    }

    public static String getBackgroundButtonText() {
        return CommonBundle.message("button.background", new Object[0]);
    }

    public static String getHelpButtonText() {
        return CommonBundle.message("button.help", new Object[0]);
    }

    public static String getErrorTitle() {
        return CommonBundle.message("title.error", new Object[0]);
    }

    public static String getWarningTitle() {
        return CommonBundle.message("title.warning", new Object[0]);
    }

    public static String getLoadingTreeNodeText() {
        return CommonBundle.message("tree.node.loading", new Object[0]);
    }

    public static String getOkButtonText() {
        return CommonBundle.message("button.ok", new Object[0]);
    }

    public static String getYesButtonText() {
        return CommonBundle.message("button.yes", new Object[0]);
    }

    public static String getNoButtonText() {
        return CommonBundle.message("button.no", new Object[0]);
    }

    public static String getContinueButtonText() {
        return CommonBundle.message("button.continue", new Object[0]);
    }

    public static String getYesForAllButtonText() {
        return CommonBundle.message("button.yes.for.all", new Object[0]);
    }

    public static String getCloseButtonText() {
        return CommonBundle.message("button.close", new Object[0]);
    }

    public static String getNoForAllButtonText() {
        return CommonBundle.message("button.no.for.all", new Object[0]);
    }

    public static String getApplyButtonText() {
        return CommonBundle.message("button.apply", new Object[0]);
    }

    static {
        assertKeyIsFound = false;
    }
}

