/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.jstype;

import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.rhino.ErrorReporter;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.BooleanLiteralSet;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticScope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.TernaryValue;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.Visitor;

public class UnknownType
extends ObjectType {
    private final boolean isChecked;

    UnknownType(JSTypeRegistry registry, boolean isChecked) {
        super(registry);
        this.isChecked = isChecked;
    }

    @Override
    public ObjectType.Property getSlot(String name) {
        return null;
    }

    @Override
    public boolean isUnknownType() {
        return true;
    }

    @Override
    public boolean isCheckedUnknownType() {
        return this.isChecked;
    }

    @Override
    public boolean canAssignTo(JSType that) {
        return true;
    }

    @Override
    public boolean canBeCalled() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        return TernaryValue.UNKNOWN;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return true;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnknownType();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return this.getReferenceName();
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return true;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    public int getPropertiesCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    void collectPropertyNames(Set<String> props) {
    }

    @Override
    public JSType getPropertyType(String propertyName) {
        return this;
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return true;
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public String getReferenceName() {
        return this.isChecked ? "??" : "?";
    }

    @Override
    public String getDisplayName() {
        return "Unknown";
    }

    @Override
    public boolean hasDisplayName() {
        return true;
    }

    @Override
    public boolean isPropertyTypeDeclared(String propertyName) {
        return false;
    }

    @Override
    public boolean isPropertyTypeInferred(String propertyName) {
        return false;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        return this;
    }
}

