/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.jstype;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.UnionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.UnknownType;

class UnionTypeBuilder
implements Serializable {
    private final JSTypeRegistry registry;
    private final List<JSType> alternates = Lists.newArrayList();
    private boolean isAllType = false;
    private boolean isNativeUnknownType = false;
    private boolean areAllUnknownsChecked = true;
    private final int maxUnionSize;
    private int functionTypePosition = -1;
    private JSType result = null;

    UnionTypeBuilder(JSTypeRegistry registry) {
        this(registry, 20);
    }

    UnionTypeBuilder(JSTypeRegistry registry, int maxUnionSize) {
        this.registry = registry;
        this.maxUnionSize = maxUnionSize;
    }

    Iterable<JSType> getAlternates() {
        JSType specialCaseType = this.reduceAlternatesWithoutUnion();
        if (specialCaseType != null) {
            return ImmutableList.of(specialCaseType);
        }
        return Collections.unmodifiableList(this.alternates);
    }

    UnionTypeBuilder addAlternate(JSType alternate) {
        if (alternate.isNoType()) {
            return this;
        }
        this.isAllType = this.isAllType || alternate.isAllType();
        boolean isAlternateUnknown = alternate instanceof UnknownType;
        boolean bl = this.isNativeUnknownType = this.isNativeUnknownType || isAlternateUnknown;
        if (isAlternateUnknown) {
            boolean bl2 = this.areAllUnknownsChecked = this.areAllUnknownsChecked && alternate.isCheckedUnknownType();
        }
        if (!this.isAllType && !this.isNativeUnknownType) {
            if (alternate.isUnionType()) {
                UnionType union = alternate.toMaybeUnionType();
                for (JSType unionAlt : union.getAlternates()) {
                    this.addAlternate(unionAlt);
                }
            } else {
                if (this.alternates.size() > this.maxUnionSize) {
                    return this;
                }
                if (alternate.isFunctionType() && this.functionTypePosition != -1) {
                    FunctionType other = this.alternates.get(this.functionTypePosition).toMaybeFunctionType();
                    FunctionType supremum = alternate.toMaybeFunctionType().supAndInfHelper(other, true);
                    this.alternates.set(this.functionTypePosition, supremum);
                    this.result = null;
                    return this;
                }
                int currentIndex = 0;
                Iterator<JSType> it = this.alternates.iterator();
                while (it.hasNext()) {
                    JSType current = it.next();
                    if (alternate.isUnknownType() || current.isUnknownType() || alternate.isNoResolvedType() || current.isNoResolvedType()) {
                        if (alternate.isEquivalentTo(current)) {
                            return this;
                        }
                    } else {
                        if (alternate.isSubtype(current)) {
                            return this;
                        }
                        if (current.isSubtype(alternate)) {
                            it.remove();
                            if (currentIndex == this.functionTypePosition) {
                                this.functionTypePosition = -1;
                            } else if (currentIndex < this.functionTypePosition) {
                                --this.functionTypePosition;
                                --currentIndex;
                            }
                        }
                    }
                    ++currentIndex;
                }
                if (alternate.isFunctionType()) {
                    Preconditions.checkState(this.functionTypePosition == -1);
                    this.functionTypePosition = this.alternates.size();
                }
                this.alternates.add(alternate);
                this.result = null;
            }
        } else {
            this.result = null;
        }
        return this;
    }

    private JSType reduceAlternatesWithoutUnion() {
        if (this.isAllType) {
            return this.registry.getNativeType(JSTypeNative.ALL_TYPE);
        }
        if (this.isNativeUnknownType) {
            if (this.areAllUnknownsChecked) {
                return this.registry.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        int size = this.alternates.size();
        if (size > this.maxUnionSize) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (size > 1) {
            return null;
        }
        if (size == 1) {
            return this.alternates.iterator().next();
        }
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    JSType build() {
        if (this.result == null) {
            this.result = this.reduceAlternatesWithoutUnion();
            if (this.result == null) {
                this.result = new UnionType(this.registry, this.getAlternateListCopy());
            }
        }
        return this.result;
    }

    private Collection<JSType> getAlternateListCopy() {
        return ImmutableList.copyOf(this.alternates);
    }
}

