/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.jstype;

import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;

public class RecordTypeBuilder {
    private boolean isEmpty = true;
    private final JSTypeRegistry registry;
    private final HashMap<String, RecordProperty> properties = Maps.newHashMap();

    public RecordTypeBuilder(JSTypeRegistry registry) {
        this.registry = registry;
    }

    public RecordTypeBuilder addProperty(String name, JSType type, Node propertyNode) {
        this.isEmpty = false;
        if (this.properties.containsKey(name)) {
            return null;
        }
        this.properties.put(name, new RecordProperty(type, propertyNode));
        return this;
    }

    public JSType build() {
        if (this.isEmpty) {
            return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        }
        return this.registry.createRecordType(Collections.unmodifiableMap(this.properties));
    }

    static class RecordProperty {
        private final JSType type;
        private final Node propertyNode;

        RecordProperty(JSType type, Node propertyNode) {
            this.type = type;
            this.propertyNode = propertyNode;
        }

        public JSType getType() {
            return this.type;
        }

        public Node getPropertyNode() {
            return this.propertyNode;
        }
    }
}

