/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.jstype;

import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.rhino.ErrorReporter;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.EnumElementType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.EnumType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.RecordType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticScope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.TernaryValue;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.UnionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.Visitor;

class ProxyObjectType
extends ObjectType {
    private JSType referencedType;
    private ObjectType referencedObjType;

    ProxyObjectType(JSTypeRegistry registry, JSType referencedType) {
        super(registry);
        this.setReferencedType(referencedType);
    }

    @Override
    public ObjectType.Property getSlot(String name) {
        if (this.referencedObjType != null) {
            return this.referencedObjType.getSlot(name);
        }
        return null;
    }

    JSType getReferencedTypeInternal() {
        return this.referencedType;
    }

    ObjectType getReferencedObjTypeInternal() {
        return this.referencedObjType;
    }

    void setReferencedType(JSType referencedType) {
        this.referencedType = referencedType;
        this.referencedObjType = referencedType instanceof ObjectType ? (ObjectType)referencedType : null;
    }

    @Override
    public String getReferenceName() {
        return this.referencedObjType == null ? "" : this.referencedObjType.getReferenceName();
    }

    @Override
    public boolean hasReferenceName() {
        return this.referencedObjType == null ? null : Boolean.valueOf(this.referencedObjType.hasReferenceName());
    }

    @Override
    public boolean matchesNumberContext() {
        return this.referencedType.matchesNumberContext();
    }

    @Override
    public boolean matchesStringContext() {
        return this.referencedType.matchesStringContext();
    }

    @Override
    public boolean matchesObjectContext() {
        return this.referencedType.matchesObjectContext();
    }

    @Override
    public boolean canBeCalled() {
        return this.referencedType.canBeCalled();
    }

    @Override
    public boolean isNoType() {
        return this.referencedType.isNoType();
    }

    @Override
    public boolean isNoObjectType() {
        return this.referencedType.isNoObjectType();
    }

    @Override
    public boolean isNoResolvedType() {
        return this.referencedType.isNoResolvedType();
    }

    @Override
    public boolean isUnknownType() {
        return this.referencedType.isUnknownType();
    }

    @Override
    public boolean isCheckedUnknownType() {
        return this.referencedType.isCheckedUnknownType();
    }

    @Override
    public boolean isNullable() {
        return this.referencedType.isNullable();
    }

    @Override
    public EnumType toMaybeEnumType() {
        return this.referencedType.toMaybeEnumType();
    }

    @Override
    public boolean isConstructor() {
        return this.referencedType.isConstructor();
    }

    @Override
    public boolean isNominalType() {
        return this.referencedType.isNominalType();
    }

    @Override
    public boolean isInstanceType() {
        return this.referencedType.isInstanceType();
    }

    @Override
    public boolean isInterface() {
        return this.referencedType.isInterface();
    }

    @Override
    public boolean isOrdinaryFunction() {
        return this.referencedType.isOrdinaryFunction();
    }

    @Override
    public boolean isAllType() {
        return this.referencedType.isAllType();
    }

    @Override
    public boolean isNativeObjectType() {
        return this.referencedObjType == null ? false : this.referencedObjType.isNativeObjectType();
    }

    @Override
    RecordType toMaybeRecordType() {
        return this.referencedType.toMaybeRecordType();
    }

    @Override
    public UnionType toMaybeUnionType() {
        return this.referencedType.toMaybeUnionType();
    }

    @Override
    public FunctionType toMaybeFunctionType() {
        return this.referencedType.toMaybeFunctionType();
    }

    @Override
    public EnumElementType toMaybeEnumElementType() {
        return this.referencedType.toMaybeEnumElementType();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        return this.referencedType.testForEquality(that);
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.referencedType.isSubtype(that);
    }

    @Override
    public FunctionType getOwnerFunction() {
        return this.referencedObjType == null ? null : this.referencedObjType.getOwnerFunction();
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.referencedObjType == null ? Collections.emptyList() : this.referencedObjType.getCtorImplementedInterfaces();
    }

    @Override
    public boolean canAssignTo(JSType that) {
        return this.referencedType.canAssignTo(that);
    }

    @Override
    public boolean isEquivalentTo(JSType that) {
        if (this == that) {
            return true;
        }
        return this.referencedType.isEquivalentTo(that);
    }

    @Override
    public int hashCode() {
        return this.referencedType.hashCode();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return this.referencedType.toStringHelper(forAnnotations);
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.referencedObjType == null ? null : this.referencedObjType.getImplicitPrototype();
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return this.referencedObjType == null ? true : this.referencedObjType.defineProperty(propertyName, type, inferred, propertyNode);
    }

    @Override
    public boolean removeProperty(String name) {
        return this.referencedObjType == null ? false : this.referencedObjType.removeProperty(name);
    }

    @Override
    public boolean isPropertyTypeDeclared(String propertyName) {
        return this.referencedObjType == null ? false : this.referencedObjType.isPropertyTypeDeclared(propertyName);
    }

    @Override
    public Node getPropertyNode(String propertyName) {
        return this.referencedObjType == null ? null : this.referencedObjType.getPropertyNode(propertyName);
    }

    @Override
    public boolean isPropertyTypeInferred(String propertyName) {
        return this.referencedObjType == null ? false : this.referencedObjType.isPropertyTypeInferred(propertyName);
    }

    @Override
    public boolean isPropertyInExterns(String propertyName) {
        return this.referencedObjType == null ? false : this.referencedObjType.isPropertyInExterns(propertyName);
    }

    @Override
    public int getPropertiesCount() {
        return this.referencedObjType == null ? 0 : this.referencedObjType.getPropertiesCount();
    }

    @Override
    protected void collectPropertyNames(Set<String> props) {
        if (this.referencedObjType != null) {
            this.referencedObjType.collectPropertyNames(props);
        }
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        return this.referencedType.findPropertyType(propertyName);
    }

    @Override
    public JSType getPropertyType(String propertyName) {
        return this.referencedObjType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : this.referencedObjType.getPropertyType(propertyName);
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.referencedType.getJSDocInfo();
    }

    @Override
    public void setJSDocInfo(JSDocInfo info) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setJSDocInfo(info);
        }
    }

    @Override
    public JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        return this.referencedObjType == null ? null : this.referencedObjType.getOwnPropertyJSDocInfo(propertyName);
    }

    @Override
    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setPropertyJSDocInfo(propertyName, info);
        }
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.referencedObjType == null ? false : this.referencedObjType.hasProperty(propertyName);
    }

    @Override
    public boolean hasOwnProperty(String propertyName) {
        return this.referencedObjType == null ? false : this.referencedObjType.hasOwnProperty(propertyName);
    }

    @Override
    public Set<String> getOwnPropertyNames() {
        return this.referencedObjType == null ? ImmutableSet.of() : this.referencedObjType.getOwnPropertyNames();
    }

    @Override
    public FunctionType getConstructor() {
        return this.referencedObjType == null ? null : this.referencedObjType.getConstructor();
    }

    @Override
    public JSType getParameterType() {
        return this.referencedObjType == null ? null : this.referencedObjType.getParameterType();
    }

    @Override
    public JSType getIndexType() {
        return this.referencedObjType == null ? null : this.referencedObjType.getIndexType();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return this.referencedType.visit(visitor);
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.setReferencedType(this.referencedType.resolve(t, scope));
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        return "{proxy:" + this.referencedType.toDebugHashCodeString() + "}";
    }

    @Override
    public ObjectType getTypeOfThis() {
        if (this.referencedObjType != null) {
            return this.referencedObjType.getTypeOfThis();
        }
        return super.getTypeOfThis();
    }

    @Override
    public JSType collapseUnion() {
        if (this.referencedType.isUnionType()) {
            return this.referencedType.collapseUnion();
        }
        return this;
    }

    @Override
    public void matchConstraint(ObjectType contraint) {
        this.referencedType.matchConstraint(contraint);
    }
}

