/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.jstype;

import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.BooleanLiteralSet;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticReference;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticScope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSlot;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSourceFile;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.TernaryValue;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.Visitor;

public abstract class ObjectType
extends JSType
implements StaticScope<JSType> {
    private boolean visited;
    private JSDocInfo docInfo = null;
    private boolean unknown = true;

    ObjectType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    public Node getRootNode() {
        return null;
    }

    public ObjectType getParentScope() {
        return this.getImplicitPrototype();
    }

    public abstract Property getSlot(String var1);

    public Property getOwnSlot(String name) {
        if (this.hasOwnProperty(name)) {
            return this.getSlot(name);
        }
        return null;
    }

    @Override
    public ObjectType getTypeOfThis() {
        return null;
    }

    public JSType getParameterType() {
        return null;
    }

    public JSType getIndexType() {
        return null;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        if (this.docInfo != null) {
            return this.docInfo;
        }
        if (this.getImplicitPrototype() != null) {
            return this.getImplicitPrototype().getJSDocInfo();
        }
        return super.getJSDocInfo();
    }

    public void setJSDocInfo(JSDocInfo info) {
        this.docInfo = info;
    }

    final boolean detectImplicitPrototypeCycle() {
        ObjectType p;
        this.visited = true;
        for (p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (p.visited) {
                return true;
            }
            p.visited = true;
        }
        p = this;
        do {
            p.visited = false;
        } while ((p = p.getImplicitPrototype()) != null);
        return false;
    }

    public abstract String getReferenceName();

    public String getNormalizedReferenceName() {
        int pos;
        String name = this.getReferenceName();
        if (name != null && (pos = name.indexOf("(")) != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    @Override
    public String getDisplayName() {
        return this.getNormalizedReferenceName();
    }

    public static String createDelegateSuffix(String suffix) {
        return "(" + suffix + ")";
    }

    public boolean hasReferenceName() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isSubtype(this.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    public abstract FunctionType getConstructor();

    public abstract ObjectType getImplicitPrototype();

    public final boolean defineDeclaredProperty(String propertyName, JSType type, Node propertyNode) {
        boolean result = this.defineProperty(propertyName, type, false, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    public final boolean defineInferredProperty(String propertyName, JSType type, Node propertyNode) {
        if (this.hasProperty(propertyName)) {
            JSType originalType = this.getPropertyType(propertyName);
            type = originalType == null ? type : originalType.getLeastSupertype(type);
        }
        boolean result = this.defineProperty(propertyName, type, true, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    abstract boolean defineProperty(String var1, JSType var2, boolean var3, Node var4);

    public boolean removeProperty(String propertyName) {
        return false;
    }

    public Node getPropertyNode(String propertyName) {
        return null;
    }

    public JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        return null;
    }

    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        return this.hasProperty(propertyName) ? this.getPropertyType(propertyName) : null;
    }

    public abstract JSType getPropertyType(String var1);

    public abstract boolean hasProperty(String var1);

    public boolean hasOwnProperty(String propertyName) {
        return this.hasProperty(propertyName);
    }

    public Set<String> getOwnPropertyNames() {
        return ImmutableSet.of();
    }

    public abstract boolean isPropertyTypeInferred(String var1);

    public abstract boolean isPropertyTypeDeclared(String var1);

    boolean hasOwnDeclaredProperty(String name) {
        return this.hasOwnProperty(name) && this.isPropertyTypeDeclared(name);
    }

    public boolean isPropertyInExterns(String propertyName) {
        return false;
    }

    public abstract int getPropertiesCount();

    public Set<String> getPropertyNames() {
        TreeSet<String> props = Sets.newTreeSet();
        this.collectPropertyNames(props);
        return props;
    }

    abstract void collectPropertyNames(Set<String> var1);

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    final boolean isImplicitPrototype(ObjectType prototype) {
        for (ObjectType current = this; current != null; current = current.getImplicitPrototype()) {
            if (!current.isEquivalentTo(prototype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    public boolean isUnknownType() {
        if (this.unknown) {
            ObjectType implicitProto = this.getImplicitPrototype();
            if (implicitProto == null || implicitProto.isNativeObjectType()) {
                this.unknown = false;
                for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
                    if (!interfaceType.isUnknownType()) continue;
                    this.unknown = true;
                    break;
                }
            } else {
                this.unknown = implicitProto.isUnknownType();
            }
        }
        return this.unknown;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public boolean hasCachedValues() {
        return !this.unknown;
    }

    public void clearCachedValues() {
        this.unknown = true;
    }

    public boolean isNativeObjectType() {
        return false;
    }

    public static ObjectType cast(JSType type) {
        return type == null ? null : type.toObjectType();
    }

    @Override
    public final boolean isFunctionPrototypeType() {
        return this.getOwnerFunction() != null;
    }

    public FunctionType getOwnerFunction() {
        return null;
    }

    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return ImmutableSet.of();
    }

    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return ImmutableSet.of();
    }

    public static final class Property
    implements Serializable,
    StaticReference<JSType>,
    StaticSlot<JSType> {
        private final String name;
        private JSType type;
        private final boolean inferred;
        private Node propertyNode;
        private JSDocInfo docInfo = null;

        Property(String name, JSType type, boolean inferred, Node propertyNode) {
            this.name = name;
            this.type = type;
            this.inferred = inferred;
            this.propertyNode = propertyNode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Node getNode() {
            return this.propertyNode;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.propertyNode == null ? null : this.propertyNode.getStaticSourceFile();
        }

        public Property getSymbol() {
            return this;
        }

        public Property getDeclaration() {
            return this.propertyNode == null ? null : this;
        }

        @Override
        public JSType getType() {
            return this.type;
        }

        @Override
        public boolean isTypeInferred() {
            return this.inferred;
        }

        boolean isFromExterns() {
            return this.propertyNode == null ? false : this.propertyNode.isFromExterns();
        }

        void setType(JSType type) {
            this.type = type;
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return this.docInfo;
        }

        void setJSDocInfo(JSDocInfo info) {
            this.docInfo = info;
        }

        public void setNode(Node n) {
            this.propertyNode = n;
        }
    }
}

