/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.jstype;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.rhino.ErrorReporter;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.EnumElementType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.PrototypeObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticScope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.TernaryValue;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.Visitor;

public class EnumType
extends PrototypeObjectType {
    private final Node source;
    private EnumElementType elementsType;
    private final Set<String> elements = new HashSet<String>();

    EnumType(JSTypeRegistry registry, String name, Node source, JSType elementsType) {
        super(registry, "enum{" + name + "}", null);
        this.source = source;
        this.elementsType = new EnumElementType(registry, elementsType, name);
    }

    public Node getSource() {
        return this.source;
    }

    @Override
    public EnumType toMaybeEnumType() {
        return this;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    public Set<String> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public boolean defineElement(String name, Node definingNode) {
        this.elements.add(name);
        return this.defineDeclaredProperty(name, this.elementsType, definingNode);
    }

    public EnumElementType getElementsType() {
        return this.elementsType;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        return this.isEquivalentTo(that) ? TernaryValue.TRUE : TernaryValue.FALSE;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return that.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_TYPE)) || that.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_PROTOTYPE)) || JSType.isSubtypeHelper(this, that);
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return forAnnotations ? "Object" : this.getReferenceName();
    }

    @Override
    public String getDisplayName() {
        return this.elementsType.getDisplayName();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.elementsType = (EnumElementType)this.elementsType.resolve(t, scope);
        return super.resolveInternal(t, scope);
    }
}

