/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.jstype;

import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.BooleanLiteralSet;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.TernaryValue;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ValueType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.Visitor;

public class BooleanType
extends ValueType {
    BooleanType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isUnknownType() || that.isSubtype(this.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN)) || that.isObject()) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    @Override
    public boolean isBooleanValueType() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public JSType autoboxesTo() {
        return this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE);
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return "boolean";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseBooleanType();
    }
}

