/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino.head;

import java.util.EnumMap;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.BaseFunction;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.Context;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.Function;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.IdScriptableObject;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ScriptRuntime;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.Scriptable;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ScriptableObject;

public class TopLevel
extends IdScriptableObject {
    private EnumMap<Builtins, BaseFunction> ctors;

    @Override
    public String getClassName() {
        return "global";
    }

    public void cacheBuiltins() {
        this.ctors = new EnumMap(Builtins.class);
        for (Builtins builtin : Builtins.values()) {
            Object value = ScriptableObject.getProperty((Scriptable)this, builtin.name());
            if (!(value instanceof BaseFunction)) continue;
            this.ctors.put(builtin, (BaseFunction)value);
        }
    }

    public static Function getBuiltinCtor(Context cx, Scriptable scope, Builtins type) {
        BaseFunction result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinCtor(type)) != null) {
            return result;
        }
        return ScriptRuntime.getExistingCtor(cx, scope, type.name());
    }

    public static Scriptable getBuiltinPrototype(Scriptable scope, Builtins type) {
        Scriptable result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinPrototype(type)) != null) {
            return result;
        }
        return ScriptableObject.getClassPrototype(scope, type.name());
    }

    public BaseFunction getBuiltinCtor(Builtins type) {
        return this.ctors != null ? this.ctors.get((Object)type) : null;
    }

    public Scriptable getBuiltinPrototype(Builtins type) {
        BaseFunction func = this.getBuiltinCtor(type);
        Object proto = func != null ? func.getPrototypeProperty() : null;
        return proto instanceof Scriptable ? (Scriptable)proto : null;
    }

    public static enum Builtins {
        Object,
        Array,
        Function,
        String,
        Number,
        Boolean,
        RegExp,
        Error;

    }
}

