/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.rhino.ErrorReporter;

public class SimpleErrorReporter
implements ErrorReporter {
    private List<String> warnings = null;
    private List<String> errors = null;

    @Override
    public void warning(String message, String sourceName, int line, int lineOffset) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(this.formatDetailedMessage(message, sourceName, line, lineOffset));
    }

    @Override
    public void error(String message, String sourceName, int line, int lineOffset) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(this.formatDetailedMessage(message, sourceName, line, lineOffset));
    }

    public List<String> errors() {
        return this.errors;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    private String formatDetailedMessage(String message, String sourceName, int lineNumber, int lineOffset) {
        String details = message;
        if (sourceName == null || lineNumber <= 0) {
            return details;
        }
        StringBuilder buf = new StringBuilder(details);
        buf.append(" (");
        if (sourceName != null) {
            buf.append(sourceName);
        }
        if (lineNumber > 0) {
            buf.append('#');
            buf.append(lineNumber);
        }
        buf.append(')');
        return buf.toString();
    }
}

