/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.rhino;

import closurecompiler.internal.com.google.common.base.Preconditions;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

public class IR {
    private IR() {
    }

    public static Node empty() {
        return new Node(124);
    }

    public static Node function(Node name, Node params, Node body) {
        Preconditions.checkState(name.isName());
        Preconditions.checkState(params.isParamList());
        Preconditions.checkState(body.isBlock());
        return new Node(105, name, params, body);
    }

    public static Node paramList() {
        return new Node(83);
    }

    public static Node paramList(Node param) {
        Preconditions.checkState(param.isName());
        return new Node(83, param);
    }

    public static Node paramList(Node ... params) {
        Node paramList = IR.paramList();
        for (Node param : params) {
            Preconditions.checkState(param.isName());
            paramList.addChildToBack(param);
        }
        return paramList;
    }

    public static Node paramList(List<Node> params) {
        Node paramList = IR.paramList();
        for (Node param : params) {
            Preconditions.checkState(param.isName());
            paramList.addChildToBack(param);
        }
        return paramList;
    }

    public static Node block() {
        Node block = new Node(125);
        return block;
    }

    public static Node block(Node stmt) {
        Preconditions.checkState(IR.mayBeStatement(stmt));
        Node block = new Node(125, stmt);
        return block;
    }

    public static Node block(Node ... stmts) {
        Node block = new Node(125);
        for (Node stmt : stmts) {
            Preconditions.checkState(IR.mayBeStatement(stmt));
            block.addChildToBack(stmt);
        }
        return block;
    }

    public static Node script(Node ... stmts) {
        Node block = new Node(132);
        for (Node stmt : stmts) {
            Preconditions.checkState(IR.mayBeStatement(stmt));
            block.addChildToBack(stmt);
        }
        return block;
    }

    public static Node var(Node name, Node value) {
        Preconditions.checkState(name.isName() && !name.hasChildren());
        Preconditions.checkState(IR.mayBeExpression(value));
        name.addChildToFront(value);
        return IR.var(name);
    }

    public static Node var(Node name) {
        Preconditions.checkState(name.isName());
        return new Node(118, name);
    }

    public static Node returnNode() {
        return new Node(4);
    }

    public static Node returnNode(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(4, expr);
    }

    public static Node throwNode(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(49, expr);
    }

    public static Node exprResult(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(130, expr);
    }

    public static Node ifNode(Node cond, Node then) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(then.isBlock());
        return new Node(108, cond, then);
    }

    public static Node ifNode(Node cond, Node then, Node elseNode) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(then.isBlock());
        Preconditions.checkState(elseNode.isBlock());
        return new Node(108, cond, then, elseNode);
    }

    public static Node doNode(Node body, Node cond) {
        Preconditions.checkState(body.isBlock());
        Preconditions.checkState(IR.mayBeExpression(cond));
        return new Node(114, body, cond);
    }

    public static Node forIn(Node target, Node cond, Node body) {
        Preconditions.checkState(target.isVar() || IR.mayBeExpression(target));
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(body.isBlock());
        return new Node(115, target, cond, body);
    }

    public static Node forNode(Node init, Node cond, Node incr, Node body) {
        Preconditions.checkState(init.isVar() || IR.mayBeExpressionOrEmpty(init));
        Preconditions.checkState(IR.mayBeExpressionOrEmpty(cond));
        Preconditions.checkState(IR.mayBeExpressionOrEmpty(incr));
        Preconditions.checkState(body.isBlock());
        return new Node(115, init, cond, incr, body);
    }

    public static Node switchNode(Node cond, Node ... cases) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Node switchNode = new Node(110, cond);
        for (Node caseNode : cases) {
            Preconditions.checkState(caseNode.isCase() || caseNode.isDefaultCase());
            switchNode.addChildToBack(caseNode);
        }
        return switchNode;
    }

    public static Node caseNode(Node expr, Node body) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        Preconditions.checkState(body.isBlock());
        body.putBooleanProp(38, true);
        return new Node(111, expr, body);
    }

    public static Node defaultCase(Node body) {
        Preconditions.checkState(body.isBlock());
        body.putBooleanProp(38, true);
        return new Node(112, body);
    }

    public static Node label(Node name, Node stmt) {
        Preconditions.checkState(name.isLabelName());
        Preconditions.checkState(IR.mayBeStatement(stmt));
        Node block = new Node(126, name, stmt);
        return block;
    }

    public static Node labelName(String name) {
        Preconditions.checkState(!name.isEmpty());
        return Node.newString(153, name);
    }

    public static Node tryFinally(Node tryBody, Node finallyBody) {
        Preconditions.checkState(tryBody.isLabelName());
        Preconditions.checkState(finallyBody.isLabelName());
        Node catchBody = IR.block().copyInformationFrom(tryBody);
        return new Node(77, tryBody, catchBody, finallyBody);
    }

    public static Node tryCatch(Node tryBody, Node catchNode) {
        Preconditions.checkState(tryBody.isBlock());
        Preconditions.checkState(catchNode.isCatch());
        Node catchBody = IR.block(catchNode).copyInformationFrom(catchNode);
        return new Node(77, tryBody, catchBody);
    }

    public static Node tryCatchFinally(Node tryBody, Node catchNode, Node finallyBody) {
        Preconditions.checkState(finallyBody.isBlock());
        Node tryNode = IR.tryCatch(tryBody, catchNode);
        tryNode.addChildToBack(finallyBody);
        return tryNode;
    }

    public static Node catchNode(Node expr, Node body) {
        Preconditions.checkState(expr.isName());
        Preconditions.checkState(body.isBlock());
        return new Node(120, expr, body);
    }

    public static Node breakNode() {
        return new Node(116);
    }

    public static Node breakNode(Node name) {
        Preconditions.checkState(name.isLabelName());
        return new Node(116, name);
    }

    public static Node continueNode() {
        return new Node(117);
    }

    public static Node continueNode(Node name) {
        Preconditions.checkState(name.isLabelName());
        return new Node(117, name);
    }

    public static Node call(Node target, Node ... args) {
        Node call = new Node(37, target);
        for (Node arg : args) {
            Preconditions.checkState(IR.mayBeExpression(arg));
            call.addChildToBack(arg);
        }
        return call;
    }

    public static Node newNode(Node target, Node ... args) {
        Node newcall = new Node(30, target);
        for (Node arg : args) {
            Preconditions.checkState(IR.mayBeExpression(arg));
            newcall.addChildToBack(arg);
        }
        return newcall;
    }

    public static Node name(String name) {
        return Node.newString(38, name);
    }

    public static Node getprop(Node target, Node prop) {
        Preconditions.checkState(IR.mayBeExpression(target));
        Preconditions.checkState(prop.isString());
        return new Node(33, target, prop);
    }

    public static Node getelem(Node target, Node elem) {
        Preconditions.checkState(IR.mayBeExpression(target));
        Preconditions.checkState(IR.mayBeExpression(elem));
        return new Node(35, target, elem);
    }

    public static Node assign(Node target, Node expr) {
        Preconditions.checkState(IR.isAssignmentTarget(target));
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(86, target, expr);
    }

    public static Node hook(Node cond, Node trueval, Node falseval) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(IR.mayBeExpression(trueval));
        Preconditions.checkState(IR.mayBeExpression(falseval));
        return new Node(98, cond, trueval, falseval);
    }

    public static Node comma(Node expr1, Node expr2) {
        return IR.binaryOp(85, expr1, expr2);
    }

    public static Node and(Node expr1, Node expr2) {
        return IR.binaryOp(101, expr1, expr2);
    }

    public static Node or(Node expr1, Node expr2) {
        return IR.binaryOp(100, expr1, expr2);
    }

    public static Node not(Node expr1) {
        return IR.unaryOp(26, expr1);
    }

    public static Node eq(Node expr1, Node expr2) {
        return IR.binaryOp(12, expr1, expr2);
    }

    public static Node sheq(Node expr1, Node expr2) {
        return IR.binaryOp(45, expr1, expr2);
    }

    public static Node voidNode(Node expr1) {
        return IR.unaryOp(122, expr1);
    }

    public static Node neg(Node expr1) {
        return IR.unaryOp(29, expr1);
    }

    public static Node pos(Node expr1) {
        return IR.unaryOp(28, expr1);
    }

    public static Node add(Node expr1, Node expr2) {
        return IR.binaryOp(21, expr1, expr2);
    }

    public static Node sub(Node expr1, Node expr2) {
        return IR.binaryOp(22, expr1, expr2);
    }

    public static Node objectlit(Node ... propdefs) {
        Node objectlit = new Node(64);
        for (Node propdef : propdefs) {
            Preconditions.checkState(propdef.isString() || propdef.isGetterDef() || propdef.isSetterDef());
            Preconditions.checkState(propdef.hasOneChild());
            objectlit.addChildToBack(propdef);
        }
        return objectlit;
    }

    public static Node propdef(Node string, Node value) {
        Preconditions.checkState(string.isString());
        Preconditions.checkState(!string.hasChildren());
        Preconditions.checkState(IR.mayBeExpression(value));
        string.addChildToFront(value);
        return string;
    }

    public static Node arraylit(Node ... exprs) {
        Node arraylit = new Node(63);
        for (Node expr : exprs) {
            Preconditions.checkState(IR.mayBeExpressionOrEmpty(expr));
            arraylit.addChildToBack(expr);
        }
        return arraylit;
    }

    public static Node regexp(Node expr) {
        Preconditions.checkState(expr.isString());
        return new Node(47, expr);
    }

    public static Node regexp(Node expr, Node flags) {
        Preconditions.checkState(expr.isString());
        Preconditions.checkState(flags.isString());
        return new Node(47, expr, flags);
    }

    public static Node string(String s) {
        return Node.newString(s);
    }

    public static Node number(double d) {
        return Node.newNumber(d);
    }

    public static Node thisNode() {
        return new Node(42);
    }

    public static Node trueNode() {
        return new Node(44);
    }

    public static Node falseNode() {
        return new Node(43);
    }

    public static Node nullNode() {
        return new Node(41);
    }

    private static Node binaryOp(int token, Node expr1, Node expr2) {
        Preconditions.checkState(IR.mayBeExpression(expr1));
        Preconditions.checkState(IR.mayBeExpression(expr2));
        return new Node(token, expr1, expr2);
    }

    private static Node unaryOp(int token, Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(token, expr);
    }

    private static boolean mayBeExpressionOrEmpty(Node n) {
        return n.isEmpty() || IR.mayBeExpression(n);
    }

    private static boolean isAssignmentTarget(Node n) {
        return n.isName() || n.isGetProp() || n.isGetElem();
    }

    private static boolean mayBeStatement(Node n) {
        switch (n.getType()) {
            case 105: 
            case 124: {
                return true;
            }
            case 4: 
            case 49: 
            case 77: 
            case 108: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 125: 
            case 126: 
            case 130: 
            case 149: 
            case 152: {
                return true;
            }
        }
        return false;
    }

    private static boolean mayBeExpression(Node n) {
        switch (n.getType()) {
            case 105: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 63: 
            case 64: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 122: {
                return true;
            }
        }
        return false;
    }
}

