/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing;

import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.Config;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.IRFactory;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.CompilerEnvirons;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.Context;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ErrorReporter;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.EvaluatorException;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.Parser;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.AstRoot;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSourceFile;

public class ParserRunner {
    private static Set<String> annotationNames = null;
    private static Set<String> suppressionNames = null;

    private ParserRunner() {
    }

    @Deprecated
    public static Config createConfig(boolean isIdeMode) {
        return ParserRunner.createConfig(isIdeMode, Config.LanguageMode.ECMASCRIPT3, false);
    }

    public static Config createConfig(boolean isIdeMode, Config.LanguageMode languageMode, boolean acceptConstKeyword) {
        return ParserRunner.createConfig(isIdeMode, languageMode, acceptConstKeyword, null);
    }

    public static Config createConfig(boolean isIdeMode, Config.LanguageMode languageMode, boolean acceptConstKeyword, Set<String> extraAnnotationNames) {
        Set<String> effectiveAnnotationNames;
        ParserRunner.initResourceConfig();
        if (extraAnnotationNames == null) {
            effectiveAnnotationNames = annotationNames;
        } else {
            effectiveAnnotationNames = new HashSet<String>(annotationNames);
            effectiveAnnotationNames.addAll(extraAnnotationNames);
        }
        return new Config(effectiveAnnotationNames, suppressionNames, isIdeMode, languageMode, acceptConstKeyword);
    }

    private static synchronized void initResourceConfig() {
        if (annotationNames != null) {
            return;
        }
        ResourceBundle config = ResourceBundle.getBundle("org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.ParserConfig");
        annotationNames = ParserRunner.extractList(config.getString("jsdoc.annotations"));
        suppressionNames = ParserRunner.extractList(config.getString("jsdoc.suppressions"));
    }

    private static Set<String> extractList(String configProp) {
        String[] names = configProp.split(",");
        HashSet<String> trimmedNames = Sets.newHashSet();
        for (String name : names) {
            trimmedNames.add(name.trim());
        }
        return ImmutableSet.copyOf(trimmedNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node parse(StaticSourceFile sourceFile, String sourceString, Config config, ErrorReporter errorReporter, Logger logger) throws IOException {
        Context cx = Context.enter();
        cx.setErrorReporter(errorReporter);
        cx.setLanguageVersion(150);
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(cx);
        compilerEnv.setRecordingComments(true);
        compilerEnv.setRecordingLocalJsDocComments(true);
        compilerEnv.setWarnTrailingComma(config.languageMode == Config.LanguageMode.ECMASCRIPT3);
        boolean acceptEs5 = config.isIdeMode || config.languageMode != Config.LanguageMode.ECMASCRIPT3;
        compilerEnv.setReservedKeywordAsIdentifier(acceptEs5);
        compilerEnv.setAllowKeywordAsObjectPropertyName(acceptEs5);
        compilerEnv.setAllowMemberExprAsFunctionName(false);
        compilerEnv.setIdeMode(config.isIdeMode);
        compilerEnv.setRecoverFromErrors(config.isIdeMode);
        Parser p = new Parser(compilerEnv, errorReporter);
        AstRoot astRoot = null;
        try {
            astRoot = p.parse(sourceString, sourceFile.getName(), 1);
        }
        catch (EvaluatorException e) {
            logger.info("Error parsing " + sourceFile.getName() + ": " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        Node root = null;
        if (astRoot != null) {
            root = IRFactory.transformTree(astRoot, sourceFile, sourceString, config, errorReporter);
            root.setIsSyntheticBlock(true);
        }
        return root;
    }
}

