/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.Config;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.JsDocInfoParser;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.JsDocTokenStream;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.TypeSafeDispatcher;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ErrorReporter;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.Token;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ArrayLiteral;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.Assignment;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.AstNode;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.AstRoot;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.Block;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.BreakStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.CatchClause;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.Comment;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ConditionalExpression;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ContinueStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.DoLoop;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ElementGet;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.EmptyExpression;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ExpressionStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ForInLoop;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ForLoop;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.FunctionCall;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.FunctionNode;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.IfStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.InfixExpression;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.KeywordLiteral;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.Label;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.LabeledStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.Name;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.NewExpression;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.NumberLiteral;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ObjectLiteral;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ObjectProperty;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ParenthesizedExpression;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.PropertyGet;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.RegExpLiteral;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ReturnStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.Scope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.StringLiteral;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.SwitchCase;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.SwitchStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.ThrowStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.TryStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.UnaryExpression;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.VariableDeclaration;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.VariableInitializer;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.WhileLoop;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.ast.WithStatement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSourceFile;

class IRFactory {
    private final String sourceString;
    private final StaticSourceFile sourceFile;
    private final String sourceName;
    private final Config config;
    private final ErrorReporter errorReporter;
    private final TransformDispatcher transformDispatcher;
    private final Set<String> ALLOWED_DIRECTIVES = Sets.newHashSet("use strict");
    private static final Set<String> ES5_RESERVED_KEYWORDS = ImmutableSet.of("class", "const", "enum", "export", "extends", "import", new String[]{"super"});
    private static final Set<String> ES5_STRICT_RESERVED_KEYWORDS = ImmutableSet.of("class", "const", "enum", "export", "extends", "import", new String[]{"super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
    private final Set<String> reservedKeywords;
    private final Set<Comment> parsedComments = Sets.newHashSet();
    Node rootNodeJsDocHolder = new Node(132);
    Node.FileLevelJsDocBuilder fileLevelJsDocBuilder = this.rootNodeJsDocHolder.getJsDocBuilderForNode();
    JSDocInfo fileOverviewInfo = null;
    private Node templateNode;

    private IRFactory(String sourceString, StaticSourceFile sourceFile, Config config, ErrorReporter errorReporter) {
        this.sourceString = sourceString;
        this.sourceFile = sourceFile;
        this.sourceName = sourceFile == null ? null : sourceFile.getName();
        this.config = config;
        this.errorReporter = errorReporter;
        this.transformDispatcher = new TransformDispatcher();
        this.templateNode = this.createTemplateNode();
        switch (config.languageMode) {
            case ECMASCRIPT3: {
                this.reservedKeywords = null;
                break;
            }
            case ECMASCRIPT5: {
                this.reservedKeywords = ES5_RESERVED_KEYWORDS;
                break;
            }
            case ECMASCRIPT5_STRICT: {
                this.reservedKeywords = ES5_STRICT_RESERVED_KEYWORDS;
                break;
            }
            default: {
                throw new IllegalStateException("unknown language mode");
            }
        }
    }

    private Node createTemplateNode() {
        Node templateNode = new Node(132);
        templateNode.setStaticSourceFile(this.sourceFile);
        return templateNode;
    }

    public static Node transformTree(AstRoot node, StaticSourceFile sourceFile, String sourceString, Config config, ErrorReporter errorReporter) {
        IRFactory irFactory = new IRFactory(sourceString, sourceFile, config, errorReporter);
        Node irNode = irFactory.transform(node);
        if (node.getComments() != null) {
            for (Comment comment : node.getComments()) {
                if (comment.getCommentType() == Token.CommentType.JSDOC && !irFactory.parsedComments.contains(comment)) {
                    irFactory.handlePossibleFileOverviewJsDoc(comment, irNode);
                    continue;
                }
                if (comment.getCommentType() != Token.CommentType.BLOCK_COMMENT) continue;
                irFactory.handleBlockComment(comment);
            }
        }
        irFactory.setFileOverviewJsDoc(irNode);
        return irNode;
    }

    private void setFileOverviewJsDoc(Node irNode) {
        JSDocInfo rootNodeJsDoc = this.rootNodeJsDocHolder.getJSDocInfo();
        if (rootNodeJsDoc != null) {
            irNode.setJSDocInfo(rootNodeJsDoc);
            rootNodeJsDoc.setAssociatedNode(irNode);
        }
        if (this.fileOverviewInfo != null) {
            if (irNode.getJSDocInfo() != null && irNode.getJSDocInfo().getLicense() != null) {
                this.fileOverviewInfo.setLicense(irNode.getJSDocInfo().getLicense());
            }
            irNode.setJSDocInfo(this.fileOverviewInfo);
            this.fileOverviewInfo.setAssociatedNode(irNode);
        }
    }

    private Node transformBlock(AstNode node) {
        Node irNode = this.transform(node);
        if (!irNode.isBlock()) {
            if (irNode.isEmpty()) {
                irNode.setType(125);
                irNode.setWasEmptyNode(true);
            } else {
                Node newBlock = this.newNode(125, irNode);
                newBlock.setLineno(irNode.getLineno());
                newBlock.setCharno(irNode.getCharno());
                this.maybeSetLengthFrom(newBlock, node);
                irNode = newBlock;
            }
        }
        return irNode;
    }

    private void handleBlockComment(Comment comment) {
        String value = comment.getValue();
        if (value.indexOf("/* @") != -1 || value.indexOf("\n * @") != -1) {
            this.errorReporter.warning("Non-JSDoc comment has annotations. Did you mean to start it with '/**'?", this.sourceName, comment.getLineno(), "", 0);
        }
    }

    private boolean handlePossibleFileOverviewJsDoc(JsDocInfoParser jsDocParser) {
        if (jsDocParser.getFileOverviewJSDocInfo() != this.fileOverviewInfo) {
            this.fileOverviewInfo = jsDocParser.getFileOverviewJSDocInfo();
            return true;
        }
        return false;
    }

    private void handlePossibleFileOverviewJsDoc(Comment comment, Node irNode) {
        JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment, irNode);
        this.parsedComments.add(comment);
        this.handlePossibleFileOverviewJsDoc(jsDocParser);
    }

    private JSDocInfo handleJsDoc(AstNode node, Node irNode) {
        Comment comment = node.getJsDocNode();
        if (comment != null) {
            JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment, irNode);
            this.parsedComments.add(comment);
            if (!this.handlePossibleFileOverviewJsDoc(jsDocParser)) {
                return jsDocParser.retrieveAndResetParsedJSDocInfo();
            }
        }
        return null;
    }

    private Node transform(AstNode node) {
        Node irNode = this.justTransform(node);
        JSDocInfo jsDocInfo = this.handleJsDoc(node, irNode);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, node);
        return irNode;
    }

    private Node transformNameAsString(Name node) {
        Node irNode = this.transformDispatcher.processName(node, true);
        JSDocInfo jsDocInfo = this.handleJsDoc(node, irNode);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, node);
        return irNode;
    }

    private Node transformNumberAsString(NumberLiteral literalNode) {
        Node irNode = this.newStringNode(IRFactory.getStringValue(literalNode.getNumber()));
        JSDocInfo jsDocInfo = this.handleJsDoc(literalNode, irNode);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, literalNode);
        return irNode;
    }

    private static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    private void setSourceInfo(Node irNode, AstNode node) {
        if (irNode.getLineno() == -1) {
            int lineno = node.getLineno();
            irNode.setLineno(lineno);
            int charno = this.position2charno(node.getAbsolutePosition());
            irNode.setCharno(charno);
            this.maybeSetLengthFrom(irNode, node);
        }
    }

    private JsDocInfoParser createJsDocInfoParser(Comment node, Node irNode) {
        String comment = node.getValue();
        int lineno = node.getLineno();
        int position = node.getAbsolutePosition();
        int numOpeningChars = 3;
        JsDocInfoParser jsdocParser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, this.position2charno(position) + numOpeningChars), node, irNode, this.config, this.errorReporter);
        jsdocParser.setFileLevelJsDocBuilder(this.fileLevelJsDocBuilder);
        jsdocParser.setFileOverviewJSDocInfo(this.fileOverviewInfo);
        jsdocParser.parse();
        return jsdocParser;
    }

    private void maybeSetLengthFrom(Node node, AstNode source) {
        if (this.config.isIdeMode) {
            node.setLength(source.getLength());
        }
    }

    private int position2charno(int position) {
        int lineIndex = this.sourceString.lastIndexOf(10, position);
        if (lineIndex == -1) {
            return position;
        }
        return position - lineIndex - 1;
    }

    private Node justTransform(AstNode node) {
        return (Node)this.transformDispatcher.process(node);
    }

    private static int transformTokenType(int token) {
        switch (token) {
            case 4: {
                return 4;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 27: {
                return 27;
            }
            case 28: {
                return 28;
            }
            case 29: {
                return 29;
            }
            case 30: {
                return 30;
            }
            case 31: {
                return 31;
            }
            case 32: {
                return 32;
            }
            case 33: {
                return 33;
            }
            case 36: {
                return 35;
            }
            case 38: {
                return 37;
            }
            case 39: {
                return 38;
            }
            case 40: {
                return 39;
            }
            case 41: {
                return 40;
            }
            case 42: {
                return 41;
            }
            case 43: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 45: {
                return 44;
            }
            case 46: {
                return 45;
            }
            case 47: {
                return 46;
            }
            case 48: {
                return 47;
            }
            case 50: {
                return 49;
            }
            case 52: {
                return 51;
            }
            case 53: {
                return 52;
            }
            case 65: {
                return 63;
            }
            case 66: {
                return 64;
            }
            case 81: {
                return 77;
            }
            case 87: {
                return 83;
            }
            case 89: {
                return 85;
            }
            case 90: {
                return 86;
            }
            case 91: {
                return 87;
            }
            case 92: {
                return 88;
            }
            case 93: {
                return 89;
            }
            case 94: {
                return 90;
            }
            case 95: {
                return 91;
            }
            case 96: {
                return 92;
            }
            case 97: {
                return 93;
            }
            case 98: {
                return 94;
            }
            case 99: {
                return 95;
            }
            case 100: {
                return 96;
            }
            case 101: {
                return 97;
            }
            case 102: {
                return 98;
            }
            case 104: {
                return 100;
            }
            case 105: {
                return 101;
            }
            case 106: {
                return 102;
            }
            case 107: {
                return 103;
            }
            case 109: {
                return 105;
            }
            case 112: {
                return 108;
            }
            case 114: {
                return 110;
            }
            case 115: {
                return 111;
            }
            case 116: {
                return 112;
            }
            case 117: {
                return 113;
            }
            case 118: {
                return 114;
            }
            case 119: {
                return 115;
            }
            case 120: {
                return 116;
            }
            case 121: {
                return 117;
            }
            case 122: {
                return 118;
            }
            case 123: {
                return 119;
            }
            case 124: {
                return 120;
            }
            case 126: {
                return 122;
            }
            case 128: {
                return 124;
            }
            case 129: {
                return 125;
            }
            case 130: {
                return 126;
            }
            case 133: 
            case 134: {
                return 130;
            }
            case 136: {
                return 132;
            }
            case 151: {
                return 147;
            }
            case 152: {
                return 148;
            }
            case 154: {
                return 149;
            }
            case 160: {
                return 152;
            }
        }
        throw new IllegalStateException(String.valueOf(token));
    }

    private Node newNode(int type) {
        return new Node(type).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1) {
        return new Node(type, child1).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1, Node child2) {
        return new Node(type, child1, child2).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1, Node child2, Node child3) {
        return new Node(type, child1, child2, child3).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(String value) {
        return IR.string(value).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(int type, String value) {
        return Node.newString(type, value).clonePropsFrom(this.templateNode);
    }

    private Node newNumberNode(Double value) {
        return IR.number(value).clonePropsFrom(this.templateNode);
    }

    private class TransformDispatcher
    extends TypeSafeDispatcher<Node> {
        private TransformDispatcher() {
        }

        private Node processGeneric(org.jetbrains.jet.internal.com.google.javascript.rhino.head.Node n) {
            Node node = IRFactory.this.newNode(IRFactory.transformTokenType(n.getType()));
            for (org.jetbrains.jet.internal.com.google.javascript.rhino.head.Node child : n) {
                node.addChildToBack(IRFactory.this.transform((AstNode)child));
            }
            return node;
        }

        private Node transformAsString(AstNode n) {
            Node ret;
            if (n instanceof Name) {
                ret = IRFactory.this.transformNameAsString((Name)n);
            } else if (n instanceof NumberLiteral) {
                ret = IRFactory.this.transformNumberAsString((NumberLiteral)n);
                ret.putBooleanProp(36, true);
            } else {
                ret = IRFactory.this.transform(n);
                ret.putBooleanProp(36, true);
            }
            Preconditions.checkState(ret.isString());
            return ret;
        }

        @Override
        Node processArrayLiteral(ArrayLiteral literalNode) {
            if (literalNode.isDestructuring()) {
                this.reportDestructuringAssign(literalNode);
            }
            Node node = IRFactory.this.newNode(63);
            for (AstNode child : literalNode.getElements()) {
                Node c = IRFactory.this.transform(child);
                node.addChildToBack(c);
            }
            return node;
        }

        @Override
        Node processAssignment(Assignment assignmentNode) {
            Node assign = this.processInfixExpression(assignmentNode);
            Node target = assign.getFirstChild();
            if (!this.validAssignmentTarget(target)) {
                IRFactory.this.errorReporter.error("invalid assignment target", IRFactory.this.sourceName, target.getLineno(), "", 0);
            }
            return assign;
        }

        @Override
        Node processAstRoot(AstRoot rootNode) {
            Node node = IRFactory.this.newNode(132);
            for (org.jetbrains.jet.internal.com.google.javascript.rhino.head.Node child : rootNode) {
                node.addChildToBack(IRFactory.this.transform((AstNode)child));
            }
            this.parseDirectives(node);
            return node;
        }

        private void parseDirectives(Node node) {
            HashSet<String> directives = null;
            while (this.isDirective(node.getFirstChild())) {
                String directive = node.removeFirstChild().getFirstChild().getString();
                if (directives == null) {
                    directives = Sets.newHashSet(directive);
                    continue;
                }
                directives.add(directive);
            }
            if (directives != null) {
                node.setDirectives(directives);
            }
        }

        private boolean isDirective(Node n) {
            if (n == null) {
                return false;
            }
            int nType = n.getType();
            return nType == 130 && n.getFirstChild().isString() && IRFactory.this.ALLOWED_DIRECTIVES.contains(n.getFirstChild().getString());
        }

        @Override
        Node processBlock(Block blockNode) {
            return this.processGeneric(blockNode);
        }

        @Override
        Node processBreakStatement(BreakStatement statementNode) {
            Node node = IRFactory.this.newNode(116);
            if (statementNode.getBreakLabel() != null) {
                Node labelName = IRFactory.this.transform(statementNode.getBreakLabel());
                labelName.setType(153);
                node.addChildToBack(labelName);
            }
            return node;
        }

        @Override
        Node processCatchClause(CatchClause clauseNode) {
            Name catchVar = clauseNode.getVarName();
            Node node = IRFactory.this.newNode(120, IRFactory.this.transform(catchVar));
            if (clauseNode.getCatchCondition() != null) {
                IRFactory.this.errorReporter.error("Catch clauses are not supported", IRFactory.this.sourceName, clauseNode.getCatchCondition().getLineno(), "", 0);
            }
            node.addChildToBack(IRFactory.this.transformBlock(clauseNode.getBody()));
            return node;
        }

        @Override
        Node processConditionalExpression(ConditionalExpression exprNode) {
            return IRFactory.this.newNode(98, IRFactory.this.transform(exprNode.getTestExpression()), IRFactory.this.transform(exprNode.getTrueExpression()), IRFactory.this.transform(exprNode.getFalseExpression()));
        }

        @Override
        Node processContinueStatement(ContinueStatement statementNode) {
            Node node = IRFactory.this.newNode(117);
            if (statementNode.getLabel() != null) {
                Node labelName = IRFactory.this.transform(statementNode.getLabel());
                labelName.setType(153);
                node.addChildToBack(labelName);
            }
            return node;
        }

        @Override
        Node processDoLoop(DoLoop loopNode) {
            return IRFactory.this.newNode(114, IRFactory.this.transformBlock(loopNode.getBody()), IRFactory.this.transform(loopNode.getCondition()));
        }

        @Override
        Node processElementGet(ElementGet getNode) {
            return IRFactory.this.newNode(35, IRFactory.this.transform(getNode.getTarget()), IRFactory.this.transform(getNode.getElement()));
        }

        @Override
        Node processEmptyExpression(EmptyExpression exprNode) {
            Node node = IRFactory.this.newNode(124);
            return node;
        }

        @Override
        Node processExpressionStatement(ExpressionStatement statementNode) {
            Node node = IRFactory.this.newNode(IRFactory.transformTokenType(statementNode.getType()));
            node.addChildToBack(IRFactory.this.transform(statementNode.getExpression()));
            return node;
        }

        @Override
        Node processForInLoop(ForInLoop loopNode) {
            if (loopNode.isForEach()) {
                IRFactory.this.errorReporter.error("unsupported language extension: for each", IRFactory.this.sourceName, loopNode.getLineno(), "", 0);
                return IRFactory.this.newNode(130, Node.newNumber(0.0));
            }
            return IRFactory.this.newNode(115, IRFactory.this.transform(loopNode.getIterator()), IRFactory.this.transform(loopNode.getIteratedObject()), IRFactory.this.transformBlock(loopNode.getBody()));
        }

        @Override
        Node processForLoop(ForLoop loopNode) {
            Node node = IRFactory.this.newNode(115, IRFactory.this.transform(loopNode.getInitializer()), IRFactory.this.transform(loopNode.getCondition()), IRFactory.this.transform(loopNode.getIncrement()));
            node.addChildToBack(IRFactory.this.transformBlock(loopNode.getBody()));
            return node;
        }

        @Override
        Node processFunctionCall(FunctionCall callNode) {
            Node node = IRFactory.this.newNode(IRFactory.transformTokenType(callNode.getType()), IRFactory.this.transform(callNode.getTarget()));
            for (AstNode child : callNode.getArguments()) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            node.setLineno(node.getFirstChild().getLineno());
            node.setCharno(node.getFirstChild().getCharno());
            IRFactory.this.maybeSetLengthFrom(node, callNode);
            return node;
        }

        @Override
        Node processFunctionNode(FunctionNode functionNode) {
            Name name = functionNode.getFunctionName();
            Boolean isUnnamedFunction = false;
            if (name == null) {
                int functionType = functionNode.getFunctionType();
                if (functionType != 2) {
                    IRFactory.this.errorReporter.error("unnamed function statement", IRFactory.this.sourceName, functionNode.getLineno(), "", 0);
                    return IRFactory.this.newNode(130, Node.newNumber(0.0));
                }
                name = new Name();
                name.setIdentifier("");
                isUnnamedFunction = true;
            }
            Node node = IRFactory.this.newNode(105);
            Node newName = IRFactory.this.transform(name);
            if (isUnnamedFunction.booleanValue()) {
                newName.setLineno(functionNode.getLineno());
                int lpColumn = functionNode.getAbsolutePosition() + functionNode.getLp();
                newName.setCharno(IRFactory.this.position2charno(lpColumn));
                IRFactory.this.maybeSetLengthFrom(newName, name);
            }
            node.addChildToBack(newName);
            Node lp = IRFactory.this.newNode(83);
            Name fnName = functionNode.getFunctionName();
            if (fnName != null) {
                lp.setLineno(fnName.getLineno());
            } else {
                lp.setLineno(functionNode.getLineno());
            }
            int lparenCharno = functionNode.getLp() + functionNode.getAbsolutePosition();
            lp.setCharno(IRFactory.this.position2charno(lparenCharno));
            for (AstNode param : functionNode.getParams()) {
                lp.addChildToBack(IRFactory.this.transform(param));
            }
            node.addChildToBack(lp);
            Node bodyNode = IRFactory.this.transform(functionNode.getBody());
            if (!bodyNode.isBlock()) {
                Preconditions.checkState(((IRFactory)IRFactory.this).config.isIdeMode);
                bodyNode = IR.block();
            }
            this.parseDirectives(bodyNode);
            node.addChildToBack(bodyNode);
            return node;
        }

        @Override
        Node processIfStatement(IfStatement statementNode) {
            Node node = IRFactory.this.newNode(108);
            node.addChildToBack(IRFactory.this.transform(statementNode.getCondition()));
            node.addChildToBack(IRFactory.this.transformBlock(statementNode.getThenPart()));
            if (statementNode.getElsePart() != null) {
                node.addChildToBack(IRFactory.this.transformBlock(statementNode.getElsePart()));
            }
            return node;
        }

        @Override
        Node processInfixExpression(InfixExpression exprNode) {
            Node n = IRFactory.this.newNode(IRFactory.transformTokenType(exprNode.getType()), IRFactory.this.transform(exprNode.getLeft()), IRFactory.this.transform(exprNode.getRight()));
            n.setLineno(exprNode.getLineno());
            n.setCharno(IRFactory.this.position2charno(exprNode.getAbsolutePosition()));
            IRFactory.this.maybeSetLengthFrom(n, exprNode);
            return n;
        }

        @Override
        Node processKeywordLiteral(KeywordLiteral literalNode) {
            return IRFactory.this.newNode(IRFactory.transformTokenType(literalNode.getType()));
        }

        @Override
        Node processLabel(Label labelNode) {
            return IRFactory.this.newStringNode(153, labelNode.getName());
        }

        @Override
        Node processLabeledStatement(LabeledStatement statementNode) {
            Node node = IRFactory.this.newNode(126);
            Node prev = null;
            Node cur = node;
            for (Label label : statementNode.getLabels()) {
                if (prev != null) {
                    prev.addChildToBack(cur);
                }
                cur.addChildToBack(IRFactory.this.transform(label));
                cur.setLineno(label.getLineno());
                IRFactory.this.maybeSetLengthFrom(cur, label);
                int clauseAbsolutePosition = IRFactory.this.position2charno(label.getAbsolutePosition());
                cur.setCharno(clauseAbsolutePosition);
                prev = cur;
                cur = IRFactory.this.newNode(126);
            }
            prev.addChildToBack(IRFactory.this.transform(statementNode.getStatement()));
            return node;
        }

        @Override
        Node processName(Name nameNode) {
            return this.processName(nameNode, false);
        }

        Node processName(Name nameNode, boolean asString) {
            if (asString) {
                return IRFactory.this.newStringNode(40, nameNode.getIdentifier());
            }
            if (this.isReservedKeyword(nameNode.getIdentifier())) {
                IRFactory.this.errorReporter.error("identifier is a reserved word", IRFactory.this.sourceName, nameNode.getLineno(), "", 0);
            }
            return IRFactory.this.newStringNode(38, nameNode.getIdentifier());
        }

        private boolean isReservedKeyword(String identifier) {
            return IRFactory.this.reservedKeywords != null && IRFactory.this.reservedKeywords.contains(identifier);
        }

        @Override
        Node processNewExpression(NewExpression exprNode) {
            return this.processFunctionCall(exprNode);
        }

        @Override
        Node processNumberLiteral(NumberLiteral literalNode) {
            return IRFactory.this.newNumberNode(literalNode.getNumber());
        }

        @Override
        Node processObjectLiteral(ObjectLiteral literalNode) {
            if (literalNode.isDestructuring()) {
                this.reportDestructuringAssign(literalNode);
            }
            Node node = IRFactory.this.newNode(64);
            for (ObjectProperty el : literalNode.getElements()) {
                if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                    if (el.isGetter()) {
                        this.reportGetter(el);
                        continue;
                    }
                    if (el.isSetter()) {
                        this.reportSetter(el);
                        continue;
                    }
                }
                Node key = this.transformAsString(el.getLeft());
                Node value = IRFactory.this.transform(el.getRight());
                if (el.isGetter()) {
                    key.setType(147);
                    Preconditions.checkState(value.isFunction());
                    if (this.getFnParamNode(value).hasChildren()) {
                        this.reportGetterParam(el.getLeft());
                    }
                } else if (el.isSetter()) {
                    key.setType(148);
                    Preconditions.checkState(value.isFunction());
                    if (!this.getFnParamNode(value).hasOneChild()) {
                        this.reportSetterParam(el.getLeft());
                    }
                }
                key.addChildToFront(value);
                node.addChildToBack(key);
            }
            return node;
        }

        Node getFnParamNode(Node fnNode) {
            Preconditions.checkArgument(fnNode.isFunction());
            return fnNode.getFirstChild().getNext();
        }

        @Override
        Node processObjectProperty(ObjectProperty propertyNode) {
            return this.processInfixExpression(propertyNode);
        }

        @Override
        Node processParenthesizedExpression(ParenthesizedExpression exprNode) {
            Node node = IRFactory.this.transform(exprNode.getExpression());
            node.putProp(35, Boolean.TRUE);
            return node;
        }

        @Override
        Node processPropertyGet(PropertyGet getNode) {
            Node leftChild = IRFactory.this.transform(getNode.getTarget());
            Node newNode = IRFactory.this.newNode(33, leftChild, this.transformAsString(getNode.getProperty()));
            newNode.setLineno(leftChild.getLineno());
            newNode.setCharno(leftChild.getCharno());
            IRFactory.this.maybeSetLengthFrom(newNode, getNode);
            return newNode;
        }

        @Override
        Node processRegExpLiteral(RegExpLiteral literalNode) {
            Node literalStringNode = IRFactory.this.newStringNode(literalNode.getValue());
            literalStringNode.setLineno(literalNode.getLineno());
            IRFactory.this.maybeSetLengthFrom(literalStringNode, literalNode);
            Node node = IRFactory.this.newNode(47, literalStringNode);
            String flags = literalNode.getFlags();
            if (flags != null && !flags.isEmpty()) {
                Node flagsNode = IRFactory.this.newStringNode(flags);
                flagsNode.setLineno(literalNode.getLineno());
                IRFactory.this.maybeSetLengthFrom(flagsNode, literalNode);
                node.addChildToBack(flagsNode);
            }
            return node;
        }

        @Override
        Node processReturnStatement(ReturnStatement statementNode) {
            Node node = IRFactory.this.newNode(4);
            if (statementNode.getReturnValue() != null) {
                node.addChildToBack(IRFactory.this.transform(statementNode.getReturnValue()));
            }
            return node;
        }

        @Override
        Node processScope(Scope scopeNode) {
            return this.processGeneric(scopeNode);
        }

        @Override
        Node processStringLiteral(StringLiteral literalNode) {
            String value = literalNode.getValue();
            Node n = IRFactory.this.newStringNode(value);
            if (value.indexOf(11) != -1) {
                int start = literalNode.getAbsolutePosition();
                int end = start + literalNode.getLength();
                if (start < IRFactory.this.sourceString.length() && IRFactory.this.sourceString.substring(start, Math.min(IRFactory.this.sourceString.length(), end)).indexOf("\\v") != -1) {
                    n.putBooleanProp(54, true);
                }
            }
            return n;
        }

        @Override
        Node processSwitchCase(SwitchCase caseNode) {
            Node node;
            if (caseNode.isDefault()) {
                node = IRFactory.this.newNode(112);
            } else {
                AstNode expr = caseNode.getExpression();
                node = IRFactory.this.newNode(111, IRFactory.this.transform(expr));
            }
            Node block = IRFactory.this.newNode(125);
            block.putBooleanProp(38, true);
            block.setLineno(caseNode.getLineno());
            block.setCharno(IRFactory.this.position2charno(caseNode.getAbsolutePosition()));
            IRFactory.this.maybeSetLengthFrom(block, caseNode);
            if (caseNode.getStatements() != null) {
                for (AstNode child : caseNode.getStatements()) {
                    block.addChildToBack(IRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        @Override
        Node processSwitchStatement(SwitchStatement statementNode) {
            Node node = IRFactory.this.newNode(110, IRFactory.this.transform(statementNode.getExpression()));
            for (SwitchCase child : statementNode.getCases()) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processThrowStatement(ThrowStatement statementNode) {
            return IRFactory.this.newNode(49, IRFactory.this.transform(statementNode.getExpression()));
        }

        @Override
        Node processTryStatement(TryStatement statementNode) {
            Node node = IRFactory.this.newNode(77, IRFactory.this.transformBlock(statementNode.getTryBlock()));
            Node block = IRFactory.this.newNode(125);
            boolean lineSet = false;
            for (CatchClause cc : statementNode.getCatchClauses()) {
                if (!lineSet) {
                    block.setLineno(cc.getLineno());
                    IRFactory.this.maybeSetLengthFrom(block, cc);
                    lineSet = true;
                }
                block.addChildToBack(IRFactory.this.transform(cc));
            }
            node.addChildToBack(block);
            AstNode finallyBlock = statementNode.getFinallyBlock();
            if (finallyBlock != null) {
                node.addChildToBack(IRFactory.this.transformBlock(finallyBlock));
            }
            if (!lineSet && finallyBlock != null) {
                block.setLineno(finallyBlock.getLineno());
                IRFactory.this.maybeSetLengthFrom(block, finallyBlock);
            }
            return node;
        }

        @Override
        Node processUnaryExpression(UnaryExpression exprNode) {
            String msg;
            int type = IRFactory.transformTokenType(exprNode.getType());
            Node operand = IRFactory.this.transform(exprNode.getOperand());
            if (type == 29 && operand.isNumber()) {
                operand.setDouble(-operand.getDouble());
                return operand;
            }
            if (!(type != 31 || operand.isGetProp() || operand.isGetElem() || operand.isName())) {
                msg = "Invalid delete operand. Only properties can be deleted.";
                IRFactory.this.errorReporter.error(msg, IRFactory.this.sourceName, operand.getLineno(), "", 0);
            } else if (!(type != 102 && type != 103 || this.validAssignmentTarget(operand))) {
                msg = type == 102 ? "invalid increment target" : "invalid decrement target";
                IRFactory.this.errorReporter.error(msg, IRFactory.this.sourceName, operand.getLineno(), "", 0);
            }
            Node node = IRFactory.this.newNode(type, operand);
            if (exprNode.isPostfix()) {
                node.putBooleanProp(32, true);
            }
            return node;
        }

        private boolean validAssignmentTarget(Node target) {
            switch (target.getType()) {
                case 33: 
                case 35: 
                case 38: {
                    return true;
                }
            }
            return false;
        }

        @Override
        Node processVariableDeclaration(VariableDeclaration declarationNode) {
            if (!((IRFactory)IRFactory.this).config.acceptConstKeyword && declarationNode.getType() == 154) {
                this.processIllegalToken(declarationNode);
            }
            Node node = IRFactory.this.newNode(118);
            for (VariableInitializer child : declarationNode.getVariables()) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processVariableInitializer(VariableInitializer initializerNode) {
            Node node = IRFactory.this.transform(initializerNode.getTarget());
            if (initializerNode.getInitializer() != null) {
                Node initalizer = IRFactory.this.transform(initializerNode.getInitializer());
                node.addChildToBack(initalizer);
            }
            return node;
        }

        @Override
        Node processWhileLoop(WhileLoop loopNode) {
            return IRFactory.this.newNode(113, IRFactory.this.transform(loopNode.getCondition()), IRFactory.this.transformBlock(loopNode.getBody()));
        }

        @Override
        Node processWithStatement(WithStatement statementNode) {
            return IRFactory.this.newNode(119, IRFactory.this.transform(statementNode.getExpression()), IRFactory.this.transformBlock(statementNode.getStatement()));
        }

        @Override
        Node processIllegalToken(AstNode node) {
            IRFactory.this.errorReporter.error("Unsupported syntax: " + Token.typeToName(node.getType()), IRFactory.this.sourceName, node.getLineno(), "", 0);
            return IRFactory.this.newNode(124);
        }

        void reportDestructuringAssign(AstNode node) {
            IRFactory.this.errorReporter.error("destructuring assignment forbidden", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportGetter(AstNode node) {
            IRFactory.this.errorReporter.error("getters are not supported in Internet Explorer", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportSetter(AstNode node) {
            IRFactory.this.errorReporter.error("setters are not supported in Internet Explorer", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportGetterParam(AstNode node) {
            IRFactory.this.errorReporter.error("getters may not have parameters", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportSetterParam(AstNode node) {
            IRFactory.this.errorReporter.error("setters must have exactly one parameter", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }
    }
}

