/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing;

import closurecompiler.internal.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.Annotation;

public class Config {
    final boolean parseJsDocDocumentation;
    final boolean isIdeMode;
    final Map<String, Annotation> annotationNames;
    final Set<String> suppressionNames;
    final LanguageMode languageMode;
    final boolean acceptConstKeyword;

    Config(Set<String> annotationWhitelist, Set<String> suppressionNames, boolean isIdeMode, LanguageMode languageMode, boolean acceptConstKeyword) {
        this.annotationNames = Config.buildAnnotationNames(annotationWhitelist);
        this.parseJsDocDocumentation = isIdeMode;
        this.suppressionNames = suppressionNames;
        this.isIdeMode = isIdeMode;
        this.languageMode = languageMode;
        this.acceptConstKeyword = acceptConstKeyword;
    }

    private static Map<String, Annotation> buildAnnotationNames(Set<String> annotationWhitelist) {
        ImmutableMap.Builder<String, Annotation> annotationBuilder = ImmutableMap.builder();
        annotationBuilder.putAll(Annotation.recognizedAnnotations);
        for (String unrecognizedAnnotation : annotationWhitelist) {
            if (Annotation.recognizedAnnotations.containsKey(unrecognizedAnnotation)) continue;
            annotationBuilder.put(unrecognizedAnnotation, Annotation.NOT_IMPLEMENTED);
        }
        return annotationBuilder.build();
    }

    public static enum LanguageMode {
        ECMASCRIPT3,
        ECMASCRIPT5,
        ECMASCRIPT5_STRICT;

    }
}

