/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.graph;

import closurecompiler.internal.com.google.common.base.Objects;
import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.base.Predicate;
import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Iterators;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.UnionFind;

public class StandardUnionFind<E>
implements Serializable,
UnionFind<E> {
    private final Map<E, Node<E>> elmap = Maps.newLinkedHashMap();

    public StandardUnionFind() {
    }

    public StandardUnionFind(UnionFind<E> other) {
        for (E elem : other.elements()) {
            this.union(elem, other.find(elem));
        }
    }

    @Override
    public void add(E e) {
        this.union(e, e);
    }

    @Override
    public E union(E a, E b) {
        Node<E> nodeB;
        Node<E> nodeA = this.findRootOrCreateNode(a);
        if (nodeA == (nodeB = this.findRootOrCreateNode(b))) {
            return nodeA.element;
        }
        if (nodeA.rank > nodeB.rank) {
            nodeB.parent = nodeA;
            nodeA.size += nodeB.size;
            return nodeA.element;
        }
        nodeA.parent = nodeB;
        if (nodeA.rank == nodeB.rank) {
            ++nodeB.rank;
        }
        nodeB.size += nodeA.size;
        return nodeB.element;
    }

    @Override
    public E find(E e) {
        Preconditions.checkArgument(this.elmap.containsKey(e), "Element does not exist: %s", e);
        return this.findRoot(this.elmap.get(e)).element;
    }

    @Override
    public boolean areEquivalent(E a, E b) {
        E bRep;
        E aRep = this.find(a);
        return aRep == (bRep = this.find(b));
    }

    @Override
    public Set<E> elements() {
        return Collections.unmodifiableSet(this.elmap.keySet());
    }

    @Override
    public Collection<Set<E>> allEquivalenceClasses() {
        HashMap groupsTmp = Maps.newHashMap();
        for (Node<E> elem : this.elmap.values()) {
            Node<E> root = this.findRoot(elem);
            ImmutableSet.Builder builder = (ImmutableSet.Builder)groupsTmp.get(root);
            if (builder == null) {
                builder = ImmutableSet.builder();
                groupsTmp.put(root, builder);
            }
            builder.add(elem.element);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (ImmutableSet.Builder group : groupsTmp.values()) {
            result.add(group.build());
        }
        return result.build();
    }

    private Node<E> findRootOrCreateNode(E e) {
        Node<E> node = this.elmap.get(e);
        if (node != null) {
            return this.findRoot(node);
        }
        node = new Node<E>(e);
        this.elmap.put(e, node);
        return node;
    }

    private Node<E> findRoot(Node<E> node) {
        if (node.parent != node) {
            node.parent = this.findRoot(node.parent);
        }
        return node.parent;
    }

    @Override
    public Set<E> findAll(final E value) {
        Preconditions.checkArgument(this.elmap.containsKey(value), "Element does not exist: " + value);
        final Predicate<Object> isSameRoot = new Predicate<Object>(){
            Node<E> nodeForValue;
            {
                this.nodeForValue = (Node)StandardUnionFind.this.elmap.get(value);
            }

            @Override
            public boolean apply(Object b) {
                if (Objects.equal(value, b)) {
                    return true;
                }
                Node nodeForB = (Node)StandardUnionFind.this.elmap.get(b);
                if (nodeForB == null) {
                    return false;
                }
                this.nodeForValue = StandardUnionFind.this.findRoot(this.nodeForValue);
                return StandardUnionFind.this.findRoot(nodeForB) == this.nodeForValue;
            }
        };
        return new AbstractSet<E>(){

            @Override
            public boolean contains(Object o) {
                return isSameRoot.apply(o);
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(StandardUnionFind.this.elmap.keySet().iterator(), isSameRoot);
            }

            @Override
            public int size() {
                return ((StandardUnionFind)StandardUnionFind.this).findRoot((Node)((Node)((StandardUnionFind)StandardUnionFind.this).elmap.get((Object)value))).size;
            }
        };
    }

    private static class Node<E> {
        Node<E> parent = this;
        final E element;
        int rank = 0;
        int size = 1;

        Node(E element) {
            this.element = element;
        }
    }
}

