/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.graph;

import closurecompiler.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.LinkedDirectedGraph;

public class GraphPruner<N, E> {
    private final DiGraph<N, E> graph;

    public GraphPruner(DiGraph<N, E> graph) {
        this.graph = graph;
    }

    public LinkedDirectedGraph<N, E> prune(Predicate<N> keep) {
        LinkedDirectedGraph workGraph = GraphPruner.cloneGraph(this.graph);
        for (DiGraph.DiGraphNode<N, E> node : workGraph.getDirectedGraphNodes()) {
            for (DiGraph.DiGraphEdge<N, E> inEdge : node.getInEdges()) {
                for (DiGraph.DiGraphEdge<N, E> outEdge : node.getOutEdges()) {
                    Object dest;
                    Object source = inEdge.getSource().getValue();
                    if (workGraph.isConnectedInDirection(source, dest = outEdge.getDestination().getValue())) continue;
                    workGraph.connect(source, outEdge.getValue(), dest);
                }
            }
        }
        LinkedDirectedGraph resultGraph = LinkedDirectedGraph.create();
        for (DiGraph.DiGraphNode<N, E> node : workGraph.getDirectedGraphNodes()) {
            if (!keep.apply(node.getValue())) continue;
            resultGraph.createNode(node.getValue());
            for (DiGraph.DiGraphEdge<N, E> outEdge : node.getOutEdges()) {
                Object source = node.getValue();
                Object dest = outEdge.getDestination().getValue();
                if (!keep.apply(dest)) continue;
                resultGraph.createNode(dest);
                if (source == dest || resultGraph.isConnectedInDirection(source, dest)) continue;
                resultGraph.connect(source, outEdge.getValue(), dest);
            }
        }
        return resultGraph;
    }

    private static <N, E> LinkedDirectedGraph<N, E> cloneGraph(DiGraph<N, E> graph) {
        LinkedDirectedGraph newGraph = LinkedDirectedGraph.create();
        for (DiGraph.DiGraphNode<N, E> node : graph.getDirectedGraphNodes()) {
            newGraph.createNode(node.getValue());
            for (DiGraph.DiGraphEdge<N, E> outEdge : node.getOutEdges()) {
                Object dest = outEdge.getDestination().getValue();
                newGraph.createNode(dest);
                newGraph.connect(node.getValue(), outEdge.getValue(), dest);
            }
        }
        return newGraph;
    }
}

