/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.graph;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.AdjacencyGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.Annotation;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.GraphNode;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.SubGraph;

public abstract class GraphColoring<N, E> {
    protected N[] colorToNodeMap;
    protected final AdjacencyGraph<N, E> graph;

    public GraphColoring(AdjacencyGraph<N, E> graph) {
        this.graph = graph;
    }

    public abstract int color();

    public N getPartitionSuperNode(N node) {
        Preconditions.checkNotNull(this.colorToNodeMap, "No coloring founded. color() should be called first.");
        Color color = (Color)this.graph.getNode(node).getAnnotation();
        N headNode = this.colorToNodeMap[color.value];
        if (headNode == null) {
            this.colorToNodeMap[color.value] = node;
            return node;
        }
        return headNode;
    }

    public AdjacencyGraph<N, E> getGraph() {
        return this.graph;
    }

    public static class GreedyGraphColoring<N, E>
    extends GraphColoring<N, E> {
        private final Comparator<N> tieBreaker;

        public GreedyGraphColoring(AdjacencyGraph<N, E> graph) {
            this(graph, null);
        }

        public GreedyGraphColoring(AdjacencyGraph<N, E> graph, Comparator<N> tieBreaker) {
            super(graph);
            this.tieBreaker = tieBreaker;
        }

        @Override
        public int color() {
            this.graph.clearNodeAnnotations();
            ArrayList worklist = Lists.newArrayList(this.graph.getNodes());
            Collections.sort(worklist, new Comparator<GraphNode<N, E>>(){

                @Override
                public int compare(GraphNode<N, E> o1, GraphNode<N, E> o2) {
                    int result = GreedyGraphColoring.this.graph.getWeight(o2.getValue()) - GreedyGraphColoring.this.graph.getWeight(o1.getValue());
                    return result == 0 && GreedyGraphColoring.this.tieBreaker != null ? GreedyGraphColoring.this.tieBreaker.compare(o1.getValue(), o2.getValue()) : result;
                }
            });
            int count = 0;
            do {
                Color color = new Color(count);
                SubGraph subgraph = this.graph.newSubGraph();
                Iterator i = worklist.iterator();
                while (i.hasNext()) {
                    GraphNode node = (GraphNode)i.next();
                    if (!subgraph.isIndependentOf(node.getValue())) continue;
                    subgraph.addNode(node.getValue());
                    node.setAnnotation(color);
                    i.remove();
                }
                ++count;
            } while (!worklist.isEmpty());
            Object[] map = new Object[count];
            this.colorToNodeMap = map;
            return count;
        }
    }

    public static class Color
    implements Annotation {
        int value = 0;

        Color(int value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Color)) {
                return false;
            }
            return this.value == ((Color)other).value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

