/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.deps;

import closurecompiler.internal.com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.DependencyInfo;

public class SimpleDependencyInfo
implements DependencyInfo {
    private final List<String> provides;
    private final List<String> requires;
    private final String srcPathRelativeToClosure;
    private final String pathOfDefiningFile;

    public SimpleDependencyInfo(String srcPathRelativeToClosure, String pathOfDefiningFile, List<String> provides, List<String> requires) {
        this.srcPathRelativeToClosure = srcPathRelativeToClosure;
        this.pathOfDefiningFile = pathOfDefiningFile;
        this.provides = provides;
        this.requires = requires;
    }

    @Override
    public String getName() {
        return this.pathOfDefiningFile;
    }

    @Override
    public String getPathRelativeToClosureBase() {
        return this.srcPathRelativeToClosure;
    }

    @Override
    public Collection<String> getProvides() {
        return Collections.unmodifiableList(this.provides);
    }

    @Override
    public Collection<String> getRequires() {
        return Collections.unmodifiableList(this.requires);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleDependencyInfo)) {
            return false;
        }
        SimpleDependencyInfo other = (SimpleDependencyInfo)obj;
        return Objects.equal(other.srcPathRelativeToClosure, this.srcPathRelativeToClosure) && Objects.equal(other.pathOfDefiningFile, this.pathOfDefiningFile) && Objects.equal(other.requires, this.requires) && Objects.equal(other.provides, this.provides);
    }

    public String toString() {
        return String.format("DependencyInfo(relativePath='%1$s', path='%2$s', provides=%3$s, requires=%4$s)", this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.provides, this.requires);
    }
}

