/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.deps;

import closurecompiler.internal.com.google.common.base.CharMatcher;
import closurecompiler.internal.com.google.common.base.Joiner;
import closurecompiler.internal.com.google.common.base.Strings;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;

public final class PathUtil {
    private static final CharMatcher SLASH_MATCHER = CharMatcher.is('/');
    private static final CharMatcher NON_SLASH_MATCHER = CharMatcher.isNot('/');

    private PathUtil() {
    }

    public static String collapseDots(String path) {
        if (!(path = PathUtil.removeExtraneousSlashes(path)).contains(".")) {
            return path;
        }
        String[] srcFragments = path.split("/");
        ArrayList<String> dstFragments = Lists.newArrayList();
        for (String fragment : srcFragments) {
            if (fragment.equals("..")) {
                if (dstFragments.isEmpty()) continue;
                dstFragments.remove(dstFragments.size() - 1);
                continue;
            }
            if (fragment.equals(".")) continue;
            dstFragments.add(fragment);
        }
        if (dstFragments.size() == 1 && ((String)dstFragments.get(0)).isEmpty()) {
            return "/";
        }
        return Joiner.on("/").join(dstFragments);
    }

    static boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    static String removeExtraneousSlashes(String s) {
        int lastNonSlash = NON_SLASH_MATCHER.lastIndexIn(s);
        if (lastNonSlash != -1) {
            s = s.substring(0, lastNonSlash + 1);
        }
        return SLASH_MATCHER.collapseFrom(s, '/');
    }

    public static String makeAbsolute(String path) {
        return PathUtil.makeAbsolute(path, System.getProperty("user.dir"));
    }

    public static String makeAbsolute(String path, String rootPath) {
        if (!PathUtil.isAbsolute(path)) {
            path = rootPath + "/" + path;
        }
        return PathUtil.collapseDots(path);
    }

    public static String makeRelative(String basePath, String targetPath) {
        if (PathUtil.isAbsolute(basePath) != PathUtil.isAbsolute(targetPath)) {
            throw new IllegalArgumentException("Paths must both be relative or both absolute.\n  basePath: " + basePath + "\n" + "  targetPath: " + targetPath);
        }
        basePath = PathUtil.collapseDots(basePath);
        targetPath = PathUtil.collapseDots(targetPath);
        String[] baseFragments = basePath.split("/");
        String[] targetFragments = targetPath.split("/");
        int i = -1;
        do {
            if (++i == baseFragments.length && i == targetFragments.length) {
                return ".";
            }
            if (i == baseFragments.length) {
                return Joiner.on("/").join(Lists.newArrayList(Arrays.asList(targetFragments).listIterator(i)));
            }
            if (i != targetFragments.length) continue;
            return Strings.repeat("../", baseFragments.length - i - 1) + "..";
        } while (baseFragments[i].equals(targetFragments[i]));
        return Strings.repeat("../", baseFragments.length - i) + Joiner.on("/").join(Lists.newArrayList(Arrays.asList(targetFragments).listIterator(i)));
    }
}

