/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.deps;

import closurecompiler.internal.com.google.common.base.Function;
import closurecompiler.internal.com.google.common.base.Joiner;
import closurecompiler.internal.com.google.common.collect.ImmutableListMultimap;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Multimaps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ErrorManager;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SourceFile;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.DependencyInfo;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.DepsFileParser;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.JsFileParser;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.PathUtil;

public class DepsGenerator {
    private static Logger logger = Logger.getLogger(DepsGenerator.class.getName());
    private final Collection<SourceFile> srcs;
    private final Collection<SourceFile> deps;
    private final String closurePathAbs;
    private final InclusionStrategy mergeStrategy;
    final ErrorManager errorManager;
    static final DiagnosticType SAME_FILE_WARNING = DiagnosticType.warning("DEPS_SAME_FILE", "Namespace \"{0}\" is both required and provided in the same file.");
    static final DiagnosticType NEVER_PROVIDED_ERROR = DiagnosticType.error("DEPS_NEVER_PROVIDED", "Namespace \"{0}\" is required but never provided.");
    static final DiagnosticType DUPE_PROVIDES_WARNING = DiagnosticType.warning("DEPS_DUPE_PROVIDES", "Multiple calls to goog.provide(\"{0}\")");
    static final DiagnosticType MULTIPLE_PROVIDES_ERROR = DiagnosticType.error("DEPS_DUPE_PROVIDES", "Namespace \"{0}\" is already provided in other file {1}");
    static final DiagnosticType DUPE_REQUIRE_WARNING = DiagnosticType.warning("DEPS_DUPE_REQUIRES", "Namespace \"{0}\" is required multiple times");
    static final DiagnosticType NO_DEPS_WARNING = DiagnosticType.warning("DEPS_NO_DEPS", "No dependencies found in file");

    public DepsGenerator(Collection<SourceFile> deps, Collection<SourceFile> srcs, InclusionStrategy mergeStrategy, String closurePathAbs, ErrorManager errorManager) {
        this.deps = deps;
        this.srcs = srcs;
        this.mergeStrategy = mergeStrategy;
        this.closurePathAbs = closurePathAbs;
        this.errorManager = errorManager;
    }

    public String computeDependencyCalls() throws IOException {
        Map<String, DependencyInfo> depsFiles = this.parseDepsFiles();
        logger.fine("preparsedFiles: " + depsFiles);
        Map<String, DependencyInfo> jsFiles = this.parseSources(depsFiles.keySet());
        if (this.errorManager.getErrorCount() > 0) {
            return null;
        }
        this.cleanUpDuplicatedFiles(depsFiles, jsFiles);
        this.validateDependencies(depsFiles.values(), jsFiles.values());
        if (this.errorManager.getErrorCount() > 0) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeDepsContent(depsFiles, jsFiles, new PrintStream(output));
        return new String(output.toByteArray());
    }

    protected void cleanUpDuplicatedFiles(Map<String, DependencyInfo> depsFiles, Map<String, DependencyInfo> jsFiles) {
        HashSet<String> depsPathsCopy = Sets.newHashSet(depsFiles.keySet());
        for (String path : depsPathsCopy) {
            if (this.mergeStrategy == InclusionStrategy.WHEN_IN_SRCS) continue;
            jsFiles.remove(path);
        }
        for (String path : jsFiles.keySet()) {
            depsFiles.remove(path);
        }
    }

    private void validateDependencies(Iterable<DependencyInfo> preparsedFileDepedencies, Iterable<DependencyInfo> parsedFileDependencies) {
        HashMap<String, DependencyInfo> providesMap = Maps.newHashMap();
        this.addToProvideMap(preparsedFileDepedencies, providesMap);
        this.addToProvideMap(parsedFileDependencies, providesMap);
        for (DependencyInfo depInfo : parsedFileDependencies) {
            ArrayList<String> requires = Lists.newArrayList(depInfo.getRequires());
            int l = requires.size();
            for (int i = 0; i < l; ++i) {
                DependencyInfo provider;
                String namespace = (String)requires.get(i);
                if (requires.subList(i + 1, l).contains(namespace)) {
                    this.reportDuplicateRequire(namespace, depInfo);
                }
                if ((provider = (DependencyInfo)providesMap.get(namespace)) == null) {
                    this.reportUndefinedNamespace(namespace, depInfo);
                    continue;
                }
                if (provider != depInfo) continue;
                this.reportSameFile(namespace, depInfo);
            }
        }
    }

    private void reportSameFile(String namespace, DependencyInfo depInfo) {
        this.errorManager.report(CheckLevel.WARNING, JSError.make(depInfo.getName(), -1, -1, SAME_FILE_WARNING, namespace));
    }

    private void reportUndefinedNamespace(String namespace, DependencyInfo depInfo) {
        this.errorManager.report(CheckLevel.ERROR, JSError.make(depInfo.getName(), -1, -1, NEVER_PROVIDED_ERROR, namespace));
    }

    private void reportDuplicateProvide(String namespace, DependencyInfo firstDep, DependencyInfo secondDep) {
        if (firstDep == secondDep) {
            this.errorManager.report(CheckLevel.WARNING, JSError.make(firstDep.getName(), -1, -1, DUPE_PROVIDES_WARNING, namespace));
        } else {
            this.errorManager.report(CheckLevel.ERROR, JSError.make(secondDep.getName(), -1, -1, MULTIPLE_PROVIDES_ERROR, namespace, firstDep.getName()));
        }
    }

    private void reportDuplicateRequire(String namespace, DependencyInfo depInfo) {
        this.errorManager.report(CheckLevel.WARNING, JSError.make(depInfo.getName(), -1, -1, DUPE_REQUIRE_WARNING, namespace));
    }

    private void reportNoDepsInDepsFile(String filePath) {
        this.errorManager.report(CheckLevel.WARNING, JSError.make(filePath, -1, -1, NO_DEPS_WARNING, new String[0]));
    }

    private void addToProvideMap(Iterable<DependencyInfo> depInfos, Map<String, DependencyInfo> providesMap) {
        for (DependencyInfo depInfo : depInfos) {
            for (String provide : depInfo.getProvides()) {
                DependencyInfo prevValue = providesMap.put(provide, depInfo);
                if (prevValue == null) continue;
                this.reportDuplicateProvide(provide, prevValue, depInfo);
            }
        }
    }

    protected DepsFileParser createDepsFileParser() {
        DepsFileParser depsParser = new DepsFileParser(this.errorManager);
        depsParser.setShortcutMode(true);
        return depsParser;
    }

    protected boolean shouldSkipDepsFile(SourceFile file) {
        return false;
    }

    private Map<String, DependencyInfo> parseDepsFiles() throws IOException {
        DepsFileParser depsParser = this.createDepsFileParser();
        HashMap<String, DependencyInfo> depsFiles = Maps.newHashMap();
        for (SourceFile file : this.deps) {
            if (this.shouldSkipDepsFile(file)) continue;
            List<DependencyInfo> depInfos = depsParser.parseFileReader(file.getName(), file.getCodeReader());
            if (depInfos.isEmpty()) {
                this.reportNoDepsInDepsFile(file.getName());
                continue;
            }
            for (DependencyInfo info : depInfos) {
                depsFiles.put(info.getPathRelativeToClosureBase(), info);
            }
        }
        for (SourceFile src : this.srcs) {
            if (!new File(src.getName()).exists() || this.shouldSkipDepsFile(src)) continue;
            List<DependencyInfo> srcInfos = depsParser.parseFileReader(src.getName(), src.getCodeReader());
            for (DependencyInfo info : srcInfos) {
                depsFiles.put(info.getPathRelativeToClosureBase(), info);
            }
        }
        return depsFiles;
    }

    private Map<String, DependencyInfo> parseSources(Set<String> preparsedFiles) throws IOException {
        HashMap<String, DependencyInfo> parsedFiles = Maps.newHashMap();
        JsFileParser jsParser = new JsFileParser(this.errorManager);
        for (SourceFile file : this.srcs) {
            String closureRelativePath = PathUtil.makeRelative(this.closurePathAbs, PathUtil.makeAbsolute(file.getName()));
            logger.fine("Closure-relative path: " + closureRelativePath);
            if (InclusionStrategy.WHEN_IN_SRCS != this.mergeStrategy && preparsedFiles.contains(closureRelativePath)) continue;
            DependencyInfo depInfo = jsParser.parseFile(file.getName(), closureRelativePath, file.getCode());
            file.clearCachedSource();
            parsedFiles.put(closureRelativePath, depInfo);
        }
        return parsedFiles;
    }

    private void writeDepsContent(Map<String, DependencyInfo> depsFiles, Map<String, DependencyInfo> jsFiles, PrintStream out) throws IOException {
        this.writeDepInfos(out, jsFiles.values());
        if (this.mergeStrategy == InclusionStrategy.ALWAYS) {
            ImmutableListMultimap<String, DependencyInfo> infosIndex = Multimaps.index(depsFiles.values(), new Function<DependencyInfo, String>(){

                @Override
                public String apply(DependencyInfo from) {
                    return from.getName();
                }
            });
            for (String depsPath : infosIndex.keySet()) {
                String path = this.formatPathToDepsFile(depsPath);
                out.println("\n// Included from: " + path);
                this.writeDepInfos(out, infosIndex.get(depsPath));
            }
        }
    }

    protected String formatPathToDepsFile(String path) {
        return path;
    }

    private void writeDepInfos(PrintStream out, Collection<DependencyInfo> depInfos) throws IOException {
        for (DependencyInfo depInfo : depInfos) {
            Collection<String> provides = depInfo.getProvides();
            Collection<String> requires = depInfo.getRequires();
            out.print("goog.addDependency('" + depInfo.getPathRelativeToClosureBase() + "', ");
            DepsGenerator.writeJsArray(out, provides);
            out.print(", ");
            DepsGenerator.writeJsArray(out, requires);
            out.println(");");
        }
    }

    private static void writeJsArray(PrintStream out, Collection<String> values) {
        if (values.isEmpty()) {
            out.print("[]");
        } else {
            out.print("['");
            out.print(Joiner.on("', '").join(values));
            out.print("']");
        }
    }

    static enum InclusionStrategy {
        ALWAYS,
        WHEN_IN_SRCS,
        DO_NOT_DUPLICATE;

    }
}

