/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp.deps;

import closurecompiler.internal.com.google.common.base.CharMatcher;
import closurecompiler.internal.com.google.common.base.Function;
import closurecompiler.internal.com.google.common.base.Functions;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ErrorManager;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.DependencyInfo;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.JsFileLineParser;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.SimpleDependencyInfo;

public class DepsFileParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(DepsFileParser.class.getName());
    private final Matcher depMatcher = Pattern.compile("\\s*goog.addDependency\\((.*)\\);?\\s*").matcher("");
    private final Matcher depArgsMatch = Pattern.compile("\\s*([^,]*), (\\[[^\\]]*\\]), (\\[[^\\]]*\\])\\s*").matcher("");
    private List<DependencyInfo> depInfos;
    private final Function<String, String> pathTranslator;

    public DepsFileParser(ErrorManager errorManager) {
        this(Functions.identity(), errorManager);
    }

    public DepsFileParser(Function<String, String> pathTranslator, ErrorManager errorManager) {
        super(errorManager);
        this.pathTranslator = pathTranslator;
    }

    public List<DependencyInfo> parseFile(String filePath) throws IOException {
        return this.parseFileReader(filePath, new FileReader(filePath));
    }

    public List<DependencyInfo> parseFile(String filePath, String fileContents) {
        return this.parseFileReader(filePath, new StringReader(fileContents));
    }

    public List<DependencyInfo> parseFileReader(String filePath, Reader reader) {
        this.depInfos = Lists.newArrayList();
        logger.fine("Parsing Dep: " + filePath);
        this.doParse(filePath, reader);
        return this.depInfos;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean hasDependencies = false;
        if (line.indexOf("addDependency") != -1) {
            this.depMatcher.reset(line);
            if (this.depMatcher.matches()) {
                hasDependencies = true;
                String addDependencyParams = this.depMatcher.group(1);
                this.depArgsMatch.reset(addDependencyParams);
                if (!this.depArgsMatch.matches()) {
                    throw new JsFileLineParser.ParseException("Invalid arguments to goog.addDependency(). Found: " + addDependencyParams, true);
                }
                String path = this.pathTranslator.apply(this.parseJsString(this.depArgsMatch.group(1)));
                SimpleDependencyInfo depInfo = new SimpleDependencyInfo(path, this.filePath, this.parseJsStringArray(this.depArgsMatch.group(2)), this.parseJsStringArray(this.depArgsMatch.group(3)));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Found dep: " + depInfo);
                }
                this.depInfos.add(depInfo);
            }
        }
        return !this.shortcutMode || hasDependencies || CharMatcher.WHITESPACE.matchesAllOf(line);
    }
}

