/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Iterables;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.GoogleJsMessageIdGenerator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JsMessage;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JsMessageVisitor;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.MessageBundle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XtbMessageBundle
implements MessageBundle {
    private static final SecureEntityResolver NOOP_RESOLVER = new SecureEntityResolver();
    private final Map<String, JsMessage> messages;
    private final JsMessage.IdGenerator idGenerator;

    public XtbMessageBundle(InputStream xtb, String projectId, boolean unused) {
        this(xtb, projectId);
    }

    public XtbMessageBundle(InputStream xtb, String projectId) {
        Preconditions.checkState(!"".equals(projectId));
        this.messages = Maps.newHashMap();
        this.idGenerator = new GoogleJsMessageIdGenerator(projectId);
        try {
            SAXParser parser = this.createSAXParser();
            XMLReader reader = parser.getXMLReader();
            Handler contentHandler = new Handler();
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(xtb));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SAXParser createSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setXIncludeAware(false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser parser = factory.newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        xmlReader.setEntityResolver(NOOP_RESOLVER);
        return parser;
    }

    @Override
    public JsMessage getMessage(String id) {
        return this.messages.get(id);
    }

    @Override
    public JsMessage.IdGenerator idGenerator() {
        return this.idGenerator;
    }

    @Override
    public Iterable<JsMessage> getAllMessages() {
        return Iterables.unmodifiableIterable(this.messages.values());
    }

    private static final class SecureEntityResolver
    implements EntityResolver {
        private SecureEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }

    private class Handler
    implements ContentHandler {
        String lang;
        JsMessage.Builder msgBuilder;

        private Handler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if ("translationbundle".equals(qName)) {
                Preconditions.checkState(this.lang == null);
                this.lang = atts.getValue("lang");
                Preconditions.checkState(this.lang != null && !this.lang.isEmpty());
            } else if ("translation".equals(qName)) {
                Preconditions.checkState(this.msgBuilder == null);
                String id = atts.getValue("id");
                Preconditions.checkState(id != null && !id.isEmpty());
                this.msgBuilder = new JsMessage.Builder(id);
            } else if ("ph".equals(qName)) {
                Preconditions.checkState(this.msgBuilder != null);
                String phRef = atts.getValue("name");
                phRef = JsMessageVisitor.toLowerCamelCaseWithNumericSuffixes(phRef);
                this.msgBuilder.appendPlaceholderReference(phRef);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("translation".equals(qName)) {
                Preconditions.checkState(this.msgBuilder != null);
                if (!this.msgBuilder.hasParts()) {
                    this.msgBuilder.appendStringPart("");
                }
                String key = this.msgBuilder.getKey();
                XtbMessageBundle.this.messages.put(key, this.msgBuilder.build());
                this.msgBuilder = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.msgBuilder != null) {
                this.msgBuilder.appendStringPart(String.valueOf(ch, start, length));
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            if (this.msgBuilder != null) {
                this.msgBuilder.appendStringPart(String.valueOf(ch, start, length));
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void skippedEntity(String name) {
        }
    }
}

