/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerOptions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticGroups;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ShowByPathWarningsGuard;

public enum WarningLevel {
    QUIET,
    DEFAULT,
    VERBOSE;


    public void setOptionsForWarningLevel(CompilerOptions options) {
        switch (this) {
            case QUIET: {
                WarningLevel.silenceAllWarnings(options);
                break;
            }
            case DEFAULT: {
                WarningLevel.addDefaultWarnings(options);
                break;
            }
            case VERBOSE: {
                WarningLevel.addVerboseWarnings(options);
                break;
            }
            default: {
                throw new RuntimeException("Unknown warning level.");
            }
        }
    }

    private static void silenceAllWarnings(CompilerOptions options) {
        options.addWarningsGuard(new ShowByPathWarningsGuard("the_longest_path_that_cannot_be_expressed_as_a_string"));
        options.checkRequires = CheckLevel.OFF;
        options.checkProvides = CheckLevel.OFF;
        options.checkMissingGetCssNameLevel = CheckLevel.OFF;
        options.aggressiveVarCheck = CheckLevel.OFF;
        options.checkTypes = false;
        options.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.OFF);
        options.checkUnreachableCode = CheckLevel.OFF;
        options.checkMissingReturn = CheckLevel.OFF;
        options.setWarningLevel(DiagnosticGroups.ACCESS_CONTROLS, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.CONSTANT_PROPERTY, CheckLevel.OFF);
        options.checkGlobalNamesLevel = CheckLevel.OFF;
        options.checkSuspiciousCode = false;
        options.checkGlobalThisLevel = CheckLevel.OFF;
        options.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.OFF);
        options.checkCaja = false;
    }

    private static void addDefaultWarnings(CompilerOptions options) {
        options.checkSuspiciousCode = true;
        options.checkUnreachableCode = CheckLevel.WARNING;
        options.checkControlStructures = true;
    }

    private static void addVerboseWarnings(CompilerOptions options) {
        WarningLevel.addDefaultWarnings(options);
        options.checkSuspiciousCode = true;
        options.checkGlobalThisLevel = CheckLevel.WARNING;
        options.checkSymbols = true;
        options.checkMissingReturn = CheckLevel.WARNING;
        options.checkTypes = true;
        options.checkGlobalNamesLevel = CheckLevel.WARNING;
        options.aggressiveVarCheck = CheckLevel.WARNING;
        options.setWarningLevel(DiagnosticGroups.MISSING_PROPERTIES, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.DEPRECATED, CheckLevel.WARNING);
    }
}

