/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Strings;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractMessageFormatter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Region;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SourceExcerptProvider;

class VerboseMessageFormatter
extends AbstractMessageFormatter {
    VerboseMessageFormatter(SourceExcerptProvider source) {
        super(source);
    }

    @Override
    public String formatError(JSError error) {
        return this.getLevelName(CheckLevel.ERROR) + ": " + this.format(error);
    }

    @Override
    public String formatWarning(JSError warning) {
        return this.getLevelName(CheckLevel.WARNING) + ": " + this.format(warning);
    }

    private String format(JSError message) {
        String description = message.description;
        String sourceName = message.sourceName;
        int lineNumber = message.lineNumber;
        Region sourceRegion = this.getSource().getSourceRegion(sourceName, lineNumber);
        String lineSource = null;
        if (sourceRegion != null) {
            lineSource = sourceRegion.getSourceExcerpt();
        }
        return String.format("%s at %s line %s %s", description, Strings.isNullOrEmpty(sourceName) ? "(unknown source)" : sourceName, lineNumber < 0 ? String.valueOf(lineNumber) : "(unknown line)", lineSource != null ? ":\n\n" + lineSource : ".");
    }
}

