/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ReferenceCollectingCallback;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class VariableVisibilityAnalysis
implements CompilerPass {
    private AbstractCompiler compiler;
    private Map<Node, VariableVisibility> visibilityByDeclaringNameNode;

    public VariableVisibilityAnalysis(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.visibilityByDeclaringNameNode = Maps.newHashMap();
    }

    public VariableVisibility getVariableVisibility(Node declaringNameNode) {
        Node parent = declaringNameNode.getParent();
        Preconditions.checkArgument(parent.isVar() || parent.isFunction() || parent.isParamList());
        return this.visibilityByDeclaringNameNode.get(declaringNameNode);
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR);
        NodeTraversal.traverse(this.compiler, root, callback);
        for (Scope.Var variable : callback.getAllSymbols()) {
            VariableVisibility visibility;
            ReferenceCollectingCallback.ReferenceCollection referenceCollection = callback.getReferences(variable);
            if (VariableVisibilityAnalysis.variableIsParameter(variable)) {
                visibility = VariableVisibility.PARAMETER;
            } else if (variable.isLocal()) {
                visibility = referenceCollection.isEscaped() ? VariableVisibility.CAPTURED_LOCAL : VariableVisibility.LOCAL;
            } else if (variable.isGlobal()) {
                visibility = VariableVisibility.GLOBAL;
            } else {
                throw new IllegalStateException("Un-handled variable visibility for " + variable);
            }
            this.visibilityByDeclaringNameNode.put(variable.getNameNode(), visibility);
        }
    }

    private static boolean variableIsParameter(Scope.Var variable) {
        Node variableParent = variable.getParentNode();
        return variableParent != null && variableParent.isParamList();
    }

    static enum VariableVisibility {
        LOCAL,
        CAPTURED_LOCAL,
        PARAMETER,
        GLOBAL;

    }
}

