/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Charsets;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.io.ByteStreams;
import closurecompiler.internal.com.google.common.io.CharStreams;
import closurecompiler.internal.com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableMap {
    private final Map<String, String> map;
    private Map<String, String> reverseMap = null;

    VariableMap(Map<String, String> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public String lookupNewName(String sourceName) {
        return this.map.get(sourceName);
    }

    public String lookupSourceName(String newName) {
        if (this.reverseMap == null) {
            this.initReverseMap();
        }
        return this.reverseMap.get(newName);
    }

    private synchronized void initReverseMap() {
        if (this.reverseMap == null) {
            HashMap<String, String> rm = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                rm.put(entry.getValue(), entry.getKey());
            }
            this.reverseMap = Collections.unmodifiableMap(rm);
        }
    }

    public Map<String, String> getOriginalNameToNewNameMap() {
        return this.map;
    }

    public Map<String, String> getNewNameToOriginalNameMap() {
        if (this.reverseMap == null) {
            this.initReverseMap();
        }
        return this.reverseMap;
    }

    public void save(String filename) throws IOException {
        Files.write(this.toBytes(), new File(filename));
    }

    public static VariableMap load(String filename) throws IOException {
        try {
            return VariableMap.fromBytes(Files.toByteArray(new File(filename)));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, Charsets.UTF_8);
        try {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                writer.write(entry.getKey());
                ((Writer)writer).write(58);
                writer.write(entry.getValue());
                ((Writer)writer).write(10);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static VariableMap fromBytes(byte[] bytes) throws ParseException {
        List<String> lines;
        try {
            lines = CharStreams.readLines(CharStreams.newReaderSupplier(ByteStreams.newInputStreamSupplier(bytes), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : lines) {
            int pos = line.lastIndexOf(58);
            if (pos <= 0 || pos == line.length() - 1) {
                throw new ParseException("Bad line: " + line, 0);
            }
            map.put(line.substring(0, pos), line.substring(pos + 1));
        }
        return new VariableMap(map);
    }

    public static VariableMap fromMap(Map<String, String> map) {
        return new VariableMap(Maps.newHashMap(map));
    }
}

