/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.GraphReachability;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class UnreachableCodeElimination
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final Logger logger = Logger.getLogger(UnreachableCodeElimination.class.getName());
    private final AbstractCompiler compiler;
    private final boolean removeNoOpStatements;
    Deque<ControlFlowGraph<Node>> cfgStack = new LinkedList<ControlFlowGraph<Node>>();
    ControlFlowGraph<Node> curCfg = null;

    UnreachableCodeElimination(AbstractCompiler compiler, boolean removeNoOpStatements) {
        this.compiler = compiler;
        this.removeNoOpStatements = removeNoOpStatements;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Scope scope = t.getScope();
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, scope.getRootNode());
        this.cfgStack.push(this.curCfg);
        this.curCfg = cfa.getCfg();
        new GraphReachability(this.curCfg).compute(this.curCfg.getEntry().getValue());
    }

    @Override
    public void exitScope(NodeTraversal t) {
        this.curCfg = this.cfgStack.pop();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent == null) {
            return;
        }
        if (n.isFunction() || n.isScript()) {
            return;
        }
        DiGraph.DiGraphNode gNode = this.curCfg.getDirectedGraphNode(n);
        if (gNode == null) {
            return;
        }
        if (gNode.getAnnotation() != GraphReachability.REACHABLE || this.removeNoOpStatements && !NodeUtil.mayHaveSideEffects(n)) {
            this.removeDeadExprStatementSafely(n);
            return;
        }
        this.tryRemoveUnconditionalBranching(n);
    }

    private Node tryRemoveUnconditionalBranching(Node n) {
        if (n == null) {
            return n;
        }
        DiGraph.DiGraphNode gNode = this.curCfg.getDirectedGraphNode(n);
        if (gNode == null) {
            return n;
        }
        switch (n.getType()) {
            case 4: {
                if (n.hasChildren()) break;
            }
            case 116: 
            case 117: {
                List outEdges = gNode.getOutEdges();
                if (outEdges.size() != 1 || n.getNext() != null && !n.getNext().isFunction()) break;
                Preconditions.checkState(outEdges.get(0).getValue() == ControlFlowGraph.Branch.UNCOND);
                Node fallThrough = this.computeFollowing(n);
                Node nextCfgNode = (Node)outEdges.get(0).getDestination().getValue();
                if (nextCfgNode != fallThrough) break;
                this.removeDeadExprStatementSafely(n);
                return fallThrough;
            }
        }
        return n;
    }

    private Node computeFollowing(Node n) {
        Node next = ControlFlowAnalysis.computeFollowNode(n);
        while (next != null && next.isBlock()) {
            if (next.hasChildren()) {
                next = next.getFirstChild();
                continue;
            }
            next = this.computeFollowing(next);
        }
        return next;
    }

    private void removeDeadExprStatementSafely(Node n) {
        Node parent = n.getParent();
        if (n.isEmpty() || n.isBlock() && !n.hasChildren()) {
            return;
        }
        switch (n.getType()) {
            case 114: {
                return;
            }
            case 125: {
                if (!parent.isTry() || !NodeUtil.isTryCatchNodeContainer(n)) break;
                return;
            }
            case 120: {
                Node tryNode = parent.getParent();
                NodeUtil.maybeAddFinally(tryNode);
            }
        }
        if (n.isVar() && !n.getFirstChild().hasChildren()) {
            return;
        }
        NodeUtil.redeclareVarsInsideBranch(n);
        this.compiler.reportCodeChange();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing " + n.toString());
        }
        NodeUtil.removeChild(n.getParent(), n);
    }
}

