/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DataFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ReverseAbstractInterpreter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.TypeInference;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class TypeInferencePass
implements CompilerPass {
    static final DiagnosticType DATAFLOW_ERROR = DiagnosticType.warning("JSC_INTERNAL_ERROR_DATAFLOW", "non-monotonic data-flow analysis");
    private final AbstractCompiler compiler;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private Scope topScope;
    private ScopeCreator scopeCreator;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;

    TypeInferencePass(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, Scope topScope, ScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.reverseInterpreter = reverseInterpreter;
        this.topScope = topScope;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionsMap = Maps.newHashMap();
        for (CodingConvention.AssertionFunctionSpec assertionFucntion : compiler.getCodingConvention().getAssertionFunctions()) {
            this.assertionFunctionsMap.put(assertionFucntion.getFunctionName(), assertionFucntion);
        }
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Node externsAndJs = jsRoot.getParent();
        Preconditions.checkState(externsAndJs != null);
        Preconditions.checkState(externsRoot == null || externsAndJs.hasChild(externsRoot));
        this.inferTypes(externsAndJs);
    }

    void inferTypes(Node node) {
        NodeTraversal inferTypes = new NodeTraversal(this.compiler, new TypeInferringCallback(), this.scopeCreator);
        inferTypes.traverseWithScope(node, this.topScope);
    }

    void inferTypes(NodeTraversal t, Node n, Scope scope) {
        TypeInference typeInference = new TypeInference(this.compiler, this.computeCfg(n), this.reverseInterpreter, scope, this.assertionFunctionsMap);
        try {
            typeInference.analyze();
            this.compiler.getTypeRegistry().resolveTypesInScope(scope);
        }
        catch (DataFlowAnalysis.MaxIterationsExceededException e) {
            this.compiler.report(t.makeError(n, DATAFLOW_ERROR, new String[0]));
        }
    }

    private ControlFlowGraph<Node> computeCfg(Node n) {
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, n);
        return cfa.getCfg();
    }

    private class TypeInferringCallback
    implements NodeTraversal.ScopedCallback {
        private TypeInferringCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Scope scope = t.getScope();
            Node node = t.getCurrentNode();
            if (scope.isGlobal()) {
                TypeInferencePass.this.inferTypes(t, node, scope);
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            Scope scope = t.getScope();
            Node node = t.getCurrentNode();
            if (scope.isLocal()) {
                TypeInferencePass.this.inferTypes(t, node, scope);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

