/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.Iterators;
import closurecompiler.internal.com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class TransformAMDToCJSModule
implements CompilerPass {
    static final DiagnosticType UNSUPPORTED_DEFINE_SIGNATURE_ERROR = DiagnosticType.error("UNSUPPORTED_DEFINE_SIGNATURE", "Only define(function() ...), define(OBJECT_LITERAL) and define(['dep', 'dep1'], function(d0, d2, [exports, module]) ...) forms are currently supported.");
    static final DiagnosticType NON_TOP_LEVEL_STATEMENT_DEFINE_ERROR = DiagnosticType.error("NON_TOP_LEVEL_STATEMENT_DEFINE", "The define function must be called as a top level statement.");
    static final DiagnosticType REQUIREJS_PLUGINS_NOT_SUPPORTED_WARNING = DiagnosticType.warning("REQUIREJS_PLUGINS_NOT_SUPPORTED", "Plugins in define requirements are not supported: {0}");
    private final AbstractCompiler compiler;
    private int renameIndex = 0;

    TransformAMDToCJSModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new TransformAMDModulesCallback());
    }

    private void unsupportedDefineError(NodeTraversal t, Node n) {
        t.report(n, UNSUPPORTED_DEFINE_SIGNATURE_ERROR, new String[0]);
    }

    private boolean isVirtualModuleName(String moduleName) {
        return "exports".equals(moduleName) || "require".equals(moduleName) || "module".equals(moduleName);
    }

    private class RenameCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String from;
        private final String to;

        public RenameCallback(String from, String to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && this.from.equals(n.getString())) {
                n.setString(this.to);
                n.putProp(40, this.from);
            }
        }
    }

    private class DefineCallbackReturnCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private DefineCallbackReturnCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isReturn() && n.hasChildren()) {
                Node retVal = n.getFirstChild();
                n.removeChild(retVal);
                parent.replaceChild(n, IR.exprResult(IR.assign(IR.getprop(IR.name("module"), IR.string("exports")), retVal)).useSourceInfoFromForTree(n));
            }
        }
    }

    private class TransformAMDModulesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private TransformAMDModulesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall() && n.getFirstChild() != null && n.getFirstChild().isName() && "define".equals(n.getFirstChild().getString())) {
                Scope.Var define = t.getScope().getVar(n.getFirstChild().getString());
                if (define != null && !define.isGlobal()) {
                    return;
                }
                if (!parent.isExprResult() || !parent.getParent().isScript()) {
                    t.report(n, NON_TOP_LEVEL_STATEMENT_DEFINE_ERROR, new String[0]);
                    return;
                }
                Node script = parent.getParent();
                Node requiresNode = null;
                Node callback = null;
                int defineArity = n.getChildCount() - 1;
                if (defineArity == 0) {
                    TransformAMDToCJSModule.this.unsupportedDefineError(t, n);
                    return;
                }
                if (defineArity == 1) {
                    callback = n.getChildAtIndex(1);
                    if (callback.isObjectLit()) {
                        this.handleDefineObjectLiteral(parent, callback, script);
                        return;
                    }
                } else if (defineArity == 2) {
                    requiresNode = n.getChildAtIndex(1);
                    callback = n.getChildAtIndex(2);
                } else if (defineArity >= 3) {
                    TransformAMDToCJSModule.this.unsupportedDefineError(t, n);
                    return;
                }
                if (!callback.isFunction() || requiresNode != null && !requiresNode.isArrayLit()) {
                    TransformAMDToCJSModule.this.unsupportedDefineError(t, n);
                    return;
                }
                this.handleRequiresAndParamList(t, n, script, requiresNode, callback);
                Node callbackBlock = callback.getChildAtIndex(2);
                NodeTraversal.traverse(TransformAMDToCJSModule.this.compiler, callbackBlock, new DefineCallbackReturnCallback());
                this.moveCallbackContentToTopLevel(parent, script, callbackBlock);
                TransformAMDToCJSModule.this.compiler.reportCodeChange();
            }
        }

        private void handleDefineObjectLiteral(Node parent, Node onlyExport, Node script) {
            onlyExport.getParent().removeChild(onlyExport);
            script.replaceChild(parent, IR.exprResult(IR.assign(IR.name("exports"), onlyExport)).copyInformationFromForTree(onlyExport));
            TransformAMDToCJSModule.this.compiler.reportCodeChange();
        }

        private void handleRequiresAndParamList(NodeTraversal t, Node defineNode, Node script, Node requiresNode, Node callback) {
            UnmodifiableIterator requires;
            Iterator<Node> paramList = callback.getChildAtIndex(1).children().iterator();
            Iterator<Object> iterator = requires = requiresNode != null ? requiresNode.children().iterator() : Iterators.emptyIterator();
            while (paramList.hasNext() || requires.hasNext()) {
                Node aliasNode = paramList.hasNext() ? paramList.next() : null;
                Node modNode = requires.hasNext() ? (Node)requires.next() : null;
                this.handleRequire(t, defineNode, script, callback, aliasNode, modNode);
            }
        }

        private void handleRequire(NodeTraversal t, Node defineNode, Node script, Node callback, Node aliasNode, Node modNode) {
            Node requireNode;
            String moduleName = null;
            if (modNode != null) {
                moduleName = this.handlePlugins(t, script, modNode.getString(), modNode);
            }
            if (TransformAMDToCJSModule.this.isVirtualModuleName(moduleName)) {
                return;
            }
            String aliasName = aliasNode != null ? aliasNode.getString() : null;
            Scope globalScope = t.getScope();
            if (aliasName != null && globalScope.isDeclared(aliasName, true)) {
                while (true) {
                    String renamed;
                    if (!globalScope.isDeclared(renamed = aliasName + "__alias" + TransformAMDToCJSModule.this.renameIndex, true)) {
                        NodeTraversal.traverse(TransformAMDToCJSModule.this.compiler, callback, new RenameCallback(aliasName, renamed));
                        aliasName = renamed;
                        break;
                    }
                    TransformAMDToCJSModule.this.renameIndex++;
                }
            }
            if (moduleName != null) {
                Node call = IR.call(IR.name("require"), IR.string(moduleName));
                call.putBooleanProp(50, true);
                requireNode = aliasName != null ? IR.var(IR.name(aliasName), call).copyInformationFromForTree(aliasNode) : IR.exprResult(call).copyInformationFromForTree(modNode);
            } else {
                if (TransformAMDToCJSModule.this.isVirtualModuleName(aliasName)) {
                    return;
                }
                requireNode = IR.var(IR.name(aliasName), IR.nullNode()).copyInformationFromForTree(aliasNode);
            }
            script.addChildBefore(requireNode, defineNode.getParent());
        }

        private String handlePlugins(NodeTraversal t, Node script, String moduleName, Node modNode) {
            if (moduleName.contains("!")) {
                t.report(modNode, REQUIREJS_PLUGINS_NOT_SUPPORTED_WARNING, moduleName);
                int condition = moduleName.indexOf(63);
                if (condition > 0) {
                    if (moduleName.contains(":")) {
                        return null;
                    }
                    return this.handlePlugins(t, script, moduleName.substring(condition + 1), modNode);
                }
                moduleName = null;
            }
            return moduleName;
        }

        private void moveCallbackContentToTopLevel(Node defineParent, Node script, Node callbackBlock) {
            int curIndex = script.getIndexOfChild(defineParent);
            script.removeChild(defineParent);
            callbackBlock.getParent().removeChild(callbackBlock);
            Node before = script.getChildAtIndex(curIndex);
            if (before != null) {
                script.addChildBefore(callbackBlock, before);
            }
            script.addChildToBack(callbackBlock);
            NodeUtil.tryMergeBlock(callbackBlock);
        }
    }
}

