/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerInput;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.rhino.InputId;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class SyntacticScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private Scope scope;
    private InputId inputId;
    private final RedeclarationHandler redeclarationHandler;
    public static final DiagnosticType VAR_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_VAR_MULTIPLY_DECLARED_ERROR", "Variable {0} first declared in {1}");
    public static final DiagnosticType VAR_ARGUMENTS_SHADOWED_ERROR = DiagnosticType.error("JSC_VAR_ARGUMENTS_SHADOWED_ERROR", "Shadowing \"arguments\" is not allowed");

    SyntacticScopeCreator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.redeclarationHandler = new DefaultRedeclarationHandler();
    }

    SyntacticScopeCreator(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler) {
        this.compiler = compiler;
        this.redeclarationHandler = redeclarationHandler;
    }

    @Override
    public Scope createScope(Node n, Scope parent) {
        this.inputId = null;
        this.scope = parent == null ? new Scope(n, this.compiler) : new Scope(parent, n);
        this.scanRoot(n, parent);
        this.inputId = null;
        Scope returnedScope = this.scope;
        this.scope = null;
        return returnedScope;
    }

    private void scanRoot(Node n, Scope parent) {
        if (n.isFunction()) {
            if (this.inputId == null) {
                this.inputId = NodeUtil.getInputId(n);
            }
            Node fnNameNode = n.getFirstChild();
            Node args = fnNameNode.getNext();
            Node body = args.getNext();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && NodeUtil.isFunctionExpression(n)) {
                this.declareVar(fnNameNode);
            }
            Preconditions.checkState(args.isParamList());
            for (Node a = args.getFirstChild(); a != null; a = a.getNext()) {
                Preconditions.checkState(a.isName());
                this.declareVar(a);
            }
            this.scanVars(body, n);
        } else {
            Preconditions.checkState(this.scope.getParent() == null);
            this.scanVars(n, null);
        }
    }

    private void scanVars(Node n, Node parent) {
        switch (n.getType()) {
            case 118: {
                Node child = n.getFirstChild();
                while (child != null) {
                    Node next = child.getNext();
                    this.declareVar(child);
                    child = next;
                }
                return;
            }
            case 105: {
                if (NodeUtil.isFunctionExpression(n)) {
                    return;
                }
                String fnName = n.getFirstChild().getString();
                if (fnName.isEmpty()) {
                    return;
                }
                this.declareVar(n.getFirstChild());
                return;
            }
            case 120: {
                Preconditions.checkState(n.getChildCount() == 2);
                Preconditions.checkState(n.getFirstChild().isName());
                Node var = n.getFirstChild();
                Node block = var.getNext();
                this.declareVar(var);
                this.scanVars(block, n);
                return;
            }
            case 132: {
                this.inputId = n.getInputId();
                Preconditions.checkNotNull(this.inputId);
            }
        }
        if (NodeUtil.isControlStructure(n) || NodeUtil.isStatementBlock(n)) {
            Node child = n.getFirstChild();
            while (child != null) {
                Node next = child.getNext();
                this.scanVars(child, n);
                child = next;
            }
        }
    }

    private void declareVar(Node n) {
        Preconditions.checkState(n.isName());
        CompilerInput input = this.compiler.getInput(this.inputId);
        String name = n.getString();
        if (this.scope.isDeclared(name, false) || this.scope.isLocal() && name.equals("arguments")) {
            this.redeclarationHandler.onRedeclaration(this.scope, name, n, input);
        } else {
            this.scope.declare(name, n, null, input);
        }
    }

    static boolean hasDuplicateDeclarationSuppression(Node n, Scope.Var origVar) {
        Preconditions.checkState(n.isName());
        Node parent = n.getParent();
        Node origParent = origVar.getParentNode();
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            info = parent.getJSDocInfo();
        }
        if (info != null && info.getSuppressions().contains("duplicate")) {
            return true;
        }
        info = origVar.nameNode.getJSDocInfo();
        if (info == null) {
            info = origParent.getJSDocInfo();
        }
        return info != null && info.getSuppressions().contains("duplicate");
    }

    static Scope generateUntypedTopScope(AbstractCompiler compiler) {
        return new SyntacticScopeCreator(compiler).createScope(compiler.getRoot(), null);
    }

    private class DefaultRedeclarationHandler
    implements RedeclarationHandler {
        private DefaultRedeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Node parent = n.getParent();
            if (SyntacticScopeCreator.this.scope.isGlobal()) {
                Scope.Var origVar = SyntacticScopeCreator.this.scope.getVar(name);
                Node origParent = origVar.getParentNode();
                if (origParent.isCatch() && parent.isCatch()) {
                    return;
                }
                boolean allowDupe = SyntacticScopeCreator.hasDuplicateDeclarationSuppression(n, origVar);
                if (!allowDupe) {
                    SyntacticScopeCreator.this.compiler.report(JSError.make(NodeUtil.getSourceName(n), n, VAR_MULTIPLY_DECLARED_ERROR, name, origVar.input != null ? origVar.input.getName() : "??"));
                }
            } else if (name.equals("arguments") && !NodeUtil.isVarDeclaration(n)) {
                SyntacticScopeCreator.this.compiler.report(JSError.make(NodeUtil.getSourceName(n), n, VAR_ARGUMENTS_SHADOWED_ERROR, new String[0]));
            }
        }
    }

    static interface RedeclarationHandler {
        public void onRedeclaration(Scope var1, String var2, Node var3, CompilerInput var4);
    }
}

