/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    private final String sourceFile;
    private final boolean doSanityChecks;

    public SourceInformationAnnotator(String sourceFile, boolean doSanityChecks) {
        this.sourceFile = sourceFile;
        this.doSanityChecks = doSanityChecks;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.doSanityChecks && this.sourceFile != null) {
            Preconditions.checkState(this.sourceFile.equals(n.getSourceFileName()));
        }
        switch (n.getType()) {
            case 33: {
                Node propNode = n.getLastChild();
                this.setOriginalName(n, propNode.getString());
                break;
            }
            case 105: {
                String functionName = NodeUtil.getNearestFunctionName(n);
                if (functionName == null) break;
                this.setOriginalName(n, functionName);
                break;
            }
            case 38: {
                this.setOriginalName(n, n.getString());
                break;
            }
            case 64: {
                for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                    if (key.isQuotedString()) continue;
                    this.setOriginalName(key, key.getString());
                }
                break;
            }
        }
    }

    void setOriginalName(Node n, String name) {
        if (!name.isEmpty() && n.getProp(40) == null) {
            n.putProp(40, name);
        }
    }
}

