/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionSite;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionsRemover;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SimpleDefinitionFinder;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.UseSite;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class SimpleFunctionAliasAnalysis {
    private Set<Node> aliasedFunctions;
    private Set<Node> functionsExposedToCallOrApply;

    SimpleFunctionAliasAnalysis() {
    }

    public boolean isAliased(Node functionNode) {
        Preconditions.checkNotNull(this.aliasedFunctions);
        Preconditions.checkArgument(functionNode.isFunction());
        return this.aliasedFunctions.contains(functionNode);
    }

    public boolean isExposedToCallOrApply(Node functionNode) {
        Preconditions.checkNotNull(this.functionsExposedToCallOrApply);
        Preconditions.checkArgument(functionNode.isFunction());
        return this.functionsExposedToCallOrApply.contains(functionNode);
    }

    public void analyze(SimpleDefinitionFinder finder) {
        Preconditions.checkState(this.aliasedFunctions == null);
        this.aliasedFunctions = Sets.newHashSet();
        this.functionsExposedToCallOrApply = Sets.newHashSet();
        for (DefinitionSite definitionSite : finder.getDefinitionSites()) {
            Node rValue;
            DefinitionsRemover.Definition definition = definitionSite.definition;
            if (definition.isExtern() || (rValue = definition.getRValue()) == null || !rValue.isFunction()) continue;
            for (UseSite useSite : finder.getUseSites(definition)) {
                this.updateFunctionForUse(rValue, useSite.node);
            }
        }
    }

    private void updateFunctionForUse(Node function, Node useNode) {
        Node useParent = useNode.getParent();
        int parentType = useParent.getType();
        if (parentType != 37 && parentType != 30 || useParent.getFirstChild() != useNode) {
            if (NodeUtil.isGet(useParent)) {
                Node gramps;
                if (useParent.isGetProp() && (NodeUtil.isFunctionObjectApply(gramps = useParent.getParent()) || NodeUtil.isFunctionObjectCall(gramps))) {
                    this.functionsExposedToCallOrApply.add(function);
                }
            } else {
                this.aliasedFunctions.add(function);
            }
        }
    }
}

