/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.WarningsGuard;

public class ShowByPathWarningsGuard
extends WarningsGuard {
    private final String[] paths;
    private final ShowType showType;

    public ShowByPathWarningsGuard(String checkWarningsOnlyForPath) {
        this(checkWarningsOnlyForPath, ShowType.INCLUDE);
    }

    public ShowByPathWarningsGuard(String[] checkWarningsOnlyForPath) {
        this(checkWarningsOnlyForPath, ShowType.INCLUDE);
    }

    public ShowByPathWarningsGuard(String path, ShowType showType) {
        this(new String[]{path}, showType);
    }

    public ShowByPathWarningsGuard(String[] paths, ShowType showType) {
        Preconditions.checkArgument(paths != null);
        Preconditions.checkArgument(showType != null);
        this.paths = paths;
        this.showType = showType;
    }

    @Override
    public CheckLevel level(JSError error) {
        String errorPath = error.sourceName;
        if (error.getDefaultLevel() != CheckLevel.ERROR && errorPath != null) {
            boolean inPath = false;
            for (String path : this.paths) {
                inPath |= errorPath.contains(path);
            }
            if (inPath ^ this.showType == ShowType.INCLUDE) {
                return CheckLevel.OFF;
            }
        }
        return null;
    }

    @Override
    protected int getPriority() {
        return WarningsGuard.Priority.FILTER_BY_PATH.value;
    }

    public static enum ShowType {
        INCLUDE,
        EXCLUDE;

    }
}

