/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.rhino.ErrorReporter;
import org.jetbrains.jet.internal.com.google.javascript.rhino.ScriptRuntime;
import org.jetbrains.jet.internal.com.google.javascript.rhino.head.EvaluatorException;

class RhinoErrorReporter {
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("JSC_PARSE_ERROR", "Parse error. {0}");
    static final DiagnosticType TYPE_PARSE_ERROR = DiagnosticType.warning("JSC_TYPE_PARSE_ERROR", "{0}");
    static final DiagnosticType EXTRA_FILEOVERVIEW = DiagnosticType.warning("JSC_EXTRA_FILEOVERVIEW", "Parse error. {0}");
    static final DiagnosticType TRAILING_COMMA = DiagnosticType.error("JSC_TRAILING_COMMA", "Parse error. Internet Explorer has a non-standard intepretation of trailing commas. Arrays will have the wrong length and objects will not parse at all.");
    static final DiagnosticType DUPLICATE_PARAM = DiagnosticType.error("JSC_DUPLICATE_PARAM", "Parse error. {0}");
    static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Parse error. {0}");
    private final Map<Pattern, DiagnosticType> typeMap;
    private final AbstractCompiler compiler;

    private Pattern replacePlaceHolders(String s) {
        s = Pattern.quote(s);
        return Pattern.compile(s.replaceAll("\\{\\d+\\}", "\\\\E.*\\\\Q"));
    }

    private RhinoErrorReporter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeMap = ImmutableMap.of(this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.jsdoc.fileoverview.extra")), EXTRA_FILEOVERVIEW, this.replacePlaceHolders(org.jetbrains.jet.internal.com.google.javascript.rhino.head.ScriptRuntime.getMessage0("msg.extra.trailing.comma")), TRAILING_COMMA, this.replacePlaceHolders(org.jetbrains.jet.internal.com.google.javascript.rhino.head.ScriptRuntime.getMessage0("msg.dup.parms")), DUPLICATE_PARAM, this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.bad.jsdoc.tag")), BAD_JSDOC_ANNOTATION, Pattern.compile("^Bad type annotation.*"), TYPE_PARSE_ERROR);
    }

    public static org.jetbrains.jet.internal.com.google.javascript.rhino.head.ErrorReporter forNewRhino(AbstractCompiler compiler) {
        return new NewRhinoErrorReporter(compiler);
    }

    public static ErrorReporter forOldRhino(AbstractCompiler compiler) {
        return new OldRhinoErrorReporter(compiler);
    }

    public void warning(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.WARNING));
    }

    public void error(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.ERROR));
    }

    private JSError makeError(String message, String sourceName, int line, int lineOffset, CheckLevel defaultLevel) {
        for (Map.Entry<Pattern, DiagnosticType> entry : this.typeMap.entrySet()) {
            if (!entry.getKey().matcher(message).matches()) continue;
            return JSError.make(sourceName, line, lineOffset, entry.getValue(), message);
        }
        return JSError.make(sourceName, line, lineOffset, defaultLevel, PARSE_ERROR, message);
    }

    private static class NewRhinoErrorReporter
    extends RhinoErrorReporter
    implements org.jetbrains.jet.internal.com.google.javascript.rhino.head.ErrorReporter {
        private NewRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int line, String sourceLine, int lineOffset) {
            super.error(message, sourceName, line, lineOffset);
        }

        @Override
        public void warning(String message, String sourceName, int line, String sourceLine, int lineOffset) {
            super.warning(message, sourceName, line, lineOffset);
        }
    }

    private static class OldRhinoErrorReporter
    extends RhinoErrorReporter
    implements ErrorReporter {
        private OldRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler);
        }
    }
}

