/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.HashMultimap;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NameGenerator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.VariableMap;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;

class ReplaceStrings
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType BAD_REPLACEMENT_CONFIGURATION = DiagnosticType.warning("JSC_BAD_REPLACEMENT_CONFIGURATION", "Bad replacement configuration.");
    private final String DEFAULT_PLACEHOLDER_TOKEN = "`";
    private final String placeholderToken;
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final Map<String, Config> functions = Maps.newHashMap();
    private final Multimap<String, String> methods = HashMultimap.create();
    private final NameGenerator nameGenerator;
    private final Map<String, Result> results = Maps.newLinkedHashMap();

    ReplaceStrings(AbstractCompiler compiler, String placeholderToken, List<String> functionsToInspect, Set<String> reservedNames) {
        this.compiler = compiler;
        this.placeholderToken = placeholderToken.isEmpty() ? "`" : placeholderToken;
        this.registry = compiler.getTypeRegistry();
        this.nameGenerator = ReplaceStrings.createNameGenerator(reservedNames);
        this.parseConfiguration(functionsToInspect);
    }

    VariableMap getStringMap() {
        HashMap<String, String> map = Maps.newHashMap();
        for (Result result : this.results.values()) {
            map.put(result.replacement, this.escapeForVariableMap(result.original));
        }
        VariableMap stringMap = new VariableMap(map);
        return stringMap;
    }

    private String escapeForVariableMap(String original) {
        return original.replace("\\", "\\\\").replace("\n", "\\n");
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 30: 
            case 37: {
                JSType type;
                Config config;
                Node lhs;
                String methodName;
                Collection<String> classes;
                Node rhs;
                Config config2;
                Node calledFn = n.getFirstChild();
                String name = calledFn.getQualifiedName();
                if (name != null && (config2 = this.findMatching(name)) != null) {
                    this.doSubstitutions(t, config2, n);
                    return;
                }
                if (!NodeUtil.isGet(calledFn) || !(rhs = calledFn.getLastChild()).isName() && !rhs.isString() || (classes = this.methods.get(methodName = rhs.getString())) == null || (lhs = calledFn.getFirstChild()).getJSType() == null || (config = this.findMatchingClass(type = lhs.getJSType().restrictByNotNullOrUndefined(), classes)) == null) break;
                this.doSubstitutions(t, config, n);
                return;
            }
        }
    }

    private Config findMatching(String name) {
        Config config = this.functions.get(name);
        if (config == null) {
            name = name.replace('$', '.');
            config = this.functions.get(name);
        }
        return config;
    }

    private Config findMatchingClass(JSType callClassType, Collection<String> declarationNames) {
        if (!callClassType.isNoObjectType() && !callClassType.isUnknownType()) {
            for (String declarationName : declarationNames) {
                String className = this.getClassFromDeclarationName(declarationName);
                JSType methodClassType = this.registry.getType(className);
                if (methodClassType == null || !callClassType.isSubtype(methodClassType)) continue;
                return this.functions.get(declarationName);
            }
        }
        return null;
    }

    private void doSubstitutions(NodeTraversal t, Config config, Node n) {
        Preconditions.checkState(n.isNew() || n.isCall());
        if (config.parameter != 0) {
            Node arg = n.getChildAtIndex(config.parameter);
            if (arg != null) {
                this.replaceExpression(t, arg, n);
            }
        } else {
            Node firstParam;
            for (Node arg = firstParam = n.getFirstChild().getNext(); arg != null; arg = arg.getNext()) {
                arg = this.replaceExpression(t, arg, n);
            }
        }
    }

    private Node replaceExpression(NodeTraversal t, Node expr, Node parent) {
        Node replacement;
        String replacementString;
        String key = null;
        switch (expr.getType()) {
            case 40: {
                key = expr.getString();
                replacementString = this.getReplacement(key);
                replacement = IR.string(replacementString);
                break;
            }
            case 21: {
                StringBuilder keyBuilder = new StringBuilder();
                Node keyNode = IR.string("");
                replacement = this.buildReplacement(expr, keyNode, keyBuilder);
                key = keyBuilder.toString();
                replacementString = this.getReplacement(key);
                keyNode.setString(replacementString);
                break;
            }
            case 38: {
                Node value;
                Scope.Var var = t.getScope().getVar(expr.getString());
                if (var != null && var.isConst() && (value = var.getInitialValue()) != null && value.isString()) {
                    key = value.getString();
                    replacementString = this.getReplacement(key);
                    replacement = IR.string(replacementString);
                    break;
                }
                return expr;
            }
            default: {
                return expr;
            }
        }
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(replacementString);
        this.recordReplacement(expr, key, replacementString);
        parent.replaceChild(expr, replacement);
        this.compiler.reportCodeChange();
        return replacement;
    }

    private String getReplacement(String key) {
        Result result = this.results.get(key);
        if (result != null) {
            return result.replacement;
        }
        String replacement = this.nameGenerator.generateNextName();
        result = new Result(key, replacement);
        this.results.put(key, result);
        return replacement;
    }

    private void recordReplacement(Node n, String key, String replacement) {
        Result result = this.results.get(key);
        Preconditions.checkState(result != null);
        result.addLocation(n);
    }

    private Node buildReplacement(Node expr, Node prefix, StringBuilder keyBuilder) {
        switch (expr.getType()) {
            case 21: {
                Node left = expr.getFirstChild();
                Node right = left.getNext();
                prefix = this.buildReplacement(left, prefix, keyBuilder);
                return this.buildReplacement(right, prefix, keyBuilder);
            }
            case 40: {
                keyBuilder.append(expr.getString());
                return prefix;
            }
        }
        keyBuilder.append(this.placeholderToken);
        prefix = IR.add(prefix, IR.string(this.placeholderToken));
        return IR.add(prefix, expr.cloneTree());
    }

    private String getMethodFromDeclarationName(String fullDeclarationName) {
        String[] parts = fullDeclarationName.split("\\.prototype\\.");
        Preconditions.checkState(parts.length == 1 || parts.length == 2);
        if (parts.length == 2) {
            return parts[1];
        }
        return null;
    }

    private String getClassFromDeclarationName(String fullDeclarationName) {
        String[] parts = fullDeclarationName.split("\\.prototype\\.");
        Preconditions.checkState(parts.length == 1 || parts.length == 2);
        if (parts.length == 2) {
            return parts[0];
        }
        return null;
    }

    private void parseConfiguration(List<String> functionsToInspect) {
        for (String function : functionsToInspect) {
            Config config = this.parseConfiguration(function);
            this.functions.put(config.name, config);
            String method = this.getMethodFromDeclarationName(config.name);
            if (method == null) continue;
            this.methods.put(method, config.name);
        }
    }

    private Config parseConfiguration(String function) {
        String[] parts;
        int first = function.indexOf(40);
        int last = function.indexOf(41);
        Preconditions.checkState(first != -1 && last != -1);
        String name = function.substring(0, first);
        String params = function.substring(first + 1, last);
        int paramCount = 0;
        int replacementParameter = -1;
        for (String param : parts = params.split(",")) {
            ++paramCount;
            if (param.equals("*")) {
                Preconditions.checkState(paramCount == 1 && parts.length == 1);
                replacementParameter = 0;
                continue;
            }
            if (param.equals("?")) {
                Preconditions.checkState(replacementParameter == -1);
                replacementParameter = paramCount;
                continue;
            }
            Preconditions.checkState(param.isEmpty(), "Unknown marker", param);
        }
        Preconditions.checkState(replacementParameter != -1);
        return new Config(name, replacementParameter);
    }

    private static NameGenerator createNameGenerator(Set<String> reservedNames) {
        String namePrefix = "";
        char[] reservedChars = new char[]{};
        return new NameGenerator(ImmutableSet.copyOf(reservedNames), "", reservedChars);
    }

    class Location {
        public final String sourceFile;
        public final int line;
        public final int column;

        Location(String sourceFile, int line, int column) {
            this.sourceFile = sourceFile;
            this.line = line;
            this.column = column;
        }
    }

    class Result {
        public final String original;
        public final String replacement;
        public final List<Location> replacementLocations = Lists.newLinkedList();

        Result(String original, String replacement) {
            this.original = original;
            this.replacement = replacement;
        }

        void addLocation(Node n) {
            this.replacementLocations.add(new Location(n.getSourceFileName(), n.getLineno(), n.getCharno()));
        }
    }

    private class Config {
        final String name;
        final int parameter;

        Config(String name, int parameter) {
            this.name = name;
            this.parameter = parameter;
        }
    }
}

