/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ArrayListMultimap;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Multimap;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionSite;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionsRemover;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.OptimizeCalls;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SimpleDefinitionFinder;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SyntacticScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.UseSite;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class RemoveUnusedVars
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final boolean removeGlobals;
    private boolean preserveFunctionExpressionNames;
    private final Set<Scope.Var> referenced = Sets.newHashSet();
    private final List<Scope.Var> maybeUnreferenced = Lists.newArrayList();
    private final List<Scope> allFunctionScopes = Lists.newArrayList();
    private final Multimap<Scope.Var, Assign> assignsByVar = ArrayListMultimap.create();
    private final Map<Node, Assign> assignsByNode = Maps.newHashMap();
    private final Multimap<Scope.Var, Node> inheritsCalls = ArrayListMultimap.create();
    private final Multimap<Scope.Var, Continuation> continuations = ArrayListMultimap.create();
    private boolean modifyCallSites;
    private CallSiteOptimizer callSiteOptimizer;

    RemoveUnusedVars(AbstractCompiler compiler, boolean removeGlobals, boolean preserveFunctionExpressionNames, boolean modifyCallSites) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
        this.removeGlobals = removeGlobals;
        this.preserveFunctionExpressionNames = preserveFunctionExpressionNames;
        this.modifyCallSites = modifyCallSites;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized());
        SimpleDefinitionFinder defFinder = null;
        if (this.modifyCallSites) {
            defFinder = new SimpleDefinitionFinder(this.compiler);
            defFinder.process(externs, root);
        }
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, SimpleDefinitionFinder defFinder) {
        if (this.modifyCallSites) {
            Preconditions.checkNotNull(defFinder);
            this.callSiteOptimizer = new CallSiteOptimizer(this.compiler, defFinder);
        }
        this.traverseAndRemoveUnusedReferences(root);
        if (this.callSiteOptimizer != null) {
            this.callSiteOptimizer.applyChanges();
        }
    }

    private void traverseAndRemoveUnusedReferences(Node root) {
        Scope scope = new SyntacticScopeCreator(this.compiler).createScope(root, null);
        this.traverseNode(root, null, scope);
        if (this.removeGlobals) {
            this.collectMaybeUnreferencedVars(scope);
        }
        this.interpretAssigns();
        this.removeUnreferencedVars();
        for (Scope fnScope : this.allFunctionScopes) {
            this.removeUnreferencedFunctionArgs(fnScope);
        }
    }

    private void traverseNode(Node n, Node parent, Scope scope) {
        int type = n.getType();
        Scope.Var var = null;
        switch (type) {
            case 105: {
                if (NodeUtil.isFunctionDeclaration(n)) {
                    var = scope.getVar(n.getFirstChild().getString());
                }
                if (var != null && this.isRemovableVar(var)) {
                    this.continuations.put(var, new Continuation(n, scope));
                } else {
                    this.traverseFunction(n, scope);
                }
                return;
            }
            case 86: {
                Assign maybeAssign = Assign.maybeCreateAssign(n);
                if (maybeAssign == null || (var = scope.getVar(maybeAssign.nameNode.getString())) == null) break;
                this.assignsByVar.put(var, maybeAssign);
                this.assignsByNode.put(maybeAssign.nameNode, maybeAssign);
                if (!this.isRemovableVar(var) || maybeAssign.mayHaveSecondarySideEffects) break;
                this.continuations.put(var, new Continuation(n, scope));
                return;
            }
            case 37: {
                Scope.Var subclassVar;
                CodingConvention.SubclassRelationship subclassRelationship = this.codingConvention.getClassesDefinedByCall(n);
                if (subclassRelationship == null || (subclassVar = scope.getVar(subclassRelationship.subclassName)) == null || !subclassVar.isGlobal() || this.referenced.contains(subclassVar)) break;
                this.inheritsCalls.put(subclassVar, parent);
                this.continuations.put(subclassVar, new Continuation(n, scope));
                return;
            }
            case 38: {
                var = scope.getVar(n.getString());
                if (parent.isVar()) {
                    Node value = n.getFirstChild();
                    if (value == null || var == null || !this.isRemovableVar(var) || NodeUtil.mayHaveSideEffects(value)) break;
                    this.continuations.put(var, new Continuation(n, scope));
                    return;
                }
                if ("arguments".equals(n.getString()) && scope.isLocal()) {
                    Node lp = scope.getRootNode().getFirstChild().getNext();
                    for (Node a = lp.getFirstChild(); a != null; a = a.getNext()) {
                        this.markReferencedVar(scope.getVar(a.getString()));
                    }
                }
                if (var == null) break;
                if (this.isRemovableVar(var)) {
                    if (this.assignsByNode.containsKey(n)) break;
                    this.markReferencedVar(var);
                    break;
                }
                this.markReferencedVar(var);
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.traverseNode(c, n, scope);
        }
    }

    private boolean isRemovableVar(Scope.Var var) {
        if (!this.removeGlobals && var.isGlobal()) {
            return false;
        }
        if (this.referenced.contains(var)) {
            return false;
        }
        return !this.codingConvention.isExported(var.getName());
    }

    private void traverseFunction(Node n, Scope parentScope) {
        Preconditions.checkState(n.getChildCount() == 3);
        Preconditions.checkState(n.isFunction());
        Node body = n.getLastChild();
        Preconditions.checkState(body.getNext() == null && body.isBlock());
        Scope fnScope = new SyntacticScopeCreator(this.compiler).createScope(n, parentScope);
        this.traverseNode(body, n, fnScope);
        this.collectMaybeUnreferencedVars(fnScope);
        this.allFunctionScopes.add(fnScope);
    }

    private void collectMaybeUnreferencedVars(Scope scope) {
        Iterator<Scope.Var> it = scope.getVars();
        while (it.hasNext()) {
            Scope.Var var = it.next();
            if (!this.isRemovableVar(var)) continue;
            this.maybeUnreferenced.add(var);
        }
    }

    private void removeUnreferencedFunctionArgs(Scope fnScope) {
        boolean modifyCallers;
        Node function = fnScope.getRootNode();
        Preconditions.checkState(function.isFunction());
        if (NodeUtil.isGetOrSetKey(function.getParent())) {
            return;
        }
        Node argList = RemoveUnusedVars.getFunctionArgList(function);
        boolean bl = modifyCallers = this.modifyCallSites && this.callSiteOptimizer.canModifyCallers(function);
        if (!modifyCallers) {
            Scope.Var var;
            Node lastArg;
            while ((lastArg = argList.getLastChild()) != null && !this.referenced.contains(var = fnScope.getVar(lastArg.getString()))) {
                argList.removeChild(lastArg);
                this.compiler.reportCodeChange();
            }
        } else {
            this.callSiteOptimizer.optimize(fnScope, this.referenced);
        }
    }

    private static Node getFunctionArgList(Node function) {
        return function.getFirstChild().getNext();
    }

    private void interpretAssigns() {
        boolean changes = false;
        do {
            changes = false;
            for (int current = 0; current < this.maybeUnreferenced.size(); ++current) {
                Node value;
                Scope.Var var = this.maybeUnreferenced.get(current);
                if (this.referenced.contains(var)) {
                    this.maybeUnreferenced.remove(current);
                    --current;
                    continue;
                }
                boolean assignedToUnknownValue = false;
                boolean hasPropertyAssign = false;
                assignedToUnknownValue = var.getParentNode().isVar() && !NodeUtil.isForIn(var.getParentNode().getParent()) ? (value = var.getInitialValue()) != null && !NodeUtil.isLiteralValue(value, true) : true;
                boolean maybeEscaped = false;
                for (Assign assign : this.assignsByVar.get(var)) {
                    if (assign.isPropertyAssign) {
                        hasPropertyAssign = true;
                    } else if (!NodeUtil.isLiteralValue(assign.assignNode.getLastChild(), true)) {
                        assignedToUnknownValue = true;
                    }
                    if (!assign.maybeAliased) continue;
                    maybeEscaped = true;
                }
                if (!assignedToUnknownValue && !maybeEscaped || !hasPropertyAssign) continue;
                changes = this.markReferencedVar(var) || changes;
                this.maybeUnreferenced.remove(current);
                --current;
            }
        } while (changes);
    }

    private void removeAllAssigns(Scope.Var var) {
        for (Assign assign : this.assignsByVar.get(var)) {
            assign.remove();
            this.compiler.reportCodeChange();
        }
    }

    private boolean markReferencedVar(Scope.Var var) {
        if (this.referenced.add(var)) {
            for (Continuation c : this.continuations.get(var)) {
                c.apply();
            }
            return true;
        }
        return false;
    }

    private void removeUnreferencedVars() {
        CodingConvention convention = this.codingConvention;
        for (Scope.Var var : this.maybeUnreferenced) {
            for (Node exprCallNode : this.inheritsCalls.get(var)) {
                NodeUtil.removeChild(exprCallNode.getParent(), exprCallNode);
                this.compiler.reportCodeChange();
            }
            this.removeAllAssigns(var);
            this.compiler.addToDebugLog("Unreferenced var: " + var.name);
            Node nameNode = var.nameNode;
            Node toRemove = nameNode.getParent();
            Node parent = toRemove.getParent();
            Preconditions.checkState(toRemove.isVar() || toRemove.isFunction() || toRemove.isParamList() && parent.isFunction(), "We should only declare vars and functions and function args");
            if (toRemove.isParamList() && parent.isFunction()) continue;
            if (NodeUtil.isFunctionExpression(toRemove)) {
                if (this.preserveFunctionExpressionNames) continue;
                toRemove.getFirstChild().setString("");
                this.compiler.reportCodeChange();
                continue;
            }
            if (parent != null && parent.isFor() && parent.getChildCount() < 4) continue;
            if (toRemove.isVar() && nameNode.hasChildren() && NodeUtil.mayHaveSideEffects(nameNode.getFirstChild())) {
                if (toRemove.getChildCount() != 1) continue;
                parent.replaceChild(toRemove, IR.exprResult(nameNode.removeFirstChild()));
                this.compiler.reportCodeChange();
                continue;
            }
            if (toRemove.isVar() && toRemove.getChildCount() > 1) {
                toRemove.removeChild(nameNode);
                this.compiler.reportCodeChange();
                continue;
            }
            if (parent == null) continue;
            NodeUtil.removeChild(parent, toRemove);
            this.compiler.reportCodeChange();
        }
    }

    private static class Assign {
        final Node assignNode;
        final Node nameNode;
        final boolean isPropertyAssign;
        final boolean mayHaveSecondarySideEffects;
        final boolean maybeAliased;

        Assign(Node assignNode, Node nameNode, boolean isPropertyAssign) {
            Preconditions.checkState(NodeUtil.isAssignmentOp(assignNode));
            this.assignNode = assignNode;
            this.nameNode = nameNode;
            this.isPropertyAssign = isPropertyAssign;
            this.maybeAliased = NodeUtil.isExpressionResultUsed(assignNode);
            this.mayHaveSecondarySideEffects = this.maybeAliased || NodeUtil.mayHaveSideEffects(assignNode.getFirstChild()) || NodeUtil.mayHaveSideEffects(assignNode.getLastChild());
        }

        static Assign maybeCreateAssign(Node assignNode) {
            Preconditions.checkState(NodeUtil.isAssignmentOp(assignNode));
            boolean isPropAssign = false;
            Node current = assignNode.getFirstChild();
            if (NodeUtil.isGet(current)) {
                current = current.getFirstChild();
                isPropAssign = true;
                if (current.isGetProp() && current.getLastChild().getString().equals("prototype")) {
                    current = current.getFirstChild();
                }
            }
            if (current.isName()) {
                return new Assign(assignNode, current, isPropAssign);
            }
            return null;
        }

        void remove() {
            Node parent = this.assignNode.getParent();
            if (this.mayHaveSecondarySideEffects) {
                Node replacement = this.assignNode.getLastChild().detachFromParent();
                Node current = this.assignNode.getFirstChild();
                while (!current.isName()) {
                    if (current.isGetElem()) {
                        replacement = IR.comma(current.getLastChild().detachFromParent(), replacement);
                        replacement.copyInformationFrom(current);
                    }
                    current = current.getFirstChild();
                }
                parent.replaceChild(this.assignNode, replacement);
            } else {
                Node gramps = parent.getParent();
                if (parent.isExprResult()) {
                    gramps.removeChild(parent);
                } else {
                    parent.replaceChild(this.assignNode, this.assignNode.getLastChild().detachFromParent());
                }
            }
        }
    }

    private class Continuation {
        private final Node node;
        private final Scope scope;

        Continuation(Node node, Scope scope) {
            this.node = node;
            this.scope = scope;
        }

        void apply() {
            if (NodeUtil.isFunctionDeclaration(this.node)) {
                RemoveUnusedVars.this.traverseFunction(this.node, this.scope);
            } else {
                for (Node child = this.node.getFirstChild(); child != null; child = child.getNext()) {
                    RemoveUnusedVars.this.traverseNode(child, this.node, this.scope);
                }
            }
        }
    }

    private static class CallSiteOptimizer {
        private final AbstractCompiler compiler;
        private final SimpleDefinitionFinder defFinder;
        private final List<Node> toRemove = Lists.newArrayList();
        private final List<Node> toReplaceWithZero = Lists.newArrayList();

        CallSiteOptimizer(AbstractCompiler compiler, SimpleDefinitionFinder defFinder) {
            this.compiler = compiler;
            this.defFinder = defFinder;
        }

        public void optimize(Scope fnScope, Set<Scope.Var> referenced) {
            Node function = fnScope.getRootNode();
            Preconditions.checkState(function.isFunction());
            Node argList = RemoveUnusedVars.getFunctionArgList(function);
            boolean changeCallSignature = this.canChangeSignature(function);
            this.markUnreferencedFunctionArgs(fnScope, function, referenced, argList.getFirstChild(), 0, changeCallSignature);
        }

        public void applyChanges() {
            for (Node n : this.toRemove) {
                n.getParent().removeChild(n);
                this.compiler.reportCodeChange();
            }
            for (Node n : this.toReplaceWithZero) {
                n.getParent().replaceChild(n, IR.number(0.0).srcref(n));
                this.compiler.reportCodeChange();
            }
        }

        private boolean markUnreferencedFunctionArgs(Scope scope, Node function, Set<Scope.Var> referenced, Node param, int paramIndex, boolean canChangeSignature) {
            if (param != null) {
                boolean hasFollowing = this.markUnreferencedFunctionArgs(scope, function, referenced, param.getNext(), paramIndex + 1, canChangeSignature);
                Scope.Var var = scope.getVar(param.getString());
                if (!referenced.contains(var)) {
                    boolean modifyAllCallSites;
                    Preconditions.checkNotNull(var);
                    boolean bl = modifyAllCallSites = canChangeSignature || !hasFollowing;
                    if (modifyAllCallSites) {
                        modifyAllCallSites = this.canRemoveArgFromCallSites(function, paramIndex);
                    }
                    this.tryRemoveArgFromCallSites(function, paramIndex, modifyAllCallSites);
                    if (modifyAllCallSites || !hasFollowing) {
                        this.toRemove.add(param);
                        return hasFollowing;
                    }
                }
                return true;
            }
            this.tryRemoveAllFollowingArgs(function, paramIndex - 1);
            return false;
        }

        private boolean canRemoveArgFromCallSites(Node function, int argIndex) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            for (UseSite site : this.defFinder.getUseSites(definition)) {
                if (CallSiteOptimizer.isModifiableCallSite(site)) {
                    Node arg = CallSiteOptimizer.getArgumentForCallOrNewOrDotCall(site, argIndex);
                    if (arg == null || !NodeUtil.mayHaveSideEffects(arg, this.compiler)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private void tryRemoveArgFromCallSites(Node function, int argIndex, boolean canModifyAllSites) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            for (UseSite site : this.defFinder.getUseSites(definition)) {
                Node arg;
                if (!CallSiteOptimizer.isModifiableCallSite(site) || (arg = CallSiteOptimizer.getArgumentForCallOrNewOrDotCall(site, argIndex)) == null) continue;
                Node argParent = arg.getParent();
                if (canModifyAllSites || arg.getNext() == null && !NodeUtil.mayHaveSideEffects(arg, this.compiler)) {
                    this.toRemove.add(arg);
                    continue;
                }
                if (NodeUtil.mayHaveSideEffects(arg, this.compiler) || arg.isNumber() && arg.getDouble() == 0.0) continue;
                this.toReplaceWithZero.add(arg);
            }
        }

        private void tryRemoveAllFollowingArgs(Node function, int argIndex) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            for (UseSite site : this.defFinder.getUseSites(definition)) {
                if (!CallSiteOptimizer.isModifiableCallSite(site)) continue;
                for (Node arg = CallSiteOptimizer.getArgumentForCallOrNewOrDotCall(site, argIndex + 1); arg != null; arg = arg.getNext()) {
                    if (NodeUtil.mayHaveSideEffects(arg)) continue;
                    this.toRemove.add(arg);
                }
            }
        }

        private static Node getArgumentForCallOrNewOrDotCall(UseSite site, int argIndex) {
            int adjustedArgIndex = argIndex;
            Node parent = site.node.getParent();
            if (NodeUtil.isFunctionObjectCall(parent)) {
                ++adjustedArgIndex;
            }
            return NodeUtil.getArgumentForCallOrNew(parent, adjustedArgIndex);
        }

        boolean canModifyCallers(Node function) {
            if (NodeUtil.isVarArgsFunction(function)) {
                return false;
            }
            DefinitionSite defSite = this.defFinder.getDefinitionForFunction(function);
            if (defSite == null) {
                return false;
            }
            DefinitionsRemover.Definition definition = defSite.definition;
            if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(function)) {
                return false;
            }
            return this.defFinder.canModifyDefinition(definition);
        }

        private static boolean isModifiableCallSite(UseSite site) {
            return SimpleDefinitionFinder.isCallOrNewSite(site) && !NodeUtil.isFunctionObjectApply(site.node.getParent());
        }

        private boolean canChangeSignature(Node function) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            CodingConvention convention = this.compiler.getCodingConvention();
            Preconditions.checkState(!definition.isExtern());
            Collection<UseSite> useSites = this.defFinder.getUseSites(definition);
            for (UseSite site : useSites) {
                Node parent = site.node.getParent();
                if (parent == null || parent.isCall() && convention.getClassesDefinedByCall(parent) != null) continue;
                if (!(SimpleDefinitionFinder.isCallOrNewSite(site) || parent.isGetProp() && NodeUtil.isFunctionObjectCall(parent.getParent()))) {
                    return false;
                }
                if (NodeUtil.isFunctionObjectApply(parent)) {
                    return false;
                }
                Node nameNode = site.node;
                Collection<DefinitionsRemover.Definition> singleSiteDefinitions = this.defFinder.getDefinitionsReferencedAt(nameNode);
                Preconditions.checkState(singleSiteDefinitions.size() == 1);
                Preconditions.checkState(singleSiteDefinitions.contains(definition));
            }
            return true;
        }

        private DefinitionsRemover.Definition getFunctionDefinition(Node function) {
            DefinitionSite definitionSite = this.defFinder.getDefinitionForFunction(function);
            Preconditions.checkNotNull(definitionSite);
            DefinitionsRemover.Definition definition = definitionSite.definition;
            Preconditions.checkState(!definitionSite.inExterns);
            Preconditions.checkState(definition.getRValue() == function);
            return definition;
        }
    }
}

