/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import java.util.logging.Logger;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AnalyzeNameReferences;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NameReferenceGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.GraphNode;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class RemoveUnusedNames
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(RemoveUnusedNames.class.getName());
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;

    @Override
    public void process(Node externRoot, Node root) {
        AnalyzeNameReferences analyzer = new AnalyzeNameReferences(this.compiler);
        analyzer.process(externRoot, root);
        this.removeUnusedProperties(analyzer.getGraph());
    }

    private void removeUnusedProperties(NameReferenceGraph graph) {
        for (GraphNode node : graph.getNodes()) {
            NameReferenceGraph.Name name = (NameReferenceGraph.Name)node.getValue();
            AnalyzeNameReferences.NameInfo nameInfo = (AnalyzeNameReferences.NameInfo)node.getAnnotation();
            if (nameInfo != null && nameInfo.isReferenced() || !this.canModifyExterns && name.isExtern()) continue;
            name.remove();
            this.compiler.reportCodeChange();
            logger.fine("Removed unused name" + name);
        }
    }
}

