/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class RemoveTryCatch
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<Node> tryNodesContainingReturnStatements;

    RemoveTryCatch(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.tryNodesContainingReturnStatements = new HashSet<Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new RemoveTryCatchCode());
    }

    private class RemoveTryCatchCode
    extends NodeTraversal.AbstractPostOrderCallback {
        private RemoveTryCatchCode() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block0 : switch (n.getType()) {
                case 77: {
                    Node block;
                    Node finallyBlock;
                    JSDocInfo info = n.getJSDocInfo();
                    if (info != null && info.shouldPreserveTry()) {
                        return;
                    }
                    Node tryBlock = n.getFirstChild();
                    Node catchBlock = tryBlock.getNext();
                    Node node = finallyBlock = catchBlock != null ? catchBlock.getNext() : null;
                    if (finallyBlock != null && RemoveTryCatch.this.tryNodesContainingReturnStatements.contains(n)) {
                        return;
                    }
                    if (catchBlock.hasOneChild()) {
                        NodeUtil.redeclareVarsInsideBranch(catchBlock);
                    }
                    n.detachChildren();
                    if (!NodeUtil.isStatementBlock(parent)) {
                        block = IR.block();
                        parent.replaceChild(n, block);
                        block.addChildToFront(tryBlock);
                    } else {
                        parent.replaceChild(n, tryBlock);
                        block = parent;
                    }
                    if (finallyBlock != null) {
                        block.addChildAfter(finallyBlock, tryBlock);
                    }
                    RemoveTryCatch.this.compiler.reportCodeChange();
                    break;
                }
                case 4: {
                    boolean isInTryBlock = false;
                    for (Node anc = parent; anc != null && !anc.isFunction(); anc = anc.getParent()) {
                        if (!anc.isTry()) continue;
                        RemoveTryCatch.this.tryNodesContainingReturnStatements.add(anc);
                        break block0;
                    }
                    break;
                }
            }
        }
    }
}

