/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.base.Predicate;
import closurecompiler.internal.com.google.common.base.Predicates;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.HotSwapCompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.InputId;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticReference;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSourceFile;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSymbolTable;

class ReferenceCollectingCallback
implements HotSwapCompilerPass,
NodeTraversal.ScopedCallback,
StaticSymbolTable<Scope.Var, Reference> {
    private final Map<Scope.Var, ReferenceCollection> referenceMap = Maps.newHashMap();
    private final Deque<BasicBlock> blockStack = new ArrayDeque<BasicBlock>();
    private final Behavior behavior;
    private final AbstractCompiler compiler;
    private final Predicate<Scope.Var> varFilter;
    static Behavior DO_NOTHING_BEHAVIOR = new Behavior(){

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
        }
    };

    ReferenceCollectingCallback(AbstractCompiler compiler, Behavior behavior) {
        this(compiler, behavior, Predicates.alwaysTrue());
    }

    ReferenceCollectingCallback(AbstractCompiler compiler, Behavior behavior, Predicate<Scope.Var> varFilter) {
        this.compiler = compiler;
        this.behavior = behavior;
        this.varFilter = varFilter;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList(externs, root), this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public Iterable<Scope.Var> getAllSymbols() {
        return this.referenceMap.keySet();
    }

    public Scope getScope(Scope.Var var) {
        return var.scope;
    }

    public ReferenceCollection getReferences(Scope.Var v) {
        return this.referenceMap.get(v);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Scope.Var v;
        if (n.isName() && (v = n.getString().equals("arguments") ? t.getScope().getArgumentsVar() : t.getScope().getVar(n.getString())) != null && this.varFilter.apply(v)) {
            this.addReference(t, v, new Reference(n, t, this.blockStack.peek()));
        }
        if (ReferenceCollectingCallback.isBlockBoundary(n, parent)) {
            this.blockStack.pop();
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node n = t.getScope().getRootNode();
        BasicBlock parent = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        this.blockStack.push(new BasicBlock(parent, n));
    }

    @Override
    public void exitScope(NodeTraversal t) {
        this.blockStack.pop();
        if (t.getScope().isGlobal()) {
            this.compiler.updateGlobalVarReferences(this.referenceMap, t.getScopeRoot());
            this.behavior.afterExitScope(t, this.compiler.getGlobalVarReferences());
        } else {
            this.behavior.afterExitScope(t, new ReferenceMapWrapper(this.referenceMap));
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (ReferenceCollectingCallback.isBlockBoundary(n, parent)) {
            this.blockStack.push(new BasicBlock(this.blockStack.peek(), n));
        }
        return true;
    }

    private static boolean isBlockBoundary(Node n, Node parent) {
        if (parent != null) {
            switch (parent.getType()) {
                case 77: 
                case 113: 
                case 114: 
                case 115: 
                case 119: {
                    return true;
                }
                case 98: 
                case 100: 
                case 101: 
                case 108: {
                    return n != parent.getFirstChild();
                }
            }
        }
        return n.isCase();
    }

    private void addReference(NodeTraversal t, Scope.Var v, Reference reference) {
        ReferenceCollection referenceInfo = this.referenceMap.get(v);
        if (referenceInfo == null) {
            referenceInfo = new ReferenceCollection();
            this.referenceMap.put(v, referenceInfo);
        }
        referenceInfo.add(reference, t, v);
    }

    static final class BasicBlock {
        private final BasicBlock parent;
        private final boolean isHoisted;
        private final boolean isFunction;
        private final boolean isLoop;

        BasicBlock(BasicBlock parent, Node root) {
            int pType;
            this.parent = parent;
            this.isHoisted = NodeUtil.isHoistedFunctionDeclaration(root);
            this.isFunction = root.isFunction();
            this.isLoop = root.getParent() != null ? (pType = root.getParent().getType()) == 114 || pType == 113 || pType == 115 : false;
        }

        BasicBlock getParent() {
            return this.parent;
        }

        boolean isGlobalScopeBlock() {
            return this.getParent() == null;
        }

        boolean provablyExecutesBefore(BasicBlock thatBlock) {
            BasicBlock currentBlock;
            for (currentBlock = thatBlock; currentBlock != null && currentBlock != this; currentBlock = currentBlock.getParent()) {
                if (!currentBlock.isHoisted) continue;
                return false;
            }
            if (currentBlock == this) {
                return true;
            }
            return this.isGlobalScopeBlock() && thatBlock.isGlobalScopeBlock();
        }
    }

    static final class Reference
    implements StaticReference<JSType> {
        private static final Set<Integer> DECLARATION_PARENTS = ImmutableSet.of(Integer.valueOf(118), Integer.valueOf(105), Integer.valueOf(120));
        private final Node nameNode;
        private final BasicBlock basicBlock;
        private final Scope scope;
        private final InputId inputId;
        private final StaticSourceFile sourceFile;

        Reference(Node nameNode, NodeTraversal t, BasicBlock basicBlock) {
            this(nameNode, basicBlock, t.getScope(), t.getInput().getInputId());
        }

        private Reference(Node nameNode, BasicBlock basicBlock, Scope scope, InputId inputId) {
            this.nameNode = nameNode;
            this.basicBlock = basicBlock;
            this.scope = scope;
            this.inputId = inputId;
            this.sourceFile = nameNode.getStaticSourceFile();
        }

        Reference cloneWithNewScope(Scope newScope) {
            return new Reference(this.nameNode, this.basicBlock, newScope, this.inputId);
        }

        public Scope.Var getSymbol() {
            return this.scope.getVar(this.nameNode.getString());
        }

        @Override
        public Node getNode() {
            return this.nameNode;
        }

        public InputId getInputId() {
            return this.inputId;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.sourceFile;
        }

        boolean isDeclaration() {
            Node parent = this.getParent();
            Node grandparent = parent.getParent();
            return DECLARATION_PARENTS.contains(parent.getType()) || parent.isParamList() && grandparent.isFunction();
        }

        boolean isVarDeclaration() {
            return this.getParent().isVar();
        }

        boolean isHoistedFunction() {
            return NodeUtil.isHoistedFunctionDeclaration(this.getParent());
        }

        boolean isInitializingDeclaration() {
            return this.isDeclaration() && !this.getParent().isVar() || this.nameNode.getFirstChild() != null;
        }

        Node getAssignedValue() {
            Node parent = this.getParent();
            return parent.isFunction() ? parent : NodeUtil.getAssignedValue(this.nameNode);
        }

        BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        Node getParent() {
            return this.getNode().getParent();
        }

        Node getGrandparent() {
            Node parent = this.getParent();
            return parent == null ? null : parent.getParent();
        }

        private static boolean isLhsOfForInExpression(Node n) {
            Node parent = n.getParent();
            if (parent.isVar()) {
                return Reference.isLhsOfForInExpression(parent);
            }
            return NodeUtil.isForIn(parent) && parent.getFirstChild() == n;
        }

        boolean isSimpleAssignmentToName() {
            Node parent = this.getParent();
            return parent.isAssign() && parent.getFirstChild() == this.nameNode;
        }

        boolean isLvalue() {
            Node parent = this.getParent();
            int parentType = parent.getType();
            return parentType == 118 && this.nameNode.getFirstChild() != null || parentType == 102 || parentType == 103 || NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == this.nameNode || Reference.isLhsOfForInExpression(this.nameNode);
        }

        Scope getScope() {
            return this.scope;
        }
    }

    static class ReferenceCollection
    implements Iterable<Reference> {
        List<Reference> references = Lists.newArrayList();

        ReferenceCollection() {
        }

        @Override
        public Iterator<Reference> iterator() {
            return this.references.iterator();
        }

        void add(Reference reference, NodeTraversal t, Scope.Var v) {
            this.references.add(reference);
        }

        protected boolean isWellDefined() {
            int size = this.references.size();
            if (size == 0) {
                return false;
            }
            Reference init = this.getInitializingReference();
            if (init == null) {
                return false;
            }
            Preconditions.checkState(this.references.get(0).isDeclaration());
            BasicBlock initBlock = init.getBasicBlock();
            for (int i = 1; i < size; ++i) {
                if (initBlock.provablyExecutesBefore(this.references.get(i).getBasicBlock())) continue;
                return false;
            }
            return true;
        }

        boolean isEscaped() {
            Scope scope = null;
            for (Reference ref : this.references) {
                if (scope == null) {
                    scope = ref.scope;
                    continue;
                }
                if (scope == ref.scope) continue;
                return true;
            }
            return false;
        }

        private boolean isInitializingDeclarationAt(int index) {
            Reference maybeInit = this.references.get(index);
            return maybeInit.isInitializingDeclaration();
        }

        private boolean isInitializingAssignmentAt(int index) {
            Reference maybeDecl;
            if (index < this.references.size() && index > 0 && (maybeDecl = this.references.get(index - 1)).isVarDeclaration()) {
                Preconditions.checkState(!maybeDecl.isInitializingDeclaration());
                Reference maybeInit = this.references.get(index);
                if (maybeInit.isSimpleAssignmentToName()) {
                    return true;
                }
            }
            return false;
        }

        Reference getInitializingReference() {
            if (this.isInitializingDeclarationAt(0)) {
                return this.references.get(0);
            }
            if (this.isInitializingAssignmentAt(1)) {
                return this.references.get(1);
            }
            return null;
        }

        Reference getInitializingReferenceForConstants() {
            int size = this.references.size();
            for (int i = 0; i < size; ++i) {
                if (!this.isInitializingDeclarationAt(i) && !this.isInitializingAssignmentAt(i)) continue;
                return this.references.get(i);
            }
            return null;
        }

        boolean isAssignedOnceInLifetime() {
            Reference ref = this.getOneAndOnlyAssignment();
            if (ref == null) {
                return false;
            }
            for (BasicBlock block = ref.getBasicBlock(); block != null && !block.isFunction; block = block.getParent()) {
                if (!block.isLoop) continue;
                return false;
            }
            return true;
        }

        private Reference getOneAndOnlyAssignment() {
            Reference assignment = null;
            int size = this.references.size();
            for (int i = 0; i < size; ++i) {
                Reference ref = this.references.get(i);
                if (!ref.isLvalue() && !ref.isInitializingDeclaration()) continue;
                if (assignment == null) {
                    assignment = ref;
                    continue;
                }
                return null;
            }
            return assignment;
        }

        boolean isNeverAssigned() {
            int size = this.references.size();
            for (int i = 0; i < size; ++i) {
                Reference ref = this.references.get(i);
                if (!ref.isLvalue() && !ref.isInitializingDeclaration()) continue;
                return false;
            }
            return true;
        }

        boolean firstReferenceIsAssigningDeclaration() {
            int size = this.references.size();
            return size > 0 && this.references.get(0).isInitializingDeclaration();
        }
    }

    static interface Behavior {
        public void afterExitScope(NodeTraversal var1, ReferenceMap var2);
    }

    private static class ReferenceMapWrapper
    implements ReferenceMap {
        private final Map<Scope.Var, ReferenceCollection> referenceMap;

        public ReferenceMapWrapper(Map<Scope.Var, ReferenceCollection> referenceMap) {
            this.referenceMap = referenceMap;
        }

        @Override
        public ReferenceCollection getReferences(Scope.Var var) {
            return this.referenceMap.get(var);
        }
    }

    static interface ReferenceMap {
        public ReferenceCollection getReferences(Scope.Var var1);
    }
}

