/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.Iterables;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Compiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.FunctionInformationMap;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.FunctionNames;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModuleGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class RecordFunctionInformation
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final Compiler compiler;
    private final FunctionNames functionNames;
    private final JSModuleGraph moduleGraph;
    private final FunctionInformationMap.Builder mapBuilder;

    RecordFunctionInformation(Compiler compiler, FunctionNames functionNames) {
        this.compiler = compiler;
        this.moduleGraph = compiler.getModuleGraph();
        this.functionNames = functionNames;
        this.mapBuilder = FunctionInformationMap.newBuilder();
    }

    FunctionInformationMap getMap() {
        return this.mapBuilder.build();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        if (this.moduleGraph == null) {
            this.addModuleInformation(null);
        } else {
            TreeSet<JSModule> modules = Sets.newTreeSet(new Comparator<JSModule>(){

                @Override
                public int compare(JSModule o1, JSModule o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Iterables.addAll(modules, this.moduleGraph.getAllModules());
            for (JSModule m : modules) {
                this.addModuleInformation(m);
            }
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isFunction()) {
            return;
        }
        int id = this.functionNames.getFunctionId(n);
        if (id < 0) {
            return;
        }
        String compiledSource = this.compiler.toSource(n);
        JSModule module = t.getModule();
        this.mapBuilder.addEntry(FunctionInformationMap.Entry.newBuilder().setId(id).setSourceName(NodeUtil.getSourceName(n)).setLineNumber(n.getLineno()).setModuleName(this.moduleGraph == null ? "" : module.getName()).setSize(compiledSource.length()).setName(this.functionNames.getFunctionName(n)).setCompiledSource(compiledSource).build());
    }

    private void addModuleInformation(JSModule module) {
        String source;
        String name;
        if (module != null) {
            name = module.getName();
            source = this.compiler.toSource(module);
        } else {
            name = "";
            source = this.compiler.toSource();
        }
        this.mapBuilder.addModule(FunctionInformationMap.Module.newBuilder().setName(name).setCompiledSource(source).build());
    }
}

