/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CssRenamingMap;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.HotSwapCompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModuleGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.PreprocessorSymbolTable;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfoBuilder;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class ProcessClosurePrimitives
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType NULL_ARGUMENT_ERROR = DiagnosticType.error("JSC_NULL_ARGUMENT_ERROR", "method \"{0}\" called without an argument");
    static final DiagnosticType EXPECTED_OBJECTLIT_ERROR = DiagnosticType.error("JSC_EXPECTED_OBJECTLIT_ERROR", "method \"{0}\" expected an object literal argument");
    static final DiagnosticType EXPECTED_STRING_ERROR = DiagnosticType.error("JSC_EXPECTED_STRING_ERROR", "method \"{0}\" expected an object string argument");
    static final DiagnosticType INVALID_ARGUMENT_ERROR = DiagnosticType.error("JSC_INVALID_ARGUMENT_ERROR", "method \"{0}\" called with invalid argument");
    static final DiagnosticType INVALID_STYLE_ERROR = DiagnosticType.error("JSC_INVALID_CSS_NAME_MAP_STYLE_ERROR", "Invalid CSS name map style {0}");
    static final DiagnosticType TOO_MANY_ARGUMENTS_ERROR = DiagnosticType.error("JSC_TOO_MANY_ARGUMENTS_ERROR", "method \"{0}\" called with more than one argument");
    static final DiagnosticType DUPLICATE_NAMESPACE_ERROR = DiagnosticType.error("JSC_DUPLICATE_NAMESPACE_ERROR", "namespace \"{0}\" cannot be provided twice");
    static final DiagnosticType FUNCTION_NAMESPACE_ERROR = DiagnosticType.error("JSC_FUNCTION_NAMESPACE_ERROR", "\"{0}\" cannot be both provided and declared as a function");
    static final DiagnosticType MISSING_PROVIDE_ERROR = DiagnosticType.error("JSC_MISSING_PROVIDE_ERROR", "required \"{0}\" namespace never provided");
    static final DiagnosticType LATE_PROVIDE_ERROR = DiagnosticType.error("JSC_LATE_PROVIDE_ERROR", "required \"{0}\" namespace not provided yet");
    static final DiagnosticType INVALID_PROVIDE_ERROR = DiagnosticType.error("JSC_INVALID_PROVIDE_ERROR", "\"{0}\" is not a valid JS property name");
    static final DiagnosticType XMODULE_REQUIRE_ERROR = DiagnosticType.warning("JSC_XMODULE_REQUIRE_ERROR", "namespace \"{0}\" provided in module {1} but required in module {2}");
    static final DiagnosticType NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR = DiagnosticType.error("JSC_NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR", "goog.setCssNameMapping only takes an object literal with string values");
    static final DiagnosticType INVALID_CSS_RENAMING_MAP = DiagnosticType.warning("INVALID_CSS_RENAMING_MAP", "Invalid entries in css renaming map: {0}");
    static final DiagnosticType BASE_CLASS_ERROR = DiagnosticType.error("JSC_BASE_CLASS_ERROR", "incorrect use of goog.base: {0}");
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private final Map<String, ProvidedName> providedNames = Maps.newTreeMap();
    private final List<UnrecognizedRequire> unrecognizedRequires = Lists.newArrayList();
    private final Set<String> exportedVariables = Sets.newHashSet();
    private final CheckLevel requiresLevel;
    private final boolean rewriteNewDateGoogNow;
    private final PreprocessorSymbolTable preprocessorSymbolTable;

    ProcessClosurePrimitives(AbstractCompiler compiler, PreprocessorSymbolTable preprocessorSymbolTable, CheckLevel requiresLevel, boolean rewriteNewDateGoogNow) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.moduleGraph = compiler.getModuleGraph();
        this.requiresLevel = requiresLevel;
        this.rewriteNewDateGoogNow = rewriteNewDateGoogNow;
        this.providedNames.put("goog", new ProvidedName("goog", null, null, false));
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this).traverse(root);
        for (ProvidedName pn : this.providedNames.values()) {
            pn.replace();
        }
        if (this.requiresLevel.isOn()) {
            for (UnrecognizedRequire r : this.unrecognizedRequires) {
                ProvidedName expectedName = this.providedNames.get(r.namespace);
                DiagnosticType error = expectedName != null && expectedName.firstNode != null ? LATE_PROVIDE_ERROR : MISSING_PROVIDE_ERROR;
                this.compiler.report(JSError.make(r.inputName, r.requireNode, this.requiresLevel, error, r.namespace));
            }
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.compiler.process(this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 37: {
                Node name;
                boolean isExpr = parent.isExprResult();
                Node left = n.getFirstChild();
                if (!left.isGetProp() || !(name = left.getFirstChild()).isName() || !"goog".equals(name.getString())) break;
                String methodName = name.getNext().getString();
                if ("base".equals(methodName)) {
                    this.processBaseClassCall(t, n);
                    break;
                }
                if (!isExpr) break;
                if ("require".equals(methodName)) {
                    this.processRequireCall(t, n, parent);
                    break;
                }
                if ("provide".equals(methodName)) {
                    this.processProvideCall(t, n, parent);
                    break;
                }
                if ("exportSymbol".equals(methodName)) {
                    Node arg = left.getNext();
                    if (!arg.isString()) break;
                    int dot = arg.getString().indexOf(46);
                    if (dot == -1) {
                        this.exportedVariables.add(arg.getString());
                        break;
                    }
                    this.exportedVariables.add(arg.getString().substring(0, dot));
                    break;
                }
                if ("addDependency".equals(methodName)) {
                    CodingConvention convention = this.compiler.getCodingConvention();
                    List<String> typeDecls = convention.identifyTypeDeclarationCall(n);
                    if (typeDecls != null) {
                        for (String typeDecl : typeDecls) {
                            this.compiler.getTypeRegistry().forwardDeclareType(typeDecl);
                        }
                    }
                    parent.replaceChild(n, IR.number(0.0));
                    this.compiler.reportCodeChange();
                    break;
                }
                if (!"setCssNameMapping".equals(methodName)) break;
                this.processSetCssNameMapping(t, n, parent);
                break;
            }
            case 38: 
            case 86: {
                this.handleCandidateProvideDefinition(t, n, parent);
                break;
            }
            case 130: {
                this.handleTypedefDefinition(t, n, parent);
                break;
            }
            case 105: {
                String name;
                ProvidedName pn;
                if (!t.inGlobalScope() || NodeUtil.isFunctionExpression(n) || (pn = this.providedNames.get(name = n.getFirstChild().getString())) == null) break;
                this.compiler.report(t.makeError(n, FUNCTION_NAMESPACE_ERROR, name));
                break;
            }
            case 30: {
                this.trySimplifyNewDate(t, n, parent);
                break;
            }
            case 33: {
                if (!n.getFirstChild().isName() || parent.isCall() || parent.isAssign() || !"goog.base".equals(n.getQualifiedName())) break;
                this.reportBadBaseClassUse(t, n, "May only be called directly.");
            }
        }
    }

    private void processRequireCall(NodeTraversal t, Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifyArgument(t, left, arg = left.getNext())) {
            String ns = arg.getString();
            ProvidedName provided = this.providedNames.get(ns);
            if (provided == null || !provided.isExplicitlyProvided()) {
                this.unrecognizedRequires.add(new UnrecognizedRequire(n, ns, t.getSourceName()));
            } else {
                JSModule providedModule = provided.explicitModule;
                Preconditions.checkNotNull(providedModule);
                JSModule module = t.getModule();
                if (this.moduleGraph != null && module != providedModule && !this.moduleGraph.dependsOn(module, providedModule)) {
                    this.compiler.report(t.makeError(n, XMODULE_REQUIRE_ERROR, ns, providedModule.getName(), module.getName()));
                }
            }
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(arg);
            if (provided != null || this.requiresLevel.isOn()) {
                parent.detachFromParent();
                this.compiler.reportCodeChange();
            }
        }
    }

    private void processProvideCall(NodeTraversal t, Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifyProvide(t, left, arg = left.getNext())) {
            String ns = arg.getString();
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(arg);
            if (this.providedNames.containsKey(ns)) {
                ProvidedName previouslyProvided = this.providedNames.get(ns);
                if (!previouslyProvided.isExplicitlyProvided()) {
                    previouslyProvided.addProvide(parent, t.getModule(), true);
                } else {
                    this.compiler.report(t.makeError(n, DUPLICATE_NAMESPACE_ERROR, ns));
                }
            } else {
                this.registerAnyProvidedPrefixes(ns, parent, t.getModule());
                this.providedNames.put(ns, new ProvidedName(ns, parent, t.getModule(), true));
            }
        }
    }

    private void handleTypedefDefinition(NodeTraversal t, Node n, Node parent) {
        ProvidedName pn;
        String name;
        JSDocInfo info = n.getFirstChild().getJSDocInfo();
        if (t.inGlobalScope() && info != null && info.hasTypedefType() && (name = n.getFirstChild().getQualifiedName()) != null && (pn = this.providedNames.get(name)) != null) {
            pn.addDefinition(n, t.getModule());
        }
    }

    private void handleCandidateProvideDefinition(NodeTraversal t, Node n, Node parent) {
        if (t.inGlobalScope()) {
            String name = null;
            if (n.isName() && parent.isVar()) {
                name = n.getString();
            } else if (n.isAssign() && parent.isExprResult()) {
                name = n.getFirstChild().getQualifiedName();
            }
            if (name != null) {
                if (parent.getBooleanProp(46)) {
                    this.processProvideFromPreviousPass(t, name, parent);
                } else {
                    ProvidedName pn = this.providedNames.get(name);
                    if (pn != null) {
                        pn.addDefinition(parent, t.getModule());
                    }
                }
            }
        }
    }

    private void processBaseClassCall(NodeTraversal t, Node n) {
        Node callee = n.getFirstChild();
        Node thisArg = callee.getNext();
        if (thisArg == null || !thisArg.isThis()) {
            this.reportBadBaseClassUse(t, n, "First argument must be 'this'.");
            return;
        }
        Node enclosingFnNameNode = this.getEnclosingDeclNameNode(t);
        if (enclosingFnNameNode == null) {
            this.reportBadBaseClassUse(t, n, "Could not find enclosing method.");
            return;
        }
        String enclosingQname = enclosingFnNameNode.getQualifiedName();
        if (enclosingQname.indexOf(".prototype.") == -1) {
            Node callNode;
            Node enclosingParent = enclosingFnNameNode.getParent();
            Node maybeInheritsExpr = (enclosingParent.isAssign() ? enclosingParent.getParent() : enclosingParent).getNext();
            Node baseClassNode = null;
            if (maybeInheritsExpr != null && maybeInheritsExpr.isExprResult() && maybeInheritsExpr.getFirstChild().isCall() && "goog.inherits".equals((callNode = maybeInheritsExpr.getFirstChild()).getFirstChild().getQualifiedName()) && callNode.getLastChild().isQualifiedName()) {
                baseClassNode = callNode.getLastChild();
            }
            if (baseClassNode == null) {
                this.reportBadBaseClassUse(t, n, "Could not find goog.inherits for base class");
                return;
            }
            n.replaceChild(callee, NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), String.format("%s.call", baseClassNode.getQualifiedName()), callee, "goog.base"));
            this.compiler.reportCodeChange();
        } else {
            Node methodNameNode = thisArg.getNext();
            if (methodNameNode == null || !methodNameNode.isString()) {
                this.reportBadBaseClassUse(t, n, "Second argument must name a method.");
                return;
            }
            String methodName = methodNameNode.getString();
            String ending = ".prototype." + methodName;
            if (enclosingQname == null || !enclosingQname.endsWith(ending)) {
                this.reportBadBaseClassUse(t, n, "Enclosing method does not match " + methodName);
                return;
            }
            Node className = enclosingFnNameNode.getFirstChild().getFirstChild();
            n.replaceChild(callee, NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), String.format("%s.superClass_.%s.call", className.getQualifiedName(), methodName), callee, "goog.base"));
            n.removeChild(methodNameNode);
            this.compiler.reportCodeChange();
        }
    }

    private Node getEnclosingDeclNameNode(NodeTraversal t) {
        Node scopeRoot = t.getScopeRoot();
        if (NodeUtil.isFunctionDeclaration(scopeRoot)) {
            return scopeRoot.getFirstChild();
        }
        Node parent = scopeRoot.getParent();
        if (parent != null) {
            if (parent.isAssign() || parent.getLastChild() == scopeRoot && parent.getFirstChild().isQualifiedName()) {
                return parent.getFirstChild();
            }
            if (parent.isName()) {
                return parent;
            }
        }
        return null;
    }

    private void reportBadBaseClassUse(NodeTraversal t, Node n, String extraMessage) {
        this.compiler.report(t.makeError(n, BASE_CLASS_ERROR, extraMessage));
    }

    private void processProvideFromPreviousPass(NodeTraversal t, String name, Node parent) {
        if (!this.providedNames.containsKey(name)) {
            Node expr = new Node(130);
            expr.copyInformationFromForTree(parent);
            parent.getParent().addChildBefore(expr, parent);
            this.compiler.reportCodeChange();
            JSModule module = t.getModule();
            this.registerAnyProvidedPrefixes(name, expr, module);
            ProvidedName provided = new ProvidedName(name, expr, module, true);
            this.providedNames.put(name, provided);
            provided.addDefinition(parent, module);
        } else if (ProcessClosurePrimitives.isNamespacePlaceholder(parent)) {
            parent.getParent().removeChild(parent);
            this.compiler.reportCodeChange();
        }
    }

    private void processSetCssNameMapping(NodeTraversal t, Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifySetCssNameMapping(t, left, arg = left.getNext())) {
            ArrayList<String> errors;
            CssRenamingMap.Style style;
            final HashMap<String, String> cssNames = Maps.newHashMap();
            for (Node key = arg.getFirstChild(); key != null; key = key.getNext()) {
                Node value = key.getFirstChild();
                if (!key.isString() || value == null || !value.isString()) {
                    this.compiler.report(t.makeError(n, NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR, new String[0]));
                    return;
                }
                cssNames.put(key.getString(), value.getString());
            }
            String styleStr = "BY_PART";
            if (arg.getNext() != null) {
                styleStr = arg.getNext().getString();
            }
            try {
                style = CssRenamingMap.Style.valueOf(styleStr);
            }
            catch (IllegalArgumentException e) {
                this.compiler.report(t.makeError(n, INVALID_STYLE_ERROR, styleStr));
                return;
            }
            if (style == CssRenamingMap.Style.BY_PART) {
                errors = Lists.newArrayList();
                for (String key : cssNames.keySet()) {
                    if (!key.contains("-")) continue;
                    errors.add(key);
                }
                if (errors.size() != 0) {
                    this.compiler.report(t.makeError(n, INVALID_CSS_RENAMING_MAP, ((Object)errors).toString()));
                }
            } else if (style == CssRenamingMap.Style.BY_WHOLE) {
                errors = Lists.newArrayList();
                for (Map.Entry b : cssNames.entrySet()) {
                    if (((String)b.getKey()).length() > 10) continue;
                    for (Map.Entry a : cssNames.entrySet()) {
                        String combined = (String)cssNames.get((String)a.getKey() + "-" + (String)b.getKey());
                        if (combined == null || combined.equals((String)a.getValue() + "-" + (String)b.getValue())) continue;
                        errors.add("map(" + (String)a.getKey() + "-" + (String)b.getKey() + ") != map(" + (String)a.getKey() + ")-map(" + (String)b.getKey() + ")");
                    }
                }
                if (errors.size() != 0) {
                    this.compiler.report(t.makeError(n, INVALID_CSS_RENAMING_MAP, ((Object)errors).toString()));
                }
            }
            CssRenamingMap cssRenamingMap = new CssRenamingMap(){

                @Override
                public String get(String value) {
                    if (cssNames.containsKey(value)) {
                        return (String)cssNames.get(value);
                    }
                    return value;
                }

                @Override
                public CssRenamingMap.Style getStyle() {
                    return style;
                }
            };
            this.compiler.setCssRenamingMap(cssRenamingMap);
            parent.getParent().removeChild(parent);
            this.compiler.reportCodeChange();
        }
    }

    private void trySimplifyNewDate(NodeTraversal t, Node n, Node parent) {
        if (!this.rewriteNewDateGoogNow) {
            return;
        }
        Preconditions.checkArgument(n.isNew());
        Node date = n.getFirstChild();
        if (!date.isName() || !"Date".equals(date.getString())) {
            return;
        }
        Node callGoogNow = date.getNext();
        if (callGoogNow == null || !callGoogNow.isCall() || callGoogNow.getNext() != null) {
            return;
        }
        Node googNow = callGoogNow.getFirstChild();
        String googNowQName = googNow.getQualifiedName();
        if (googNowQName == null || !"goog.now".equals(googNowQName) || googNow.getNext() != null) {
            return;
        }
        n.removeChild(callGoogNow);
        this.compiler.reportCodeChange();
    }

    private boolean verifyProvide(NodeTraversal t, Node methodName, Node arg) {
        if (!this.verifyArgument(t, methodName, arg)) {
            return false;
        }
        for (String part : arg.getString().split("\\.")) {
            if (NodeUtil.isValidPropertyName(part)) continue;
            this.compiler.report(t.makeError(arg, INVALID_PROVIDE_ERROR, part));
            return false;
        }
        return true;
    }

    private boolean verifyArgument(NodeTraversal t, Node methodName, Node arg) {
        return this.verifyArgument(t, methodName, arg, 40);
    }

    private boolean verifyArgument(NodeTraversal t, Node methodName, Node arg, int desiredType) {
        DiagnosticType diagnostic = null;
        if (arg == null) {
            diagnostic = NULL_ARGUMENT_ERROR;
        } else if (arg.getType() != desiredType) {
            diagnostic = INVALID_ARGUMENT_ERROR;
        } else if (arg.getNext() != null) {
            diagnostic = TOO_MANY_ARGUMENTS_ERROR;
        }
        if (diagnostic != null) {
            this.compiler.report(t.makeError(methodName, diagnostic, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifySetCssNameMapping(NodeTraversal t, Node methodName, Node firstArg) {
        DiagnosticType diagnostic = null;
        if (firstArg == null) {
            diagnostic = NULL_ARGUMENT_ERROR;
        } else if (!firstArg.isObjectLit()) {
            diagnostic = EXPECTED_OBJECTLIT_ERROR;
        } else if (firstArg.getNext() != null) {
            Node secondArg = firstArg.getNext();
            if (!secondArg.isString()) {
                diagnostic = EXPECTED_STRING_ERROR;
            } else if (secondArg.getNext() != null) {
                diagnostic = TOO_MANY_ARGUMENTS_ERROR;
            }
        }
        if (diagnostic != null) {
            this.compiler.report(t.makeError(methodName, diagnostic, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void registerAnyProvidedPrefixes(String ns, Node node, JSModule module) {
        int pos = ns.indexOf(46);
        while (pos != -1) {
            String prefixNs = ns.substring(0, pos);
            pos = ns.indexOf(46, pos + 1);
            if (this.providedNames.containsKey(prefixNs)) {
                this.providedNames.get(prefixNs).addProvide(node, module, false);
                continue;
            }
            this.providedNames.put(prefixNs, new ProvidedName(prefixNs, node, module, false));
        }
    }

    private static boolean isNamespacePlaceholder(Node n) {
        if (!n.getBooleanProp(46)) {
            return false;
        }
        Node value = null;
        if (n.isExprResult()) {
            Node assign = n.getFirstChild();
            value = assign.getLastChild();
        } else if (n.isVar()) {
            Node name = n.getFirstChild();
            value = name.getFirstChild();
        }
        return value != null && value.isObjectLit() && !value.hasChildren();
    }

    private void maybeAddStringNodeToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable == null) {
            return;
        }
        String name = n.getString();
        Node syntheticRef = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), name, n, name);
        boolean FOR_QUOTE = true;
        boolean FOR_DOT = true;
        Node current = null;
        current = syntheticRef;
        while (current.isGetProp()) {
            int fullLen = current.getQualifiedName().length();
            int namespaceLen = current.getFirstChild().getQualifiedName().length();
            current.setSourceEncodedPosition(n.getSourcePosition() + 1);
            current.setLength(fullLen);
            current.getLastChild().setSourceEncodedPosition(n.getSourcePosition() + namespaceLen + 1 + 1);
            current.getLastChild().setLength(current.getLastChild().getString().length());
            current = current.getFirstChild();
        }
        current.setSourceEncodedPosition(n.getSourcePosition() + 1);
        current.setLength(current.getString().length());
        this.maybeAddToSymbolTable(syntheticRef);
    }

    private void maybeAddToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addReference(n);
        }
    }

    private class UnrecognizedRequire {
        final Node requireNode;
        final String namespace;
        final String inputName;

        UnrecognizedRequire(Node requireNode, String namespace, String inputName) {
            this.requireNode = requireNode;
            this.namespace = namespace;
            this.inputName = inputName;
        }
    }

    private class ProvidedName {
        private final String namespace;
        private final Node firstNode;
        private final JSModule firstModule;
        private Node explicitNode = null;
        private JSModule explicitModule = null;
        private Node candidateDefinition = null;
        private JSModule minimumModule = null;
        private Node replacementNode = null;

        ProvidedName(String namespace, Node node, JSModule module, boolean explicit) {
            Preconditions.checkArgument(node == null || node.isExprResult());
            this.namespace = namespace;
            this.firstNode = node;
            this.firstModule = module;
            this.addProvide(node, module, explicit);
        }

        void addProvide(Node node, JSModule module, boolean explicit) {
            if (explicit) {
                Preconditions.checkState(this.explicitNode == null);
                Preconditions.checkArgument(node.isExprResult());
                this.explicitNode = node;
                this.explicitModule = module;
            }
            this.updateMinimumModule(module);
        }

        boolean isExplicitlyProvided() {
            return this.explicitNode != null;
        }

        void addDefinition(Node node, JSModule module) {
            Preconditions.checkArgument(node.isExprResult() || node.isFunction() || node.isVar());
            Preconditions.checkArgument(this.explicitNode != node);
            if (this.candidateDefinition == null || !node.isExprResult()) {
                this.candidateDefinition = node;
                this.updateMinimumModule(module);
            }
        }

        private void updateMinimumModule(JSModule newModule) {
            if (this.minimumModule == null) {
                this.minimumModule = newModule;
            } else if (ProcessClosurePrimitives.this.moduleGraph != null) {
                this.minimumModule = ProcessClosurePrimitives.this.moduleGraph.getDeepestCommonDependencyInclusive(this.minimumModule, newModule);
            } else {
                Preconditions.checkState(newModule == this.minimumModule, "Missing module graph");
            }
        }

        void replace() {
            if (this.firstNode == null) {
                this.replacementNode = this.candidateDefinition;
                return;
            }
            if (this.candidateDefinition != null && this.explicitNode != null) {
                this.explicitNode.detachFromParent();
                ProcessClosurePrimitives.this.compiler.reportCodeChange();
                this.replacementNode = this.candidateDefinition;
                if (this.candidateDefinition.isExprResult() && !this.candidateDefinition.getFirstChild().isQualifiedName()) {
                    this.candidateDefinition.putBooleanProp(46, true);
                    Node assignNode = this.candidateDefinition.getFirstChild();
                    Node nameNode = assignNode.getFirstChild();
                    if (nameNode.isName()) {
                        Node valueNode = nameNode.getNext();
                        assignNode.removeChild(nameNode);
                        assignNode.removeChild(valueNode);
                        nameNode.addChildToFront(valueNode);
                        Node varNode = IR.var(nameNode);
                        varNode.copyInformationFrom(this.candidateDefinition);
                        this.candidateDefinition.getParent().replaceChild(this.candidateDefinition, varNode);
                        nameNode.setJSDocInfo(assignNode.getJSDocInfo());
                        ProcessClosurePrimitives.this.compiler.reportCodeChange();
                        this.replacementNode = varNode;
                    }
                }
            } else {
                this.replacementNode = this.createDeclarationNode();
                if (this.firstModule == this.minimumModule) {
                    this.firstNode.getParent().addChildBefore(this.replacementNode, this.firstNode);
                } else {
                    int indexOfDot = this.namespace.lastIndexOf(46);
                    if (indexOfDot == -1) {
                        ProcessClosurePrimitives.this.compiler.getNodeForCodeInsertion(this.minimumModule).addChildToBack(this.replacementNode);
                    } else {
                        ProvidedName parentName = (ProvidedName)ProcessClosurePrimitives.this.providedNames.get(this.namespace.substring(0, indexOfDot));
                        Preconditions.checkNotNull(parentName);
                        Preconditions.checkNotNull(parentName.replacementNode);
                        parentName.replacementNode.getParent().addChildAfter(this.replacementNode, parentName.replacementNode);
                    }
                }
                if (this.explicitNode != null) {
                    this.explicitNode.detachFromParent();
                }
                ProcessClosurePrimitives.this.compiler.reportCodeChange();
            }
        }

        private Node createDeclarationNode() {
            if (this.namespace.indexOf(46) == -1) {
                return this.makeVarDeclNode();
            }
            return this.makeAssignmentExprNode();
        }

        private Node makeVarDeclNode() {
            Node name = IR.name(this.namespace);
            name.addChildToFront(this.createNamespaceLiteral());
            Node decl = IR.var(name);
            decl.putBooleanProp(46, true);
            if (ProcessClosurePrimitives.this.compiler.getCodingConvention().isConstant(this.namespace)) {
                name.putBooleanProp(43, true);
            }
            if (this.candidateDefinition == null) {
                name.setJSDocInfo(this.createConstantJsDoc());
            }
            Preconditions.checkState(ProcessClosurePrimitives.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            return decl;
        }

        private Node createNamespaceLiteral() {
            Node objlit = IR.objectlit(new Node[0]);
            objlit.setJSType(ProcessClosurePrimitives.this.compiler.getTypeRegistry().createAnonymousObjectType());
            return objlit;
        }

        private Node makeAssignmentExprNode() {
            Node decl = IR.exprResult(IR.assign(NodeUtil.newQualifiedNameNode(ProcessClosurePrimitives.this.compiler.getCodingConvention(), this.namespace, this.firstNode, this.namespace), this.createNamespaceLiteral()));
            decl.putBooleanProp(46, true);
            if (this.candidateDefinition == null) {
                decl.getFirstChild().setJSDocInfo(this.createConstantJsDoc());
            }
            Preconditions.checkState(ProcessClosurePrimitives.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            return decl;
        }

        private JSDocInfo createConstantJsDoc() {
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordConstancy();
            return builder.build(null);
        }

        private void setSourceInfo(Node newNode) {
            Node provideStringNode = this.getProvideStringNode();
            int offset = this.getSourceInfoOffset(provideStringNode);
            Node sourceInfoNode = provideStringNode == null ? this.firstNode : provideStringNode;
            newNode.copyInformationFromForTree(sourceInfoNode);
            if (offset != 0) {
                newNode.setSourceEncodedPositionForTree(sourceInfoNode.getSourcePosition() + offset);
            }
        }

        private int getSourceInfoOffset(Node provideStringNode) {
            if (provideStringNode == null) {
                return 0;
            }
            int indexOfLastDot = this.namespace.lastIndexOf(46);
            return 2 + indexOfLastDot;
        }

        private Node getProvideStringNode() {
            return this.firstNode.getFirstChild() != null && NodeUtil.isExprCall(this.firstNode) ? this.firstNode.getFirstChild().getLastChild() : null;
        }
    }
}

