/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ArrayListMultimap;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.SimpleReference;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.SimpleSlot;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticScope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSymbolTable;

final class PreprocessorSymbolTable
implements StaticScope<JSType>,
StaticSymbolTable<SimpleSlot, Reference> {
    private final Map<String, SimpleSlot> symbols = Maps.newHashMap();
    private final Multimap<String, Reference> refs = ArrayListMultimap.create();
    private final Node root;

    PreprocessorSymbolTable(Node root) {
        this.root = root;
    }

    @Override
    public Node getRootNode() {
        return this.root;
    }

    @Override
    public JSType getTypeOfThis() {
        return null;
    }

    @Override
    public StaticScope<JSType> getParentScope() {
        return null;
    }

    public SimpleSlot getSlot(String name) {
        return this.symbols.get(name);
    }

    public SimpleSlot getOwnSlot(String name) {
        return this.getSlot(name);
    }

    @Override
    public Iterable<Reference> getReferences(SimpleSlot symbol) {
        return Collections.unmodifiableCollection(this.refs.get(symbol.getName()));
    }

    @Override
    public Iterable<SimpleSlot> getAllSymbols() {
        return Collections.unmodifiableCollection(this.symbols.values());
    }

    @Override
    public StaticScope<JSType> getScope(SimpleSlot slot) {
        return this;
    }

    void addReference(Node node) {
        String name = node.getQualifiedName();
        Preconditions.checkNotNull(name);
        if (!this.symbols.containsKey(name)) {
            this.symbols.put(name, new SimpleSlot(name, null, true));
        }
        this.refs.put(name, new Reference(this.symbols.get(name), node));
    }

    static final class Reference
    extends SimpleReference<SimpleSlot> {
        Reference(SimpleSlot symbol, Node node) {
            super(symbol, node);
        }
    }
}

