/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.ImmutableMap;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodeChangeHandler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodeConsumer;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodeGenerator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerOptions;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

public class PerformanceTracker {
    private final Node jsRoot;
    private final boolean trackSize;
    private final boolean trackGzippedSize;
    private final CodeChangeHandler.RecentChange codeChange = new CodeChangeHandler.RecentChange();
    private int curCodeSizeEstimate = -1;
    private int curZippedCodeSizeEstimate = -1;
    private Deque<String> currentRunningPass = new ArrayDeque<String>();
    private final Map<String, Stats> summary = Maps.newHashMap();
    private final List<Stats> log = Lists.newArrayList();

    PerformanceTracker(Node jsRoot, CompilerOptions.TracerMode mode) {
        this.jsRoot = jsRoot;
        switch (mode) {
            case TIMING_ONLY: {
                this.trackSize = false;
                this.trackGzippedSize = false;
                break;
            }
            case RAW_SIZE: {
                this.trackSize = true;
                this.trackGzippedSize = false;
                break;
            }
            case ALL: {
                this.trackSize = true;
                this.trackGzippedSize = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    CodeChangeHandler getCodeChangeHandler() {
        return this.codeChange;
    }

    void recordPassStart(String passName) {
        this.currentRunningPass.push(passName);
        this.codeChange.reset();
    }

    void recordPassStop(String passName, long result) {
        String currentPassName = this.currentRunningPass.pop();
        if (!passName.equals(currentPassName)) {
            throw new RuntimeException(passName + " is not running.");
        }
        CodeSizeEstimatePrinter printer = null;
        if (this.codeChange.hasCodeChanged() && (this.trackSize || this.trackGzippedSize)) {
            printer = this.estimateCodeSize(this.jsRoot);
        }
        Stats logStats = new Stats(currentPassName);
        this.log.add(logStats);
        this.updateStats(logStats, result, printer);
        Stats summaryStats = this.summary.get(passName);
        if (summaryStats == null) {
            summaryStats = new Stats(passName);
            this.summary.put(passName, summaryStats);
        }
        this.updateStats(summaryStats, result, printer);
        if (printer != null) {
            if (this.trackSize) {
                this.curCodeSizeEstimate = printer.calcSize();
            }
            if (this.trackGzippedSize) {
                this.curZippedCodeSizeEstimate = printer.calcZippedSize();
            }
        }
    }

    private void updateStats(Stats stats, long result, CodeSizeEstimatePrinter printer) {
        stats.runtime += result;
        ++stats.runs;
        if (this.codeChange.hasCodeChanged()) {
            ++stats.changes;
        }
        if (printer != null) {
            PerformanceTracker.recordSizeChange(this.curCodeSizeEstimate, printer.calcSize(), stats);
            PerformanceTracker.recordGzSizeChange(this.curZippedCodeSizeEstimate, printer.calcZippedSize(), stats);
        }
    }

    private static void recordSizeChange(int oldSize, int newSize, Stats record) {
        int delta;
        if (oldSize != -1 && (delta = oldSize - newSize) > 0) {
            record.diff += delta;
        }
        if (newSize != -1) {
            record.size = newSize;
        }
    }

    private static void recordGzSizeChange(int oldSize, int newSize, Stats record) {
        int delta;
        if (oldSize != -1 && (delta = oldSize - newSize) > 0) {
            record.gzDiff += delta;
        }
        if (newSize != -1) {
            record.gzSize = newSize;
        }
    }

    public ImmutableMap<String, Long> getRuntimeRecord() {
        ImmutableMap.Builder<String, Long> builder = new ImmutableMap.Builder<String, Long>();
        for (Map.Entry<String, Stats> entry : this.summary.entrySet()) {
            builder.put(entry.getKey(), entry.getValue().runtime);
        }
        return builder.build();
    }

    public ImmutableMap<String, Stats> getStats() {
        return ImmutableMap.copyOf(this.summary);
    }

    public ImmutableList<Stats> getLog() {
        return ImmutableList.copyOf(this.log);
    }

    public ImmutableMap<String, Integer> getCodeSizeRecord() {
        ImmutableMap.Builder<String, Integer> builder = new ImmutableMap.Builder<String, Integer>();
        for (Map.Entry<String, Stats> entry : this.summary.entrySet()) {
            builder.put(entry.getKey(), entry.getValue().diff);
        }
        return builder.build();
    }

    public ImmutableMap<String, Integer> getZippedCodeSizeRecord() {
        ImmutableMap.Builder<String, Integer> builder = new ImmutableMap.Builder<String, Integer>();
        for (Map.Entry<String, Stats> entry : this.summary.entrySet()) {
            builder.put(entry.getKey(), entry.getValue().gzDiff);
        }
        return builder.build();
    }

    private final CodeSizeEstimatePrinter estimateCodeSize(Node root) {
        CodeSizeEstimatePrinter cp = new CodeSizeEstimatePrinter(this.trackGzippedSize);
        CodeGenerator cg = new CodeGenerator(cp);
        cg.add(root);
        return cp;
    }

    private static final class CodeSizeEstimatePrinter
    extends CodeConsumer {
        private final boolean trackGzippedSize;
        private int size = 0;
        private char lastChar = '\u0000';
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private final GZIPOutputStream stream;

        private CodeSizeEstimatePrinter(boolean trackGzippedSize) {
            this.trackGzippedSize = trackGzippedSize;
            try {
                this.stream = new GZIPOutputStream(this.output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void append(String str) {
            int len = str.length();
            if (len > 0) {
                this.size += len;
                this.lastChar = str.charAt(len - 1);
                if (this.trackGzippedSize) {
                    try {
                        this.stream.write(str.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        char getLastChar() {
            return this.lastChar;
        }

        private int calcSize() {
            return this.size;
        }

        private int calcZippedSize() {
            if (this.trackGzippedSize) {
                try {
                    this.stream.finish();
                    this.stream.flush();
                    this.stream.close();
                    return this.output.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return -1;
        }
    }

    public static class Stats {
        public final String pass;
        public long runtime = 0L;
        public int runs = 0;
        public int changes = 0;
        public int diff = 0;
        public int gzDiff = 0;
        public int size = 0;
        public int gzSize = 0;

        public Stats(String pass) {
            this.pass = pass;
        }
    }
}

