/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractPeepholeOptimization;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodeChangeHandler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class PeepholeOptimizationsPass
implements CompilerPass {
    private AbstractCompiler compiler;
    private final AbstractPeepholeOptimization[] peepholeOptimizations;
    private StateStack traversalState = new StateStack();

    PeepholeOptimizationsPass(AbstractCompiler compiler, AbstractPeepholeOptimization ... optimizations) {
        this.compiler = compiler;
        this.peepholeOptimizations = optimizations;
    }

    public AbstractCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        PeepholeChangeHandler handler = new PeepholeChangeHandler();
        this.compiler.addChangeHandler(handler);
        this.beginTraversal();
        this.traverse(root);
        this.endTraversal();
        this.compiler.removeChangeHandler(handler);
    }

    private void traverse(Node node) {
        if (!this.shouldVisit(node)) {
            return;
        }
        int visits = 0;
        do {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                this.traverse(c);
            }
            this.visit(node);
            Preconditions.checkState(++visits < 10000, "too many interations");
        } while (this.shouldRetraverse(node));
        this.exitNode(node);
    }

    private boolean shouldRetraverse(Node node) {
        if (node.getParent() != null && node.isFunction() || node.isScript()) {
            ScopeState state = this.traversalState.peek();
            if (state.changed) {
                state.changed = false;
                state.traverseChildScopes = false;
                return true;
            }
        }
        return false;
    }

    private boolean shouldVisit(Node node) {
        if (node.isFunction() || node.isScript()) {
            ScopeState previous = this.traversalState.peek();
            if (!previous.traverseChildScopes) {
                return false;
            }
            this.traversalState.push();
        }
        return true;
    }

    private void exitNode(Node node) {
        if (node.isFunction() || node.isScript()) {
            this.traversalState.pop();
        }
    }

    public void visit(Node n) {
        Node currentVersionOfNode = n;
        boolean somethingChanged = false;
        do {
            somethingChanged = false;
            for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
                Node newVersionOfNode = optimization.optimizeSubtree(currentVersionOfNode);
                if (newVersionOfNode != currentVersionOfNode) {
                    somethingChanged = true;
                    currentVersionOfNode = newVersionOfNode;
                }
                if (currentVersionOfNode != null) continue;
                return;
            }
        } while (somethingChanged);
    }

    private void beginTraversal() {
        for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
            optimization.beginTraversal(this.compiler);
        }
    }

    private void endTraversal() {
        for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
            optimization.endTraversal(this.compiler);
        }
    }

    private class PeepholeChangeHandler
    implements CodeChangeHandler {
        private PeepholeChangeHandler() {
        }

        @Override
        public void reportChange() {
            ((PeepholeOptimizationsPass)PeepholeOptimizationsPass.this).traversalState.peek().changed = true;
        }
    }

    private static class StateStack {
        private ArrayList<ScopeState> states = Lists.newArrayList();
        private int currentDepth = 0;

        StateStack() {
            this.states.add(new ScopeState());
        }

        ScopeState peek() {
            return this.states.get(this.currentDepth);
        }

        void push() {
            ++this.currentDepth;
            if (this.states.size() <= this.currentDepth) {
                this.states.add(new ScopeState());
            } else {
                this.states.get(this.currentDepth).reset();
            }
        }

        void pop() {
            --this.currentDepth;
        }
    }

    private static class ScopeState {
        boolean changed;
        boolean traverseChildScopes;

        ScopeState() {
            this.reset();
        }

        void reset() {
            this.changed = false;
            this.traverseChildScopes = true;
        }
    }
}

