/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionSite;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionsRemover;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.OptimizeCalls;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SimpleDefinitionFinder;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.UseSite;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class OptimizeReturns
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private AbstractCompiler compiler;

    OptimizeReturns(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externs, root);
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, SimpleDefinitionFinder definitions) {
        ArrayList<Node> toOptimize = Lists.newArrayList();
        for (DefinitionSite defSite : definitions.getDefinitionSites()) {
            if (defSite.inExterns || this.callResultsMaybeUsed(definitions, defSite)) continue;
            toOptimize.add(defSite.definition.getRValue());
        }
        for (Node node : toOptimize) {
            this.rewriteReturns(definitions, node);
        }
    }

    private boolean callResultsMaybeUsed(SimpleDefinitionFinder defFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Node rValue = definition.getRValue();
        if (rValue == null || !rValue.isFunction()) {
            return true;
        }
        if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(rValue)) {
            return true;
        }
        if (!defFinder.canModifyDefinition(definition)) {
            return true;
        }
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Node useNodeParent = site.node.getParent();
            if (OptimizeReturns.isCall(site)) {
                Node callNode = useNodeParent;
                Preconditions.checkState(callNode.isCall());
                if (!NodeUtil.isExpressionResultUsed(callNode)) continue;
                return true;
            }
            if (useNodeParent.isVar()) continue;
            return true;
        }
        return false;
    }

    private void rewriteReturns(final SimpleDefinitionFinder defFinder, Node fnNode) {
        Preconditions.checkState(fnNode.isFunction());
        NodeUtil.visitPostOrder(fnNode.getLastChild(), new NodeUtil.Visitor(){

            @Override
            public void visit(Node node) {
                if (node.isReturn() && node.hasOneChild()) {
                    boolean keepValue = NodeUtil.mayHaveSideEffects(node.getFirstChild(), OptimizeReturns.this.compiler);
                    if (!keepValue) {
                        defFinder.removeReferences(node.getFirstChild());
                    }
                    Node result = node.removeFirstChild();
                    if (keepValue) {
                        node.getParent().addChildBefore(IR.exprResult(result).srcref(result), node);
                    }
                    OptimizeReturns.this.compiler.reportCodeChange();
                }
            }
        }, new NodeUtil.MatchShallowStatement());
    }

    private static boolean isCall(UseSite site) {
        Node node = site.node;
        Node parent = node.getParent();
        return parent.getFirstChild() == node && parent.isCall();
    }
}

