/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.Deque;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class OptimizeArgumentsArray
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final String paramPredix;
    private int uniqueId = 0;
    private final AbstractCompiler compiler;
    private final Deque<List<Node>> argumentsAccessStack = Lists.newLinkedList();
    private List<Node> currentArgumentsAccess = null;

    OptimizeArgumentsArray(AbstractCompiler compiler) {
        this(compiler, "JSCompiler_OptimizeArgumentsArray_p");
    }

    OptimizeArgumentsArray(AbstractCompiler compiler, String paramPrefix) {
        this.compiler = Preconditions.checkNotNull(compiler);
        this.paramPredix = Preconditions.checkNotNull(paramPrefix);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, Preconditions.checkNotNull(root), this);
    }

    @Override
    public void enterScope(NodeTraversal traversal) {
        Preconditions.checkNotNull(traversal);
        Node function = traversal.getScopeRoot();
        if (!function.isFunction()) {
            return;
        }
        if (this.currentArgumentsAccess != null) {
            this.argumentsAccessStack.push(this.currentArgumentsAccess);
        }
        this.currentArgumentsAccess = Lists.newLinkedList();
    }

    @Override
    public void exitScope(NodeTraversal traversal) {
        Preconditions.checkNotNull(traversal);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        if (this.tryReplaceArguments(traversal.getScope())) {
            traversal.getCompiler().reportCodeChange();
        }
        this.currentArgumentsAccess = !this.argumentsAccessStack.isEmpty() ? this.argumentsAccessStack.pop() : null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        Preconditions.checkNotNull(traversal);
        Preconditions.checkNotNull(node);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        if (node.isName() && "arguments".equals(node.getString())) {
            this.currentArgumentsAccess.add(node);
        }
    }

    private boolean tryReplaceArguments(Scope scope) {
        int value;
        Node parametersList = scope.getRootNode().getFirstChild().getNext();
        Preconditions.checkState(parametersList.isParamList());
        boolean changed = false;
        int numNamedParameter = parametersList.getChildCount();
        int highestIndex = numNamedParameter - 1;
        for (Node ref : this.currentArgumentsAccess) {
            Node getElem = ref.getParent();
            if (!getElem.isGetElem()) {
                return false;
            }
            Node index = ref.getNext();
            if (!index.isNumber()) {
                return false;
            }
            Node getElemParent = getElem.getParent();
            if (getElemParent.isCall() && getElemParent.getFirstChild() == getElem) {
                return false;
            }
            value = (int)index.getDouble();
            if (value <= highestIndex) continue;
            highestIndex = value;
        }
        int numExtraArgs = highestIndex - numNamedParameter + 1;
        String[] argNames = new String[numExtraArgs];
        for (int i = 0; i < numExtraArgs; ++i) {
            String name;
            argNames[i] = name = this.getNewName();
            parametersList.addChildrenToBack(IR.name(name));
            changed = true;
        }
        for (Node ref : this.currentArgumentsAccess) {
            Node index = ref.getNext();
            if (!index.isNumber()) continue;
            value = (int)index.getDouble();
            if (value >= numNamedParameter) {
                ref.getParent().getParent().replaceChild(ref.getParent(), IR.name(argNames[value - numNamedParameter]));
            } else {
                Node name = parametersList.getFirstChild();
                for (int i = 0; i < value; ++i) {
                    name = name.getNext();
                }
                ref.getParent().getParent().replaceChild(ref.getParent(), IR.name(name.getString()));
            }
            changed = true;
        }
        return changed;
    }

    private String getNewName() {
        return this.paramPredix + this.uniqueId++;
    }
}

