/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerInput;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SyntacticScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class Normalize
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean assertOnChange;
    public static final DiagnosticType CATCH_BLOCK_VAR_ERROR = DiagnosticType.error("JSC_CATCH_BLOCK_VAR_ERROR", "The use of scope variable {0} is not allowed within a catch block with a catch exception of the same name.");

    Normalize(AbstractCompiler compiler, boolean assertOnChange) {
        this.compiler = compiler;
        this.assertOnChange = assertOnChange;
    }

    static Node parseAndNormalizeSyntheticCode(AbstractCompiler compiler, String code, String prefix) {
        Node js = compiler.parseSyntheticCode(code);
        NodeTraversal.traverse(compiler, js, new NormalizeStatements(compiler, false));
        NodeTraversal.traverse(compiler, js, new MakeDeclaredNamesUnique(new MakeDeclaredNamesUnique.BoilerplateRenamer(compiler.getUniqueNameIdSupplier(), prefix)));
        return js;
    }

    private void reportCodeChange(String changeDescription) {
        if (this.assertOnChange) {
            throw new IllegalStateException("Normalize constraints violated:\n" + changeDescription);
        }
        this.compiler.reportCodeChange();
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, new NormalizeStatements(this.compiler, this.assertOnChange)).traverseRoots(externs, root);
        MakeDeclaredNamesUnique renamer = new MakeDeclaredNamesUnique();
        NodeTraversal t = new NodeTraversal(this.compiler, renamer);
        t.traverseRoots(externs, root);
        this.removeDuplicateDeclarations(externs, root);
        new PropagateConstantAnnotationsOverVars(this.compiler, this.assertOnChange).process(externs, root);
        if (!this.compiler.getLifeCycleStage().isNormalized()) {
            this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED);
        }
    }

    private void removeDuplicateDeclarations(Node externs, Node root) {
        ScopeTicklingCallback tickler = new ScopeTicklingCallback();
        SyntacticScopeCreator scopeCreator = new SyntacticScopeCreator(this.compiler, new DuplicateDeclarationHandler());
        NodeTraversal t = new NodeTraversal(this.compiler, tickler, scopeCreator);
        t.traverseRoots(externs, root);
    }

    private final class ScopeTicklingCallback
    implements NodeTraversal.ScopedCallback {
        private ScopeTicklingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getScope();
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private final class DuplicateDeclarationHandler
    implements SyntacticScopeCreator.RedeclarationHandler {
        private Set<Scope.Var> hasOkDuplicateDeclaration = Sets.newHashSet();

        private DuplicateDeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Preconditions.checkState(n.isName());
            Node parent = n.getParent();
            Scope.Var v = s.getVar(name);
            if (v != null && s.isGlobal() && v.isExtern() && !input.isExtern() && this.hasOkDuplicateDeclaration.add(v)) {
                return;
            }
            if (v != null && v.getParentNode().isCatch()) {
                name = MakeDeclaredNamesUnique.ContextualRenameInverter.getOrginalName(name);
                Normalize.this.compiler.report(JSError.make(input.getName(), n, CATCH_BLOCK_VAR_ERROR, name));
            } else if (v != null && parent.isFunction()) {
                if (v.getParentNode().isVar()) {
                    s.undeclare(v);
                    s.declare(name, n, n.getJSType(), v.input);
                    this.replaceVarWithAssignment(v.getNameNode(), v.getParentNode(), v.getParentNode().getParent());
                }
            } else if (parent.isVar()) {
                Preconditions.checkState(parent.hasOneChild());
                this.replaceVarWithAssignment(n, parent, parent.getParent());
            }
        }

        private void replaceVarWithAssignment(Node n, Node parent, Node gramps) {
            if (n.hasChildren()) {
                parent.removeChild(n);
                Node value = n.getFirstChild();
                n.removeChild(value);
                Node replacement = IR.assign(n, value);
                replacement.copyInformationFrom(parent);
                gramps.replaceChild(parent, NodeUtil.newExpr(replacement));
            } else if (NodeUtil.isStatementBlock(gramps)) {
                gramps.removeChild(parent);
            } else if (gramps.isFor()) {
                parent.removeChild(n);
                gramps.replaceChild(parent, n);
            } else {
                Preconditions.checkState(gramps.isLabel());
                throw new IllegalStateException("Unexpected LABEL");
            }
            Normalize.this.reportCodeChange("Duplicate VAR declaration");
        }
    }

    static class NormalizeStatements
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final boolean assertOnChange;

        NormalizeStatements(AbstractCompiler compiler, boolean assertOnChange) {
            this.compiler = compiler;
            this.assertOnChange = assertOnChange;
        }

        private void reportCodeChange(String changeDescription) {
            if (this.assertOnChange) {
                throw new IllegalStateException("Normalize constraints violated:\n" + changeDescription);
            }
            this.compiler.reportCodeChange();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            this.doStatementNormalizations(t, n, parent);
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 113: {
                    Node expr = n.getFirstChild();
                    n.setType(115);
                    Node empty = IR.empty();
                    empty.copyInformationFrom(n);
                    n.addChildBefore(empty, expr);
                    n.addChildAfter(empty.cloneNode(), expr);
                    this.reportCodeChange("WHILE node");
                    break;
                }
                case 105: {
                    this.normalizeFunctionDeclaration(n);
                    break;
                }
                case 38: 
                case 40: 
                case 147: 
                case 148: {
                    if (this.compiler.getLifeCycleStage().isNormalizedObfuscated()) break;
                    this.annotateConstantsByConvention(n, parent);
                }
            }
        }

        private void annotateConstantsByConvention(Node n, Node parent) {
            boolean isMarkedConstant;
            boolean isProperty;
            Preconditions.checkState(n.isName() || n.isString() || n.isGetterDef() || n.isSetterDef());
            boolean isObjLitKey = NodeUtil.isObjectLitKey(n, parent);
            boolean bl = isProperty = isObjLitKey || parent.isGetProp() && parent.getLastChild() == n;
            if ((n.isName() || isProperty) && !(isMarkedConstant = n.getBooleanProp(43)) && NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), n, parent)) {
                if (this.assertOnChange) {
                    String name = n.getString();
                    throw new IllegalStateException("Unexpected const change.\n  name: " + name + "\n" + "  parent:" + n.getParent().toStringTree());
                }
                n.putBooleanProp(43, true);
            }
        }

        private void normalizeFunctionDeclaration(Node n) {
            Preconditions.checkState(n.isFunction());
            if (!NodeUtil.isFunctionExpression(n) && !NodeUtil.isHoistedFunctionDeclaration(n)) {
                this.rewriteFunctionDeclaration(n);
            }
        }

        private void rewriteFunctionDeclaration(Node n) {
            Node oldNameNode = n.getFirstChild();
            Node fnNameNode = oldNameNode.cloneNode();
            Node var = IR.var(fnNameNode).srcref(n);
            oldNameNode.setString("");
            Node parent = n.getParent();
            parent.replaceChild(n, var);
            fnNameNode.addChildToFront(n);
            this.reportCodeChange("Function declaration");
        }

        private void doStatementNormalizations(NodeTraversal t, Node n, Node parent) {
            if (n.isLabel()) {
                this.normalizeLabels(n);
            }
            if (NodeUtil.isStatementBlock(n) || n.isLabel()) {
                this.extractForInitializer(n, null, null);
            }
            if (NodeUtil.isStatementBlock(n)) {
                this.splitVarDeclarations(n);
            }
            if (n.isFunction()) {
                this.moveNamedFunctions(n.getLastChild());
            }
        }

        private void normalizeLabels(Node n) {
            Preconditions.checkArgument(n.isLabel());
            Node last = n.getLastChild();
            switch (last.getType()) {
                case 113: 
                case 114: 
                case 115: 
                case 125: 
                case 126: {
                    return;
                }
            }
            Node block = IR.block();
            block.copyInformationFrom(last);
            n.replaceChild(last, block);
            block.addChildToFront(last);
            this.reportCodeChange("LABEL normalization");
        }

        private void extractForInitializer(Node n, Node before, Node beforeParent) {
            Node c = n.getFirstChild();
            while (c != null) {
                Node next = c.getNext();
                Node insertBefore = before == null ? c : before;
                Node insertBeforeParent = before == null ? n : beforeParent;
                switch (c.getType()) {
                    case 126: {
                        this.extractForInitializer(c, insertBefore, insertBeforeParent);
                        break;
                    }
                    case 115: {
                        if (NodeUtil.isForIn(c)) {
                            Node first = c.getFirstChild();
                            if (!first.isVar()) break;
                            Node newStatement = first;
                            Node name = newStatement.getFirstChild().cloneNode();
                            first.getParent().replaceChild(first, name);
                            insertBeforeParent.addChildBefore(newStatement, insertBefore);
                            this.reportCodeChange("FOR-IN var declaration");
                            break;
                        }
                        if (c.getFirstChild().isEmpty()) break;
                        Node init = c.getFirstChild();
                        Node empty = IR.empty();
                        empty.copyInformationFrom(c);
                        c.replaceChild(init, empty);
                        Node newStatement = init.isVar() ? init : NodeUtil.newExpr(init);
                        insertBeforeParent.addChildBefore(newStatement, insertBefore);
                        this.reportCodeChange("FOR initializer");
                    }
                }
                c = next;
            }
        }

        private void splitVarDeclarations(Node n) {
            Node c = n.getFirstChild();
            while (c != null) {
                Node next = c.getNext();
                if (c.isVar()) {
                    if (this.assertOnChange && !c.hasChildren()) {
                        throw new IllegalStateException("Empty VAR node.");
                    }
                    while (c.getFirstChild() != c.getLastChild()) {
                        Node name = c.getFirstChild();
                        c.removeChild(name);
                        Node newVar = IR.var(name).srcref(n);
                        n.addChildBefore(newVar, c);
                        this.reportCodeChange("VAR with multiple children");
                    }
                }
                c = next;
            }
        }

        private void moveNamedFunctions(Node functionBody) {
            Node current;
            Preconditions.checkState(functionBody.getParent().isFunction());
            Node previous = null;
            for (current = functionBody.getFirstChild(); current != null && NodeUtil.isFunctionDeclaration(current); current = current.getNext()) {
                previous = current;
            }
            Node insertAfter = previous;
            while (current != null) {
                Node next = current.getNext();
                if (NodeUtil.isFunctionDeclaration(current)) {
                    Preconditions.checkNotNull(previous);
                    functionBody.removeChildAfter(previous);
                    insertAfter = this.addToFront(functionBody, current, insertAfter);
                    this.reportCodeChange("Move function declaration not at top of function");
                } else {
                    previous = current;
                }
                current = next;
            }
        }

        private Node addToFront(Node parent, Node newChild, Node after) {
            if (after == null) {
                parent.addChildToFront(newChild);
            } else {
                parent.addChildAfter(newChild, after);
            }
            return newChild;
        }
    }

    static class VerifyConstants
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean checkUserDeclarations;
        private Map<String, Boolean> constantMap = Maps.newHashMap();

        VerifyConstants(AbstractCompiler compiler, boolean checkUserDeclarations) {
            this.compiler = compiler;
            this.checkUserDeclarations = checkUserDeclarations;
        }

        @Override
        public void process(Node externs, Node root) {
            Node externsAndJs = root.getParent();
            Preconditions.checkState(externsAndJs != null);
            Preconditions.checkState(externsAndJs.hasChild(externs));
            NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList(externs, root), this);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                Boolean value;
                String name = n.getString();
                if (n.getString().isEmpty()) {
                    return;
                }
                boolean isConst = n.getBooleanProp(43);
                if (this.checkUserDeclarations) {
                    boolean expectedConst = false;
                    CodingConvention convention = this.compiler.getCodingConvention();
                    if (NodeUtil.isConstantName(n) || NodeUtil.isConstantByConvention(convention, n, parent)) {
                        expectedConst = true;
                    } else {
                        expectedConst = false;
                        JSDocInfo info = null;
                        Scope.Var var = t.getScope().getVar(n.getString());
                        if (var != null) {
                            info = var.getJSDocInfo();
                        }
                        expectedConst = info != null && info.isConstant();
                    }
                    if (expectedConst) {
                        Preconditions.checkState(expectedConst == isConst, "The name %s is not annotated as constant.", name);
                    } else {
                        Preconditions.checkState(expectedConst == isConst, "The name %s should not be annotated as constant.", name);
                    }
                }
                if ((value = this.constantMap.get(name)) == null) {
                    this.constantMap.put(name, isConst);
                } else {
                    Preconditions.checkState(value == isConst, "The name %s is not consistently annotated as constant.", name);
                }
            }
        }
    }

    static class PropagateConstantAnnotationsOverVars
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean assertOnChange;

        PropagateConstantAnnotationsOverVars(AbstractCompiler compiler, boolean forbidChanges) {
            this.compiler = compiler;
            this.assertOnChange = forbidChanges;
        }

        @Override
        public void process(Node externs, Node root) {
            new NodeTraversal(this.compiler, this).traverseRoots(externs, root);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                if (n.getString().isEmpty()) {
                    return;
                }
                JSDocInfo info = null;
                Scope.Var var = t.getScope().getVar(n.getString());
                if (var != null) {
                    info = var.getJSDocInfo();
                }
                boolean shouldBeConstant = info != null && info.isConstant() || NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), n, parent);
                boolean isMarkedConstant = n.getBooleanProp(43);
                if (shouldBeConstant && !isMarkedConstant) {
                    if (this.assertOnChange) {
                        String name = n.getString();
                        throw new IllegalStateException("Unexpected const change.\n  name: " + name + "\n" + "  parent:" + n.getParent().toStringTree());
                    }
                    n.putBooleanProp(43, true);
                }
            }
        }
    }
}

