/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionsRemover;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NameReferenceGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;

final class NameReferenceGraphReport {
    private NameReferenceGraph graph = null;

    NameReferenceGraphReport(NameReferenceGraph g) {
        this.graph = g;
    }

    public String getHtmlReport() {
        StringBuilder builder = new StringBuilder();
        ArrayList nodes = Lists.newArrayList(this.graph.getDirectedGraphNodes());
        this.generateHtmlReportHeader(builder);
        builder.append("<h1>Name Reference Graph Dump</h1>\n");
        builder.append("OVERALL STATS\n");
        builder.append("<ul>\n");
        builder.append("<li>Total names: " + nodes.size());
        builder.append("</ul>\n");
        builder.append("ALL NAMES\n");
        builder.append("<UL>\n");
        Collections.sort(nodes, new DiGraphNodeComparator());
        for (DiGraph.DiGraphNode diGraphNode : nodes) {
            this.generateDeclarationReport(builder, diGraphNode);
            List outEdges = this.graph.getOutEdges(diGraphNode.getValue());
            List inEdges = this.graph.getInEdges(diGraphNode.getValue());
            if (outEdges.isEmpty() && inEdges.isEmpty()) continue;
            builder.append("<ul>");
            if (outEdges.size() > 0) {
                builder.append("<li>REFERS TO:<br>\n");
                builder.append("<ul>");
                for (DiGraph.DiGraphEdge<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphEdge : outEdges) {
                    this.generateEdgeReport(builder, (NameReferenceGraph.Name)diGraphEdge.getDestination().getValue(), diGraphEdge);
                }
                builder.append("</ul>\n");
            }
            if (inEdges.size() > 0) {
                builder.append("<li>REFERENCED BY:<br>\n");
                builder.append("<ul>");
                for (DiGraph.DiGraphEdge<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphEdge : inEdges) {
                    this.generateEdgeReport(builder, (NameReferenceGraph.Name)diGraphEdge.getSource().getValue(), diGraphEdge);
                }
                builder.append("</ul>");
            }
            builder.append("</ul>\n");
        }
        builder.append("</ul>\n");
        this.generateHtmlReportFooter(builder);
        return builder.toString();
    }

    private String getSourceFile(Node node) {
        String filename = node.getSourceFileName();
        if (filename == null) {
            return "";
        }
        return filename;
    }

    private void generateDeclarationReport(StringBuilder builder, DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference> declarationNode) {
        String declName = ((NameReferenceGraph.Name)declarationNode.getValue()).getQualifiedName();
        JSType declType = ((NameReferenceGraph.Name)declarationNode.getValue()).getType();
        builder.append("<LI> ");
        builder.append("<A NAME=\"" + declName + "\">");
        builder.append(declName);
        builder.append("\n");
        this.generateType(builder, declType);
        List<DefinitionsRemover.Definition> defs = ((NameReferenceGraph.Name)declarationNode.getValue()).getDeclarations();
        if (defs.size() == 0) {
            builder.append("<br>No definitions found<br>");
        } else {
            builder.append("<ul>");
            for (DefinitionsRemover.Definition def : defs) {
                Node fnDef = def.getRValue();
                String sourceFileName = this.getSourceFile(fnDef);
                builder.append("<li> Defined: ");
                this.generateSourceReferenceLink(builder, sourceFileName, fnDef.getLineno(), fnDef.getCharno());
            }
            builder.append("</ul>");
        }
    }

    private void generateHtmlReportHeader(StringBuilder builder) {
        builder.append("<!DOCTYPE html>\n<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" ><title>Name Reference Graph Dump</title><style type=\"text/css\">body, td, ");
        builder.append("p {font-family: Arial; font-size: 83%} ");
        builder.append("ul {margin-top:2px; margin-left:0px; padding-left:1em;}");
        builder.append("li {margin-top:3px; margin-left:24px;padding-left:0px;padding-bottom: 4px}");
        builder.append("</style></head><body>\n");
    }

    private void generateHtmlReportFooter(StringBuilder builder) {
        builder.append("</body></html>");
    }

    private void generateEdgeReport(StringBuilder builder, NameReferenceGraph.Name referencedDecl, DiGraph.DiGraphEdge<NameReferenceGraph.Name, NameReferenceGraph.Reference> edge) {
        String srcDeclName = referencedDecl.getQualifiedName();
        builder.append("<li><A HREF=\"#" + srcDeclName + "\">");
        builder.append(srcDeclName);
        builder.append("</a> ");
        Node def = ((NameReferenceGraph.Reference)edge.getValue()).getSite();
        int lineNumber = def.getLineno();
        int columnNumber = def.getCharno();
        String sourceFile = this.getSourceFile(def);
        this.generateSourceReferenceLink(builder, sourceFile, lineNumber, columnNumber);
        JSType defType = ((NameReferenceGraph.Reference)edge.getValue()).getSite().getJSType();
        this.generateType(builder, defType);
    }

    private void generateSourceReferenceLink(StringBuilder builder, String sourceFile, int lineNumber, int columnNumber) {
        assert (sourceFile != null);
        builder.append("(");
        builder.append(sourceFile + ":" + lineNumber + "," + columnNumber);
        builder.append(")");
    }

    private void generateType(StringBuilder builder, JSType defType) {
        if (defType == null) {
            builder.append(" (type: null) ");
        } else if (defType.isUnknownType()) {
            builder.append(" (type: unknown) ");
        } else {
            builder.append(" (type: " + defType.toString() + ") ");
        }
    }

    class DiGraphNodeComparator
    implements Comparator<DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference>> {
        DiGraphNodeComparator() {
        }

        @Override
        public int compare(DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference> node1, DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference> node2) {
            Preconditions.checkNotNull(node1.getValue());
            Preconditions.checkNotNull(node2.getValue());
            if (((NameReferenceGraph.Name)node1.getValue()).getQualifiedName() == null && ((NameReferenceGraph.Name)node2.getValue()).getQualifiedName() == null) {
                return 0;
            }
            if (((NameReferenceGraph.Name)node1.getValue()).getQualifiedName() == null) {
                return -1;
            }
            if (((NameReferenceGraph.Name)node2.getValue()).getQualifiedName() == null) {
                return 1;
            }
            return ((NameReferenceGraph.Name)node1.getValue()).getQualifiedName().compareTo(((NameReferenceGraph.Name)node2.getValue()).getQualifiedName());
        }
    }
}

