/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.HashMultimap;
import closurecompiler.internal.com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.MemoizedScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NameReferenceGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.TypedScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.GraphNode;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;

class NameReferenceGraphConstruction
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final NameReferenceGraph graph;
    private final Multimap<String, NameUse> unknownNameUse = HashMultimap.create();
    private final ArrayList<NameReferenceGraph.Name> currentFunctionStack = new ArrayList();

    NameReferenceGraphConstruction(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.graph = new NameReferenceGraph(compiler);
    }

    NameReferenceGraph getNameReferenceGraph() {
        return this.graph;
    }

    @Override
    public void process(Node externs, Node root) {
        ScopeCreator scopeCreator = this.compiler.getTypedScopeCreator();
        if (scopeCreator == null) {
            scopeCreator = new MemoizedScopeCreator(new TypedScopeCreator(this.compiler));
        }
        NodeTraversal externsTraversal = new NodeTraversal(this.compiler, new Traversal(true), scopeCreator);
        NodeTraversal codeTraversal = new NodeTraversal(this.compiler, new Traversal(false), scopeCreator);
        Scope topScope = this.compiler.getTopScope();
        if (topScope != null) {
            externsTraversal.traverseWithScope(externs, topScope);
            codeTraversal.traverseWithScope(root, topScope);
        } else {
            externsTraversal.traverse(externs);
            codeTraversal.traverse(root);
        }
        this.connectUnknowns();
    }

    private void connectUnknowns() {
        for (GraphNode node : this.graph.getNodes()) {
            Collection<NameUse> uses;
            NameReferenceGraph.Name name = (NameReferenceGraph.Name)node.getValue();
            String propName = name.getPropertyName();
            if (propName == null || (uses = this.unknownNameUse.get(propName)) == null) continue;
            for (NameUse use : uses) {
                this.graph.connect(use.name, use.reference, name);
            }
        }
    }

    private JSType getType(Node n) {
        JSType type = n.getJSType();
        if (type == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return type.restrictByNotNullOrUndefined();
    }

    private void pushContainingFunction(NameReferenceGraph.Name functionNode) {
        this.currentFunctionStack.add(functionNode);
    }

    private void popContainingFunction() {
        this.currentFunctionStack.remove(this.currentFunctionStack.size() - 1);
    }

    private NameReferenceGraph.Name getNamedContainingFunction() {
        NameReferenceGraph.Name containingFn = null;
        for (int pos = this.currentFunctionStack.size() - 1; pos >= 0; --pos) {
            NameReferenceGraph.Name cf = this.currentFunctionStack.get(pos);
            if (cf == this.graph.UNKNOWN) continue;
            containingFn = cf;
            break;
        }
        Preconditions.checkNotNull(containingFn);
        return containingFn;
    }

    private static class NameUse {
        private final NameReferenceGraph.Name name;
        private final NameReferenceGraph.Reference reference;

        private NameUse(NameReferenceGraph.Name name, NameReferenceGraph.Reference reference) {
            this.name = name;
            this.reference = reference;
        }
    }

    private class Traversal
    implements NodeTraversal.ScopedCallback {
        final boolean isExtern;

        private Traversal(boolean isExtern) {
            this.isExtern = isExtern;
            NameReferenceGraphConstruction.this.pushContainingFunction(((NameReferenceGraphConstruction)NameReferenceGraphConstruction.this).graph.MAIN);
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node root = t.getScopeRoot();
            Node parent = root.getParent();
            if (!t.inGlobalScope()) {
                String name = NodeUtil.getFunctionName(root);
                if (name == null) {
                    NameReferenceGraphConstruction.this.pushContainingFunction(((NameReferenceGraphConstruction)NameReferenceGraphConstruction.this).graph.UNKNOWN);
                    return;
                }
                JSType type = NameReferenceGraphConstruction.this.getType(root);
                Node gParent = parent.getParent();
                Node ggParent = gParent.getParent();
                if (parent.isAssign() && NodeUtil.isPrototypeProperty(parent.getFirstChild())) {
                    NameReferenceGraphConstruction.this.pushContainingFunction(this.recordPrototypePropDefinition(t, parent.getFirstChild(), type, parent, gParent, ggParent));
                } else {
                    NameReferenceGraphConstruction.this.pushContainingFunction(this.recordStaticNameDefinition(t, name, type, root, parent, gParent, root.getLastChild()));
                }
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (!t.inGlobalScope()) {
                NameReferenceGraphConstruction.this.popContainingFunction();
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: 
                case 38: {
                    if (parent.isGetProp()) {
                        return;
                    }
                    if (parent.isFunction()) {
                        return;
                    }
                    if (parent.isAssign()) {
                        return;
                    }
                    if (this.isLocalNameReference(t, n)) {
                        return;
                    }
                    if (this.isPrototypeNameReference(n)) {
                        this.recordPrototypePropUse(t, n, parent);
                        break;
                    }
                    if (this.isStaticNameReference(n, t.getScope())) {
                        this.recordStaticNameUse(t, n, parent);
                        break;
                    }
                    this.recordUnknownUse(t, n, parent);
                    break;
                }
                case 86: {
                    Node lhs = n.getFirstChild();
                    Node rhs = n.getLastChild();
                    if (rhs.isFunction()) {
                        return;
                    }
                    if ((lhs.isName() || lhs.isGetProp() || rhs.isGetProp()) && NodeUtil.isPrototypeProperty(lhs)) {
                        NameReferenceGraph.Name name = this.recordPrototypePropDefinition(t, lhs, NameReferenceGraphConstruction.this.getType(rhs), n, parent, parent.getParent());
                        name.setAliased(true);
                    }
                    this.maybeAliasNamesOnAssign(lhs, rhs);
                    break;
                }
                case 118: {
                    Node varName = n.getFirstChild();
                    Node assignedValue = varName.getFirstChild();
                    if (assignedValue == null) {
                        return;
                    }
                    this.maybeAliasNamesOnAssign(varName, assignedValue);
                    break;
                }
                case 37: {
                    Node param = n.getFirstChild();
                    while ((param = param.getNext()) != null) {
                        if (!param.isName() && !param.isGetProp()) continue;
                        this.safeAlias(param);
                    }
                    this.maybeRecordExport(n);
                }
            }
        }

        private boolean containsName(Node n) {
            return NodeUtil.containsType(n, 38) || NodeUtil.containsType(n, 35) || NodeUtil.containsType(n, 33);
        }

        private void safeAlias(Node n) {
            String name;
            if ((n.isName() || n.isGetProp()) && (name = n.getQualifiedName()) != null) {
                this.defineAndAlias(name);
                return;
            }
            if (n.isGetProp()) {
                this.defineAndAlias(n.getLastChild().getString());
            } else if (n.isAssign()) {
                this.safeAlias(n.getFirstChild());
            } else if (n.hasChildren()) {
                Node cur = n.getFirstChild();
                do {
                    this.safeAlias(cur);
                } while ((cur = cur.getNext()) != null);
            }
        }

        private void maybeAliasNamesOnAssign(Node lhs, Node rhs) {
            if ((lhs.isName() || lhs.isGetProp()) && this.containsName(rhs) && !rhs.isFunction() && !rhs.isNew()) {
                this.safeAlias(lhs);
                this.safeAlias(rhs);
            }
        }

        private void defineAndAlias(String name) {
            NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(name, this.isExtern).setAliased(true);
        }

        private void maybeRecordExport(Node call) {
            Preconditions.checkArgument(call.isCall());
            Node getProp = call.getFirstChild();
            if (!getProp.isGetProp()) {
                return;
            }
            String propQName = getProp.getQualifiedName();
            if (propQName == null) {
                return;
            }
            if (propQName.endsWith(".call") || propQName.endsWith(".apply")) {
                NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(getProp.getFirstChild().getQualifiedName(), this.isExtern).markExposedToCallOrApply();
            }
            if (!"goog.exportSymbol".equals(propQName)) {
                return;
            }
            Node symbol = getProp.getNext();
            if (!symbol.isString()) {
                return;
            }
            Node obj = symbol.getNext();
            String qName = obj.getQualifiedName();
            if (qName == null || obj.getNext() != null) {
                return;
            }
            NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(qName, false).markExported();
        }

        private boolean isLocalNameReference(NodeTraversal t, Node n) {
            if (n.isName()) {
                Scope.Var v = t.getScope().getVar(n.getString());
                return v != null && v.isLocal();
            }
            return false;
        }

        private boolean isStaticNameReference(Node n, Scope scope) {
            Preconditions.checkArgument(n.isName() || n.isGetProp());
            if (n.isName()) {
                return true;
            }
            String qName = n.getQualifiedName();
            if (qName == null) {
                return false;
            }
            return scope.isDeclared(qName, true);
        }

        private boolean isPrototypeNameReference(Node n) {
            if (!n.isGetProp()) {
                return false;
            }
            JSType type = NameReferenceGraphConstruction.this.getType(n.getFirstChild());
            if (type.isUnknownType() || type.isUnionType()) {
                return false;
            }
            return type.isInstanceType() || type.autoboxesTo() != null;
        }

        private NameReferenceGraph.Name recordStaticNameDefinition(NodeTraversal t, String name, JSType type, Node n, Node parent, Node gParent, Node rValue) {
            if (NameReferenceGraphConstruction.this.getNamedContainingFunction() != ((NameReferenceGraphConstruction)NameReferenceGraphConstruction.this).graph.MAIN) {
                // empty if block
            }
            if (type.isConstructor()) {
                return this.recordClassConstructorOrInterface(name, type.toMaybeFunctionType(), n, parent, parent.getParent(), rValue);
            }
            NameReferenceGraph.Name symbol = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(name, this.isExtern);
            symbol.setType(type);
            if (n.isAssign()) {
                symbol.addAssignmentDeclaration(n);
            } else {
                symbol.addFunctionDeclaration(n);
            }
            return symbol;
        }

        private NameReferenceGraph.Name recordPrototypePropDefinition(NodeTraversal t, Node qName, JSType type, Node assign, Node parent, Node gParent) {
            JSType constructor = NameReferenceGraphConstruction.this.getType(NodeUtil.getPrototypeClassName(qName));
            FunctionType classType = null;
            String className = null;
            if (constructor != null && constructor.isConstructor()) {
                classType = constructor.toMaybeFunctionType();
                className = classType.getReferenceName();
            } else {
                classType = NameReferenceGraphConstruction.this.compiler.getTypeRegistry().getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
                className = NodeUtil.getPrototypeClassName(qName).getQualifiedName();
            }
            this.recordClassConstructorOrInterface(className, classType, null, null, null, null);
            String qNameStr = className + ".prototype." + NodeUtil.getPrototypePropertyName(qName);
            NameReferenceGraph.Name prototypeProp = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(qNameStr, this.isExtern);
            Preconditions.checkNotNull(prototypeProp, "%s should be in the name graph as a node.", qNameStr);
            if (assign != null) {
                prototypeProp.addAssignmentDeclaration(assign);
            }
            prototypeProp.setType(type);
            return prototypeProp;
        }

        private NameReferenceGraph.Reference recordStaticNameUse(NodeTraversal t, Node n, Node parent) {
            if (this.isExtern) {
                return null;
            }
            NameReferenceGraph.Reference reference = new NameReferenceGraph.Reference(n, parent);
            NameReferenceGraph.Name name = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(n.getQualifiedName(), this.isExtern);
            name.setType(NameReferenceGraphConstruction.this.getType(n));
            NameReferenceGraphConstruction.this.graph.connect(NameReferenceGraphConstruction.this.getNamedContainingFunction(), reference, name);
            return reference;
        }

        private void recordPrototypePropUse(NodeTraversal t, Node n, Node parent) {
            Preconditions.checkArgument(n.isGetProp());
            Node instance = n.getFirstChild();
            JSType instanceType = NameReferenceGraphConstruction.this.getType(instance);
            JSType boxedType = instanceType.autoboxesTo();
            instanceType = boxedType != null ? boxedType : instanceType;
            ObjectType objType = instanceType.toObjectType();
            Preconditions.checkState(objType != null);
            if (!this.isExtern) {
                NameReferenceGraph.Reference ref = new NameReferenceGraph.Reference(n, parent);
                FunctionType constructor = objType.getConstructor();
                if (constructor != null) {
                    String propName = n.getLastChild().getString();
                    if (!constructor.getPrototype().hasOwnProperty(propName)) {
                        this.recordSuperClassPrototypePropUse(constructor, propName, ref);
                    }
                    this.recordSubclassPrototypePropUse(constructor, propName, ref);
                } else {
                    this.recordUnknownUse(t, n, parent);
                }
            }
        }

        private void recordSuperClassPrototypePropUse(FunctionType classType, String prop, NameReferenceGraph.Reference ref) {
            for (FunctionType superClass = classType.getSuperClassConstructor(); superClass != null; superClass = superClass.getSuperClassConstructor()) {
                if (!superClass.getPrototype().hasOwnProperty(prop)) continue;
                NameReferenceGraphConstruction.this.graph.connect(NameReferenceGraphConstruction.this.getNamedContainingFunction(), ref, NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(superClass.getReferenceName() + ".prototype." + prop, false));
                return;
            }
        }

        private void recordSubclassPrototypePropUse(FunctionType classType, String prop, NameReferenceGraph.Reference ref) {
            if (classType.getPrototype().hasOwnProperty(prop)) {
                NameReferenceGraphConstruction.this.graph.connect(NameReferenceGraphConstruction.this.getNamedContainingFunction(), ref, NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(classType.getReferenceName() + ".prototype." + prop, false));
            }
            if (classType.getSubTypes() != null) {
                for (FunctionType subclass : classType.getSubTypes()) {
                    this.recordSubclassPrototypePropUse(subclass, prop, ref);
                }
            }
        }

        private void recordUnknownUse(NodeTraversal t, Node n, Node parent) {
            if (this.isExtern) {
                return;
            }
            Preconditions.checkArgument(n.isGetProp());
            NameReferenceGraph.Reference ref = new NameReferenceGraph.Reference(n, parent);
            ref.setUnknown(true);
            NameReferenceGraphConstruction.this.unknownNameUse.put(n.getLastChild().getString(), new NameUse(NameReferenceGraphConstruction.this.getNamedContainingFunction(), ref));
        }

        private NameReferenceGraph.Name recordClassConstructorOrInterface(String name, FunctionType type, Node n, Node parent, Node gParent, Node rhs) {
            Preconditions.checkArgument(type.isConstructor() || type.isInterface());
            NameReferenceGraph.Name symbol = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(name, this.isExtern);
            if (rhs != null) {
                symbol.setType(NameReferenceGraphConstruction.this.getType(rhs));
                if (n.isAssign()) {
                    symbol.addAssignmentDeclaration(n);
                } else {
                    symbol.addFunctionDeclaration(n);
                }
            }
            ObjectType prototype = type.getPrototype();
            for (String prop : prototype.getOwnPropertyNames()) {
                NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(name + ".prototype." + prop, this.isExtern);
            }
            return symbol;
        }
    }
}

