/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.Sets;
import closurecompiler.internal.com.google.common.primitives.Chars;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.rhino.TokenStream;

final class NameGenerator {
    static final char[] FIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$".toCharArray();
    static final char[] NONFIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789$".toCharArray();
    private final Set<String> reservedNames;
    private final String prefix;
    private int nameCount;
    private final char[] firstChars;
    private final char[] nonFirstChars;

    NameGenerator(Set<String> reservedNames, String prefix, char[] reservedCharacters) {
        this.reservedNames = reservedNames;
        this.prefix = prefix;
        this.firstChars = NameGenerator.reserveCharacters(FIRST_CHAR, reservedCharacters);
        this.nonFirstChars = NameGenerator.reserveCharacters(NONFIRST_CHAR, reservedCharacters);
        this.checkPrefix(prefix);
    }

    static char[] reserveCharacters(char[] chars, char[] reservedCharacters) {
        if (reservedCharacters == null || reservedCharacters.length == 0) {
            return chars;
        }
        LinkedHashSet<Character> charSet = Sets.newLinkedHashSet(Chars.asList(chars));
        for (char reservedCharacter : reservedCharacters) {
            charSet.remove(Character.valueOf(reservedCharacter));
        }
        return Chars.toArray(charSet);
    }

    private void checkPrefix(String prefix) {
        if (prefix.length() > 0) {
            if (!this.contains(this.firstChars, prefix.charAt(0))) {
                throw new IllegalArgumentException("prefix must start with one of: " + Arrays.toString(this.firstChars));
            }
            for (int pos = 1; pos < prefix.length(); ++pos) {
                if (this.contains(this.nonFirstChars, prefix.charAt(pos))) continue;
                throw new IllegalArgumentException("prefix has invalid characters, must be one of: " + Arrays.toString(this.nonFirstChars));
            }
        }
    }

    private boolean contains(char[] arr, char c) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != c) continue;
            return true;
        }
        return false;
    }

    String generateNextName() {
        String name;
        do {
            int pos;
            name = this.prefix;
            int i = this.nameCount;
            if (name.isEmpty()) {
                pos = i % this.firstChars.length;
                name = name + this.firstChars[pos];
                i /= this.firstChars.length;
            }
            while (i > 0) {
                pos = --i % this.nonFirstChars.length;
                name = name + this.nonFirstChars[pos];
                i /= this.nonFirstChars.length;
            }
            ++this.nameCount;
        } while (TokenStream.isKeyword(name) || this.reservedNames.contains(name));
        return name;
    }
}

